(software_release_v1)=
# Release v1.0 (2024/06/06)

## 💫 Highlights

* 🎉 **Release of Clay Foundation Model v1.0** 🎉

## 🚀 Model

* Datamodule & Model for Clay v1 by @srmsoumya in https://github.com/Clay-foundation/model/pull/253

## 🗃️ Data Pipeline

* Moved data pipeline code into [stacchip](https://github.com/Clay-foundation/stacchip) a dedicated library for the data wrangling

## 📖 Documentation

* Clay over aoi by @yellowcap in https://github.com/Clay-foundation/model/pull/116
* Convert run-over-aoi ipynb to md by @yellowcap in https://github.com/Clay-foundation/model/pull/122
* Static Documentation for v0.1 by @brunosan in https://github.com/Clay-foundation/model/pull/118
* Document data sampling strategy by @yellowcap in https://github.com/Clay-foundation/model/pull/124
* Updating location to download imagery script in docs by @MaxLenormand in https://github.com/Clay-foundation/model/pull/198
* Change "Radiant Earth Foundation" to "Radiant Earth" in docs by @kbgg in https://github.com/Clay-foundation/model/pull/214
* Update instructions to re-lock conda-lock.yml file by @weiji14 in https://github.com/Clay-foundation/model/pull/225
* chore(docs): correct typos and improve stylistic consistency by @kelseyjosund in https://github.com/Clay-foundation/model/pull/232
* Partial inputs - Pakistan flood tutorial by @lillythomas in https://github.com/Clay-foundation/model/pull/154
* Obtain patch level metadata (e.g. geospatial bounds and cloud cover), save and demo DEP use case (sim search) by @lillythomas in https://github.com/Clay-foundation/model/pull/172
* Obtain patch level cloud coverage percentages by @lillythomas in https://github.com/Clay-foundation/model/pull/184
* Tutorial on burn scar analysis using embeddings from partial inputs by @yellowcap in https://github.com/Clay-foundation/model/pull/149
* Doc updates by @brunosan in https://github.com/Clay-foundation/model/pull/230
* Update specification.md by @brunosan in https://github.com/Clay-foundation/model/pull/250
* Add notebook showing how to run v1 by @yellowcap in https://github.com/Clay-foundation/model/pull/254
* Documented v1 sampling strategy by @yellowcap in https://github.com/Clay-foundation/model/pull/249
* Updates the mamba install instructions link. by @dbonomo in https://github.com/Clay-foundation/model/pull/252
* Remove clay-v0-tutorials & add visualize embeddings for v1 by @srmsoumya in https://github.com/Clay-foundation/model/pull/256
* Minor spelling fix by @tylere in https://github.com/Clay-foundation/model/pull/260
* Shorten comment line length by @yellowcap in https://github.com/Clay-foundation/model/pull/261
* Refactor docs by moving v0 docs into separate section by @yellowcap in https://github.com/Clay-foundation/model/pull/262
* Docs v1 continued by @yellowcap in https://github.com/Clay-foundation/model/pull/263
* Documented metadata file for normalization and wavelengths by @yellowcap in https://github.com/Clay-foundation/model/pull/266
* [small change] add source.coop link by @brunosan in https://github.com/Clay-foundation/model/pull/137
* Segmentation on Clay by @srmsoumya in https://github.com/Clay-foundation/model/pull/257

## 🧰 Maintenance

* [pre-commit.ci] pre-commit autoupdate by @pre-commit-ci in https://github.com/Clay-foundation/model/pull/206
* Bump conda-lock from 2.5.1 to 2.5.6 by @weiji14 in https://github.com/Clay-foundation/model/pull/183
* Remove scripts folder by @yellowcap in https://github.com/Clay-foundation/model/pull/265
* Unified v1 and v0 environments by @yellowcap in https://github.com/Clay-foundation/model/pull/264
* Add osx-arm64 platform to conda-lock.yml file and GitHub Actions CI by @weiji14 in https://github.com/Clay-foundation/model/pull/164
* Move pipeline scripts into dedicated folder by @yellowcap in https://github.com/Clay-foundation/model/pull/163
* Memory buildup clean by @brunosan in https://github.com/Clay-foundation/model/pull/158
* Add osx platform to conda lock file and CI by @chuckwondo in https://github.com/Clay-foundation/model/pull/162
* Add scikit-learn by @weiji14 in https://github.com/Clay-foundation/model/pull/159
* Remove float16 dype in favor of float32 by @yellowcap in https://github.com/Clay-foundation/model/pull/143
* Remove stale bands argument from clay model classes by @yellowcap in https://github.com/Clay-foundation/model/pull/144

## :hammer_and_wrench: v0.2 updates

* Add normalization parameters to documentation by @yellowcap in https://github.com/Clay-foundation/model/pull/152
* Worldcover embeddings conus by @yellowcap in https://github.com/Clay-foundation/model/pull/153
* Create data/minicubes directory if it doesn't already exist by @weiji14 in https://github.com/Clay-foundation/model/pull/160
* Clay pipeline v04 by @yellowcap in https://github.com/Clay-foundation/model/pull/173
* Shuffle patches only during training by @yellowcap in https://github.com/Clay-foundation/model/pull/135
* Add option to output raw patch embeddings by @yellowcap in https://github.com/Clay-foundation/model/pull/133

## 🧑‍🤝‍🧑 New Contributors

* @chuckwondo made their first contribution in https://github.com/Clay-foundation/model/pull/162
* @MaxLenormand made their first contribution in https://github.com/Clay-foundation/model/pull/198
* @kbgg made their first contribution in https://github.com/Clay-foundation/model/pull/214
* @kelseyjosund made their first contribution in https://github.com/Clay-foundation/model/pull/232
* @dbonomo made their first contribution in https://github.com/Clay-foundation/model/pull/252
* @tylere made their first contribution in https://github.com/Clay-foundation/model/pull/260

**Full Changelog**: https://github.com/Clay-foundation/model/compare/v0.0.1...v1.0
