/*
 * Decompiled with CFR 0.152.
 */
package sleeper.main;

import java.text.DecimalFormat;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import sleeper.main.Main;

public class EventHandlers
implements Listener {
    DecimalFormat dfrmt = new DecimalFormat();
    Main plugin;

    public EventHandlers(Main plugin) {
        this.plugin = plugin;
        this.dfrmt.setMaximumFractionDigits(2);
    }

    @EventHandler
    public void onBedEnter(PlayerBedEnterEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.blockBedsAfterVoting && this.plugin.voting.contains(player.getWorld().getName()) && this.plugin.hasVoted(player)) {
            event.setCancelled(true);
            this.plugin.voteYes(player);
            return;
        }
        this.plugin.sleep(player);
    }

    @EventHandler
    public void onBedExit(PlayerBedLeaveEvent event) {
        Player player = event.getPlayer();
        float wsleeping = this.plugin.sleepingWorlds.getOrDefault(player.getWorld().getName(), Float.valueOf(0.0f)).floatValue();
        float wonline = this.plugin.playersOnline.getOrDefault(player.getWorld().getName(), Float.valueOf(0.0f)).floatValue();
        if (wsleeping > 0.0f) {
            this.plugin.sleepingWorlds.put(player.getWorld().getName(), Float.valueOf(wsleeping - 1.0f));
        }
        if (!this.plugin.recentlySkipped.contains(player.getWorld().getName())) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.sleepInfo.replace("%percent%", this.dfrmt.format(wsleeping / wonline * 100.0f) + "%").replace("%count%", this.dfrmt.format(wsleeping))));
        }
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        float wsleeping;
        Player player = event.getPlayer();
        if (player.isSleeping() && (wsleeping = this.plugin.sleepingWorlds.getOrDefault(player.getWorld().getName(), Float.valueOf(0.0f)).floatValue()) > 0.0f) {
            this.plugin.sleepingWorlds.put(player.getWorld().getName(), Float.valueOf(wsleeping - 1.0f));
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.ignorePlayers.contains(player.getUniqueId())) {
            float wsleeping = this.plugin.sleepingWorlds.getOrDefault(player.getWorld().getName(), Float.valueOf(0.0f)).floatValue();
            float wonline = this.plugin.playersOnline.getOrDefault(player.getWorld().getName(), Float.valueOf(0.0f)).floatValue();
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.ignored.replace("%percent%", this.dfrmt.format(wsleeping / wonline * 100.0f) + "%").replace("%count%", this.dfrmt.format(wsleeping))));
        }
    }
}

