/*
 * Decompiled with CFR 0.152.
 */
package sleeper.main;

import java.util.StringJoiner;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import sleeper.main.EventHandlers;
import sleeper.main.Main;

public class Commands
implements CommandExecutor {
    Main plugin;
    EventHandlers eventhandlers;

    public Commands(Main plugin, EventHandlers eventhandler) {
        this.plugin = plugin;
        this.eventhandlers = eventhandler;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String command, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be run by players.");
            return true;
        }
        Player player = (Player)sender;
        block3 : switch (cmd.getName().toLowerCase()) {
            case "sleep": {
                if (args.length < 1) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.playerHelpMsg(player)));
                    break;
                }
                switch (args[0].toLowerCase()) {
                    case "yes": {
                        if (!player.hasPermission("sleeper.vote")) {
                            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.noPermission));
                            break block3;
                        }
                        this.plugin.voteYes(player);
                        break block3;
                    }
                    case "no": {
                        if (!player.hasPermission("sleeper.vote")) {
                            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.noPermission));
                            break block3;
                        }
                        this.plugin.voteNo(player);
                        break block3;
                    }
                    case "votes": {
                        if (!player.hasPermission("sleeper.vote")) {
                            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.noPermission));
                            break block3;
                        }
                        this.plugin.showVotes(player);
                        break block3;
                    }
                    case "ignore": {
                        if (!player.hasPermission("sleeper.ignore")) {
                            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.noPermission));
                            break block3;
                        }
                        if (this.plugin.ignorePlayers.contains(player.getUniqueId())) {
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You are no longer ignored from sleeping");
                            this.plugin.ignorePlayers.remove(player.getUniqueId());
                            break block3;
                        }
                        player.sendMessage(String.valueOf(ChatColor.RED) + "You are now ignored from sleeping");
                        this.plugin.ignorePlayers.add(player.getUniqueId());
                        break block3;
                    }
                    case "debug": {
                        if (!player.hasPermission("sleeper.data")) {
                            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.noPermission));
                            break block3;
                        }
                        if (this.plugin.debugPlayers.contains(player.getUniqueId())) {
                            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "DEBUG: " + String.valueOf(ChatColor.GRAY) + "Debug disabled");
                            this.plugin.debugPlayers.remove(player.getUniqueId());
                        } else {
                            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "DEBUG: " + String.valueOf(ChatColor.GRAY) + "Debug enabled");
                            this.plugin.debugPlayers.add(player.getUniqueId());
                        }
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Sleep data:");
                        if (player.getGameMode().equals((Object)GameMode.SPECTATOR) || player.getGameMode().equals((Object)GameMode.CREATIVE)) {
                            player.sendMessage(String.valueOf(ChatColor.GRAY) + "Note: you will be ignored from sleep calculations in spectator or creative mode.");
                        }
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Sleeping per world: ");
                        this.plugin.sleepingWorlds.keySet().forEach(world -> player.sendMessage(String.valueOf(ChatColor.GRAY) + world + " - " + this.plugin.sleepingWorlds.get(world).toString()));
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Latest 'online' player count per world: ");
                        this.plugin.playersOnline.keySet().forEach(world -> player.sendMessage(String.valueOf(ChatColor.GRAY) + world + " - " + this.plugin.playersOnline.get(world).toString()));
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "True online player count: " + String.valueOf(ChatColor.GRAY) + Bukkit.getOnlinePlayers().size());
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Skipping: " + String.valueOf(ChatColor.GRAY) + this.plugin.skipping.toString());
                        int onlineIgnored = this.plugin.getOnlineIgnorers().size();
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Ignored player count: " + String.valueOf(ChatColor.GRAY) + onlineIgnored);
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Ignoring players: ");
                        this.plugin.getOnlineIgnorers().forEach(p -> player.sendMessage(String.valueOf(ChatColor.GRAY) + p.getDisplayName()));
                        break block3;
                    }
                    case "reload": {
                        if (!player.hasPermission("sleeper.reload")) {
                            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.noPermission));
                            break block3;
                        }
                        this.plugin.loadConfig();
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Sleep config reloaded.");
                        break block3;
                    }
                }
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.playerHelpMsg(player)));
                break;
            }
            default: {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.playerHelpMsg(player)));
            }
        }
        return true;
    }

    private String playerHelpMsg(Player player) {
        StringJoiner builder = new StringJoiner(", ");
        if (player.hasPermission("sleeper.vote")) {
            builder.add("yes, no, votes");
        }
        if (player.hasPermission("sleeper.ignore")) {
            builder.add("ignore");
        }
        if (player.hasPermission("sleeper.data")) {
            builder.add("debug");
        }
        if (player.hasPermission("sleeper.reload")) {
            builder.add("reload");
        }
        return this.plugin.sleepHelpList + builder.toString();
    }
}

