/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.proxy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import net.theawesomegem.fishingmadebetter.common.block.BlockManager;
import net.theawesomegem.fishingmadebetter.common.capability.CapabilityHandler;
import net.theawesomegem.fishingmadebetter.common.capability.fishing.FishingData;
import net.theawesomegem.fishingmadebetter.common.capability.fishing.IFishingData;
import net.theawesomegem.fishingmadebetter.common.capability.world.ChunkFishingData;
import net.theawesomegem.fishingmadebetter.common.capability.world.ChunkFishingStorage;
import net.theawesomegem.fishingmadebetter.common.capability.world.IChunkFishingData;
import net.theawesomegem.fishingmadebetter.common.command.FishingCommand;
import net.theawesomegem.fishingmadebetter.common.configuration.ConfigurationManager;
import net.theawesomegem.fishingmadebetter.common.configuration.CustomConfigurationHandler;
import net.theawesomegem.fishingmadebetter.common.entity.EntityManager;
import net.theawesomegem.fishingmadebetter.common.event.FishingEventHandler;
import net.theawesomegem.fishingmadebetter.common.item.ItemManager;
import net.theawesomegem.fishingmadebetter.common.loottable.LootHandler;
import net.theawesomegem.fishingmadebetter.common.networking.PrimaryPacketHandler;
import net.theawesomegem.fishingmadebetter.common.recipe.RecipeBaitBucket;
import net.theawesomegem.fishingmadebetter.common.recipe.RecipeBaitedRod;
import net.theawesomegem.fishingmadebetter.common.recipe.RecipeFishBucket;
import net.theawesomegem.fishingmadebetter.common.recipe.RecipeFishScale;
import net.theawesomegem.fishingmadebetter.common.recipe.RecipeFishSliceRaw;
import net.theawesomegem.fishingmadebetter.common.recipe.RecipeRodAttachment;
import net.theawesomegem.fishingmadebetter.util.HandlerUtil;
import net.theawesomegem.fishingmadebetter.util.RebornCraftingHelper;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class CommonProxy {
    public static Logger Logger;

    public void onPreInit(FMLPreInitializationEvent e) {
        Logger = e.getModLog();
        CustomConfigurationHandler.preInit(e.getModConfigurationDirectory());
        PrimaryPacketHandler.registerPackets();
        EntityManager.register();
    }

    public void onInit(FMLInitializationEvent e) {
        this.registerCapabilities();
        this.registerEvents();
        this.registerRecipes();
    }

    public void onPostInit(FMLPostInitializationEvent e) {
        CustomConfigurationHandler.postInit();
        LootHandler.registerLootTable();
        if (Loader.isModLoaded((String)"levelup2") && ConfigurationManager.server.levelUpPatch) {
            try {
                HandlerUtil.findAndRemoveHandlerFromEventBus("levelup2.skills.crafting.FishingLootBonus", "onFishInteract");
                HandlerUtil.findAndRemoveHandlerFromEventBus("levelup2.event.CraftingSkillHandler", "onFishInteract");
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }
    }

    public void onServerStarting(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new FishingCommand());
    }

    private void registerCapabilities() {
        CapabilityManager.INSTANCE.register(IChunkFishingData.class, (Capability.IStorage)new ChunkFishingStorage(), ChunkFishingData::new);
        CapabilityManager.INSTANCE.register(IFishingData.class, (Capability.IStorage)new Capability.IStorage<IFishingData>(){

            @Nullable
            public NBTBase writeNBT(Capability<IFishingData> capability, IFishingData instance, EnumFacing side) {
                return new NBTTagCompound();
            }

            public void readNBT(Capability<IFishingData> capability, IFishingData instance, EnumFacing side, NBTBase nbt) {
            }
        }, FishingData::new);
    }

    protected void registerEvents() {
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityHandler());
        MinecraftForge.EVENT_BUS.register((Object)new FishingEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new LootHandler());
    }

    protected void registerRecipes() {
        Iterator smeltingIterator;
        Map smeltingRecipes;
        ArrayList<IRecipe> craftingRecipesRemove;
        IForgeRegistry recipeRegistry = GameRegistry.findRegistry(IRecipe.class);
        recipeRegistry.register(new RecipeFishSliceRaw().setRegistryName(new ResourceLocation("fishingmadebetter", "fish_slice_raw")));
        recipeRegistry.register(new RecipeFishScale().setRegistryName(new ResourceLocation("fishingmadebetter", "fish_scale")));
        recipeRegistry.register(new RecipeBaitedRod().setRegistryName(new ResourceLocation("fishingmadebetter", "baited_rod")));
        recipeRegistry.register(new RecipeRodAttachment().setRegistryName(new ResourceLocation("fishingmadebetter", "rod_attachment")));
        recipeRegistry.register(new RecipeBaitBucket().setRegistryName(new ResourceLocation("fishingmadebetter", "baited_bucket")));
        if (ConfigurationManager.server.enableFishBucket) {
            recipeRegistry.register(new RecipeFishBucket().setRegistryName(new ResourceLocation("fishingmadebetter", "fish_bucket")));
            RebornCraftingHelper.addShapelessRecipe(new ItemStack(Items.field_151133_ar), new Object[]{ItemManager.FISH_BUCKET});
        }
        RebornCraftingHelper.addSmelting(new ItemStack((Item)ItemManager.FISH_SLICE_RAW), new ItemStack((Item)ItemManager.FISH_SLICE_COOKED));
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.REEL_BASIC, 1), "SIS", "IWI", "SIS", Character.valueOf('S'), "string", Character.valueOf('I'), "ingotIron", Character.valueOf('W'), "stickWood");
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.REEL_FAST, 1), new Object[]{"SIS", "IWI", "SIS", Character.valueOf('S'), "dustRedstone", Character.valueOf('I'), "ingotGold", Character.valueOf('W'), ItemManager.REEL_BASIC});
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.REEL_LONG, 1), new Object[]{"SSS", "SWS", "SSS", Character.valueOf('S'), "string", Character.valueOf('W'), ItemManager.REEL_BASIC});
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.BOBBER_BASIC, 1), " W ", " R ", " W ", Character.valueOf('W'), new ItemStack(Blocks.field_150325_L, 1, 0), Character.valueOf('R'), new ItemStack(Blocks.field_150325_L, 1, 14));
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.BOBBER_HEAVY, 1), new Object[]{"III", "IBI", "III", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), ItemManager.BOBBER_BASIC});
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.BOBBER_LIGHTWEIGHT, 1), " S ", " R ", " S ", Character.valueOf('S'), "string", Character.valueOf('R'), new ItemStack(Blocks.field_150325_L, 1, 14));
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.BOBBER_OBSIDIAN, 1), new Object[]{"OSO", "OBO", "OSO", Character.valueOf('S'), "string", Character.valueOf('O'), "obsidian", Character.valueOf('B'), ItemManager.BOBBER_BASIC});
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.BOBBER_VOID, 1), new Object[]{"OSO", "OBO", "OSO", Character.valueOf('S'), "string", Character.valueOf('O'), "enderpearl", Character.valueOf('B'), ItemManager.BOBBER_BASIC});
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.HOOK_BASIC, 1), "  S", "S S", " S ", Character.valueOf('S'), "nuggetIron");
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.HOOK_BARBED, 1), new Object[]{" S ", " S ", "HIH", Character.valueOf('S'), "nuggetIron", Character.valueOf('I'), "ingotIron", Character.valueOf('H'), ItemManager.HOOK_BASIC});
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.HOOK_FATTY, 1), new Object[]{" S ", "IHI", " I ", Character.valueOf('S'), "nuggetIron", Character.valueOf('I'), Items.field_151083_be, Character.valueOf('H'), ItemManager.HOOK_BASIC});
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.HOOK_MAGNETIC, 1), new Object[]{" S ", "IHI", "R B", Character.valueOf('S'), "nuggetIron", Character.valueOf('I'), "ingotIron", Character.valueOf('H'), ItemManager.HOOK_BARBED, Character.valueOf('B'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('R'), new ItemStack(Items.field_151100_aR, 1, 1)});
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.HOOK_SHINY, 1), new Object[]{" S ", "SHS", " S ", Character.valueOf('S'), "gemDiamond", Character.valueOf('H'), ItemManager.HOOK_BASIC});
        RebornCraftingHelper.addShapelessRecipe(new ItemStack((Item)ItemManager.FISHING_ROD_WOOD, 1), new Object[]{Items.field_151112_aM, ItemManager.BOBBER_BASIC, ItemManager.REEL_BASIC, ItemManager.HOOK_BASIC});
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.FISHING_ROD_WOOD, 1), new Object[]{"  S", " SB", "SRH", Character.valueOf('S'), "stickWood", Character.valueOf('B'), ItemManager.BOBBER_BASIC, Character.valueOf('R'), ItemManager.REEL_BASIC, Character.valueOf('H'), ItemManager.HOOK_BASIC});
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.FISHING_ROD_IRON, 1), new Object[]{"  S", " SB", "SRH", Character.valueOf('S'), "ingotIron", Character.valueOf('B'), ItemManager.BOBBER_BASIC, Character.valueOf('R'), ItemManager.REEL_BASIC, Character.valueOf('H'), ItemManager.HOOK_BASIC});
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.FISHING_ROD_DIAMOND, 1), new Object[]{"  S", " SB", "SRH", Character.valueOf('S'), "gemDiamond", Character.valueOf('B'), ItemManager.BOBBER_BASIC, Character.valueOf('R'), ItemManager.REEL_BASIC, Character.valueOf('H'), ItemManager.HOOK_BASIC});
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.FILLET_KNIFE_WOOD, 1), "  I", " IF", "S  ", Character.valueOf('I'), "plankWood", Character.valueOf('S'), "stickWood", Character.valueOf('F'), Items.field_151145_ak);
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.FILLET_KNIFE_IRON, 1), "  I", " IF", "S  ", Character.valueOf('I'), "ingotIron", Character.valueOf('S'), "stickWood", Character.valueOf('F'), Items.field_151145_ak);
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.FILLET_KNIFE_DIAMOND, 1), "  I", " IF", "S  ", Character.valueOf('I'), "gemDiamond", Character.valueOf('S'), "stickWood", Character.valueOf('F'), Items.field_151145_ak);
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.SCALING_KNIFE_WOOD, 1), " FF", "SII", "   ", Character.valueOf('I'), "plankWood", Character.valueOf('S'), "stickWood", Character.valueOf('F'), Items.field_151145_ak);
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.SCALING_KNIFE_IRON, 1), " FF", "SII", "   ", Character.valueOf('I'), "ingotIron", Character.valueOf('S'), "stickWood", Character.valueOf('F'), Items.field_151145_ak);
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.SCALING_KNIFE_DIAMOND, 1), " FF", "SII", "   ", Character.valueOf('I'), "gemDiamond", Character.valueOf('S'), "stickWood", Character.valueOf('F'), Items.field_151145_ak);
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.FISH_TRACKER_IRON, 1), " F ", "IGI", "III", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "paneGlass", Character.valueOf('F'), Items.field_151137_ax);
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.FISH_TRACKER_GOLD, 1), " F ", "IGI", "III", Character.valueOf('I'), "ingotGold", Character.valueOf('G'), "paneGlass", Character.valueOf('F'), Items.field_151137_ax);
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.FISH_TRACKER_DIAMOND, 1), " F ", "IGI", "III", Character.valueOf('I'), "gemDiamond", Character.valueOf('G'), "paneGlass", Character.valueOf('F'), Items.field_151137_ax);
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.FISH_TRACKER_OBSIDIAN, 1), new Object[]{" O ", "ODO", " O ", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('D'), ItemManager.FISH_TRACKER_DIAMOND});
        RebornCraftingHelper.addShapedOreRecipe(new ItemStack((Item)ItemManager.FISH_TRACKER_VOID, 1), new Object[]{" O ", "ODO", " O ", Character.valueOf('O'), Items.field_151061_bv, Character.valueOf('D'), ItemManager.FISH_TRACKER_DIAMOND});
        RebornCraftingHelper.addShapedRecipe(new ItemStack((Item)BlockManager.ITEM_BLOCK_BAIT_BOX, 1), "WIW", "I I", "WWW", Character.valueOf('W'), "plankWood", Character.valueOf('I'), Blocks.field_150411_aY);
        RebornCraftingHelper.addShapedRecipe(new ItemStack((Item)ItemManager.BAIT_BUCKET, 1), "SES", "EBE", "SES", Character.valueOf('S'), Items.field_151014_N, Character.valueOf('E'), Items.field_151070_bp, Character.valueOf('B'), Items.field_151133_ar);
        IForgeRegistryModifiable craftingRegistry = (IForgeRegistryModifiable)recipeRegistry;
        if (Loader.isModLoaded((String)"aquaculture") && ConfigurationManager.server.aquacultureRecipeOverride) {
            craftingRegistry.remove(new ResourceLocation("aquaculture:wooden_rod_from_vanilla_rod"));
            craftingRegistry.remove(new ResourceLocation("aquaculture:vanilla_rod_from_wooden_rod"));
            craftingRegistry.remove(new ResourceLocation("aquaculture:iron_fishing_rod"));
            craftingRegistry.remove(new ResourceLocation("aquaculture:golden_fishing_rod"));
            craftingRegistry.remove(new ResourceLocation("aquaculture:diamond_fishing_rod"));
            craftingRegistry.remove(new ResourceLocation("aquaculture:ink_from_squid"));
            craftingRegistry.remove(new ResourceLocation("aquaculture:red_mushroom_from_red_shrooma"));
            craftingRegistry.remove(new ResourceLocation("aquaculture:brown_mushroom_from_fish"));
            craftingRegistry.remove(new ResourceLocation("aquaculture:gold_nugget_from_gold_fish"));
            int aqcCraftingRemoved = 9;
            craftingRecipesRemove = new ArrayList();
            for (IRecipe recipe : craftingRegistry.getValuesCollection()) {
                if (recipe.func_77571_b().func_77973_b() != Item.func_111206_d((String)"aquaculture:food")) continue;
                craftingRecipesRemove.add(recipe);
            }
            for (IRecipe removeRecipe : craftingRecipesRemove) {
                craftingRegistry.remove(removeRecipe.getRegistryName());
                ++aqcCraftingRemoved;
            }
            Logger.log(Level.INFO, "Removed " + aqcCraftingRemoved + " Aquaculture crafting recipes.");
            int aqcSmeltingRemoved = 0;
            smeltingRecipes = FurnaceRecipes.func_77602_a().func_77599_b();
            smeltingIterator = smeltingRecipes.keySet().iterator();
            while (smeltingIterator.hasNext()) {
                if (((ItemStack)smeltingIterator.next()).func_77973_b() != Item.func_111206_d((String)"aquaculture:fish")) continue;
                smeltingIterator.remove();
                ++aqcSmeltingRemoved;
            }
            Logger.log(Level.INFO, "Removed " + aqcSmeltingRemoved + " Aquaculture smelting recipes.");
            RebornCraftingHelper.addSmelting(new ItemStack(Item.func_111206_d((String)"aquaculture:fish"), 1, 18), new ItemStack(Item.func_111206_d((String)"aquaculture:food"), 1, 9));
            RebornCraftingHelper.addShapelessRecipe(new ItemStack(Item.func_111206_d((String)"aquaculture:food"), 1, 6), Items.field_151025_P, Items.field_151025_P, new ItemStack(Item.func_111206_d((String)"aquaculture:food"), 1, 5));
            RebornCraftingHelper.addShapelessRecipe(new ItemStack(Item.func_111206_d((String)"aquaculture:food"), 1, 10), new Object[]{ItemManager.FISH_SLICE_RAW, new ItemStack(Item.func_111206_d((String)"aquaculture:food"), 1, 0)});
        }
        if (Loader.isModLoaded((String)"advanced-fishing") && ConfigurationManager.server.advancedFishingRecipeOverride) {
            int advCraftingRemoved = 0;
            craftingRecipesRemove = new ArrayList<IRecipe>();
            for (IRecipe recipe : craftingRegistry.getValuesCollection()) {
                if (!recipe.getRegistryName().func_110624_b().equalsIgnoreCase("advanced-fishing")) continue;
                craftingRecipesRemove.add(recipe);
            }
            for (IRecipe removeRecipe : craftingRecipesRemove) {
                craftingRegistry.remove(removeRecipe.getRegistryName());
                ++advCraftingRemoved;
            }
            Logger.log(Level.INFO, "Removed " + advCraftingRemoved + " AdvancedFishing crafting recipes.");
            int advSmeltingRemoved = 0;
            smeltingRecipes = FurnaceRecipes.func_77602_a().func_77599_b();
            smeltingIterator = smeltingRecipes.keySet().iterator();
            while (smeltingIterator.hasNext()) {
                if (((ItemStack)smeltingIterator.next()).func_77973_b() != Item.func_111206_d((String)"advanced-fishing:fish")) continue;
                smeltingIterator.remove();
                ++advSmeltingRemoved;
            }
            Logger.log(Level.INFO, "Removed " + advSmeltingRemoved + " AdvancedFishing smelting recipes.");
            RebornCraftingHelper.addShapelessRecipe(new ItemStack(Items.field_151129_at), new ItemStack(Item.func_111206_d((String)"advanced-fishing:fish"), 1, 1), Items.field_151133_ar);
        }
    }

    public IThreadListener getListener(MessageContext ctx) {
        return (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
    }

    public EntityPlayer getPlayer(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b;
    }
}

