/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.common.registry;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.theawesomegem.fishingmadebetter.common.block.BlockManager;
import net.theawesomegem.fishingmadebetter.common.item.ItemManager;

public class RegistryManager {

    @Mod.EventBusSubscriber
    public static class RegistryHandler {
        public static SoundEvent FISH_SPLASHING_EVENT;
        public static SoundEvent REELING_EVENT;

        @SubscribeEvent
        public static void onRegisterBlock(RegistryEvent.Register<Block> e) {
            BlockManager.registerBlocks((IForgeRegistry<Block>)e.getRegistry());
        }

        @SubscribeEvent
        public static void onRegisterItem(RegistryEvent.Register<Item> e) {
            BlockManager.registerItemBlocks((IForgeRegistry<Item>)e.getRegistry());
            ItemManager.register((IForgeRegistry<Item>)e.getRegistry());
        }

        @SubscribeEvent
        public static void onRegisterSound(RegistryEvent.Register<SoundEvent> e) {
            FISH_SPLASHING_EVENT = (SoundEvent)new SoundEvent(new ResourceLocation("fishingmadebetter", "fishsplashing")).setRegistryName("soundfishsplashing");
            REELING_EVENT = (SoundEvent)new SoundEvent(new ResourceLocation("fishingmadebetter", "reeling")).setRegistryName("soundreeling");
            e.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{FISH_SPLASHING_EVENT, REELING_EVENT});
        }
    }
}

