/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.common.item;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.theawesomegem.fishingmadebetter.common.capability.world.ChunkCapabilityProvider;
import net.theawesomegem.fishingmadebetter.common.capability.world.IChunkFishingData;
import net.theawesomegem.fishingmadebetter.common.capability.world.PopulationData;
import net.theawesomegem.fishingmadebetter.common.configuration.CustomConfigurationHandler;
import net.theawesomegem.fishingmadebetter.common.data.FishData;
import net.theawesomegem.fishingmadebetter.common.item.ItemManager;
import net.theawesomegem.fishingmadebetter.common.registry.FMBCreativeTab;

public class ItemFishBucket
extends Item {
    public ItemFishBucket() {
        this.field_77777_bU = 1;
        this.func_77637_a(FMBCreativeTab.instance);
        this.setRegistryName("fish_bucket");
        this.func_77655_b("fishingmadebetter.fish_bucket");
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        PopulationData populationData;
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, true);
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (raytraceresult == null || raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        String fishId = ItemFishBucket.getFishId(itemstack);
        if (fishId == null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        FishData fishData = CustomConfigurationHandler.fishDataMap.get(fishId);
        if (fishData == null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        BlockPos blockpos = raytraceresult.func_178782_a();
        IChunkFishingData chunkFishingData = this.getChunkFishingData(worldIn.func_175726_f(blockpos));
        if (chunkFishingData == null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        IBlockState blockState = worldIn.func_180495_p(blockpos);
        Material material = blockState.func_185904_a();
        if (material != MaterialLiquid.field_151586_h) {
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("notif.fishingmadebetter.fish_bucket.only_water", new Object[0]));
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        int waterCount = 0;
        for (BlockPos pos : BlockPos.func_191532_a((int)(blockpos.func_177958_n() - 2), (int)(blockpos.func_177956_o() - 3), (int)(blockpos.func_177952_p() - 2), (int)(blockpos.func_177958_n() + 2), (int)blockpos.func_177956_o(), (int)(blockpos.func_177952_p() + 2))) {
            Material mat = worldIn.func_180495_p(pos).func_185904_a();
            if (mat == MaterialLiquid.field_151586_h) {
                ++waterCount;
            }
            if (waterCount < 25) continue;
            break;
        }
        if (waterCount < 25) {
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("notif.fishingmadebetter.fish_bucket.small_water", new Object[0]));
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        if (fishData.minYLevel > blockpos.func_177956_o() || fishData.maxYLevel < blockpos.func_177956_o()) {
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("notif.fishingmadebetter.fish_bucket.wrong_altitude", new Object[0]));
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        Map<String, PopulationData> fishMap = chunkFishingData.getRawFishMap();
        if (!fishMap.containsKey(fishId)) {
            populationData = new PopulationData(fishId, 1, 0, worldIn.func_82737_E());
            fishMap.put(fishId, populationData);
        } else {
            populationData = fishMap.get(fishId);
            populationData.setQuantity(populationData.getQuantity() + 1);
        }
        chunkFishingData.setPopulationData(fishId, populationData, true);
        worldIn.func_184133_a(playerIn, blockpos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
        playerIn.func_184611_a(handIn, new ItemStack(Items.field_151133_ar));
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemModel(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public static ItemStack getItemStack(String fishId) {
        ItemStack itemStack = new ItemStack((Item)ItemManager.FISH_BUCKET, 1);
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("FishId", fishId);
        itemStack.func_77982_d(tagCompound);
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String fishId = ItemFishBucket.getFishId(itemStack);
        if (fishId == null) {
            return;
        }
        tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"item.fishingmadebetter.fish_bucket.tooltip", (Object[])new Object[0]) + ": " + TextFormatting.BOLD + fishId + TextFormatting.RESET);
    }

    @Nullable
    public static String getFishId(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            return null;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        return tagCompound.func_74764_b("FishId") ? tagCompound.func_74779_i("FishId") : null;
    }

    @Nullable
    private IChunkFishingData getChunkFishingData(Chunk chunk) {
        return (IChunkFishingData)chunk.getCapability(ChunkCapabilityProvider.CHUNK_FISHING_DATA_CAP, null);
    }
}

