/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.common.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FishData {
    public String fishId;
    public String itemId;
    public int itemMetaData;
    public String description;
    public int minFishTime;
    public int maxFishTime;
    public int minErrorVariance;
    public int maxErrorVariance;
    public int minWeight;
    public int maxWeight;
    public TimeToFish time;
    public FishingLiquid liquid;
    public boolean rainRequired;
    public boolean thunderRequired;
    public int rarity;
    public int minDeepLevel;
    public int maxDeepLevel;
    public int minYLevel;
    public int maxYLevel;
    public int maxLightLevel;
    public int reproductionTime;
    public int eatingFrequency;
    public boolean trackable;
    public boolean biomeBlacklist;
    public boolean dimensionBlacklist;
    public List<String> biomeTagList = new ArrayList<String>();
    public List<Integer> dimensionList = new ArrayList<Integer>();
    public int timeOutsideOfWater;
    public boolean allowScaling;
    public String scalingItem;
    public int scalingItemMetadata;
    public boolean scalingUseWeight;
    public boolean allowFillet;
    public boolean defaultFillet;
    public String filletItem;
    public int filletItemMetadata;
    public boolean filletUseWeight;
    public Map<String, Integer[]> baitItemMap = new HashMap<String, Integer[]>();

    public static FishData createData(String fishId, String itemId, int itemMetaData, String description, int minFishTime, int maxFishTime, int minErrorVariance, int maxErrorVariance, int minWeight, int maxWeight, TimeToFish time, FishingLiquid liquid, boolean rainRequired, boolean thunderRequired, int rarity, int minDeepLevel, int maxDeepLevel, int minYLevel, int maxYLevel, int maxLightLevel, int reproductionTime, int eatingFrequency, boolean trackable, boolean biomeBlacklist, boolean dimensionBlacklist, String[] biomeTagList, int[] dimensionList, int timeOutsideOfWater, boolean allowScaling, String scalingItem, int scalingItemMetadata, boolean scalingUseWeight, boolean allowFillet, boolean defaultFillet, String filletItem, int filletItemMetadata, boolean filletUseWeight, BaitEnum[] baitEnumArray) {
        FishData fishData = new FishData();
        fishData.fishId = fishId;
        fishData.itemId = itemId;
        fishData.itemMetaData = itemMetaData;
        fishData.description = description;
        fishData.minFishTime = minFishTime;
        fishData.maxFishTime = maxFishTime;
        fishData.minErrorVariance = minErrorVariance;
        fishData.maxErrorVariance = maxErrorVariance;
        fishData.minWeight = minWeight;
        fishData.maxWeight = maxWeight;
        fishData.time = time;
        fishData.liquid = liquid;
        fishData.rainRequired = rainRequired;
        fishData.thunderRequired = thunderRequired;
        fishData.rarity = rarity;
        fishData.minDeepLevel = minDeepLevel;
        fishData.maxDeepLevel = maxDeepLevel;
        fishData.minYLevel = minYLevel;
        fishData.maxYLevel = maxYLevel;
        fishData.maxLightLevel = maxLightLevel;
        fishData.reproductionTime = reproductionTime;
        fishData.eatingFrequency = eatingFrequency;
        fishData.trackable = trackable;
        fishData.biomeBlacklist = biomeBlacklist;
        fishData.dimensionBlacklist = dimensionBlacklist;
        fishData.biomeTagList = new ArrayList<String>();
        for (String string : biomeTagList) {
            fishData.biomeTagList.add(string);
        }
        fishData.dimensionList = new ArrayList<Integer>();
        for (int n : dimensionList) {
            fishData.dimensionList.add(n);
        }
        fishData.timeOutsideOfWater = timeOutsideOfWater;
        fishData.allowScaling = allowScaling;
        fishData.scalingItem = scalingItem;
        fishData.scalingItemMetadata = scalingItemMetadata;
        fishData.scalingUseWeight = scalingUseWeight;
        fishData.allowFillet = allowFillet;
        fishData.defaultFillet = defaultFillet;
        fishData.filletItem = filletItem;
        fishData.filletItemMetadata = filletItemMetadata;
        fishData.filletUseWeight = filletUseWeight;
        for (BaitEnum baitEnum : baitEnumArray) {
            fishData.baitItemMap.putAll(baitEnum.getValues(baitEnum));
        }
        return fishData;
    }

    public static enum BaitEnum {
        FRUIT,
        GRAIN,
        VEGETABLE,
        MEAT_NORMAL,
        MEAT_EXTRA,
        SMALL_PREDATOR_AQC,
        LARGE_PREDATOR_AQC,
        OCEAN_PREDATOR_AQC,
        HERBIVORE_AQC;

        Map<String, Integer[]> fruit = new HashMap<String, Integer[]>(){
            {
                this.put("minecraft:apple", new Integer[]{0});
                this.put("minecraft:melon", new Integer[]{0});
            }
        };
        Map<String, Integer[]> grain = new HashMap<String, Integer[]>(){
            {
                this.put("minecraft:wheat_seeds", new Integer[]{0});
                this.put("minecraft:pumpkin_seeds", new Integer[]{0});
                this.put("minecraft:melon_seeds", new Integer[]{0});
                this.put("minecraft:beetroot_seeds", new Integer[]{0});
            }
        };
        Map<String, Integer[]> vegetable = new HashMap<String, Integer[]>(){
            {
                this.put("minecraft:carrot", new Integer[]{0});
                this.put("minecraft:potato", new Integer[]{0});
                this.put("minecraft:beetroot", new Integer[]{0});
            }
        };
        Map<String, Integer[]> meatNormal = new HashMap<String, Integer[]>(){
            {
                this.put("minecraft:fish", new Integer[]{2});
                this.put("minecraft:spider_eye", new Integer[]{0});
                this.put("minecraft:rotten_flesh", new Integer[]{0});
            }
        };
        Map<String, Integer[]> meatExtra = new HashMap<String, Integer[]>(){
            {
                this.put("minecraft:porkchop", new Integer[]{0});
                this.put("minecraft:beef", new Integer[]{0});
                this.put("minecraft:chicken", new Integer[]{0});
                this.put("minecraft:rabbit", new Integer[]{0});
                this.put("minecraft:mutton", new Integer[]{0});
            }
        };
        Map<String, Integer[]> small_predator_aqc = new HashMap<String, Integer[]>(){
            {
                this.put("aquaculture:fish", new Integer[]{19, 37});
            }
        };
        Map<String, Integer[]> large_predator_aqc = new HashMap<String, Integer[]>(){
            {
                this.put("aquaculture:fish", new Integer[]{0, 1, 17});
            }
        };
        Map<String, Integer[]> ocean_predator_aqc = new HashMap<String, Integer[]>(){
            {
                this.put("aquaculture:fish", new Integer[]{9, 10, 15, 16, 26});
            }
        };
        Map<String, Integer[]> herbivore_aqc = new HashMap<String, Integer[]>(){
            {
                this.put("aquaculture:food", new Integer[]{0, 1});
            }
        };

        public Map<String, Integer[]> getValues(BaitEnum value) {
            switch (value) {
                case FRUIT: {
                    return this.fruit;
                }
                case GRAIN: {
                    return this.grain;
                }
                case VEGETABLE: {
                    return this.vegetable;
                }
                case MEAT_NORMAL: {
                    return this.meatNormal;
                }
                case MEAT_EXTRA: {
                    return this.meatExtra;
                }
                case SMALL_PREDATOR_AQC: {
                    return this.small_predator_aqc;
                }
                case LARGE_PREDATOR_AQC: {
                    return this.large_predator_aqc;
                }
                case OCEAN_PREDATOR_AQC: {
                    return this.ocean_predator_aqc;
                }
                case HERBIVORE_AQC: {
                    return this.herbivore_aqc;
                }
            }
            return this.vegetable;
        }
    }

    public static enum FishingLiquid {
        WATER,
        LAVA,
        VOID,
        ANY;

    }

    public static enum TimeToFish {
        DAY,
        NIGHT,
        ANY;

    }
}

