/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.common.capability.world;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import net.theawesomegem.fishingmadebetter.common.capability.world.IChunkFishingData;
import net.theawesomegem.fishingmadebetter.common.capability.world.PopulationData;
import net.theawesomegem.fishingmadebetter.common.configuration.ConfigurationManager;
import net.theawesomegem.fishingmadebetter.common.configuration.CustomConfigurationHandler;
import net.theawesomegem.fishingmadebetter.common.data.FishData;
import net.theawesomegem.fishingmadebetter.util.RandomUtil;
import net.theawesomegem.fishingmadebetter.util.TimeUtil;

public class ChunkFishingData
implements IChunkFishingData {
    private final Map<String, PopulationData> fishPopulationMap;
    private final Map<String, BiomeDictionary.Type> byName = new HashMap<String, BiomeDictionary.Type>();
    private Chunk chunk;
    private World world;
    private long timeSinceRegenerated;
    private long timeSinceReproduction;

    public ChunkFishingData() {
        this.fishPopulationMap = new HashMap<String, PopulationData>();
    }

    @Override
    public void chunkLoad(Chunk chunk) {
        this.world = chunk.func_177412_p();
        this.chunk = chunk;
        this.timeSinceReproduction = this.world.func_82737_E();
        this.checkForRegeneration(this.world.func_82737_E());
    }

    @Override
    public void addFishes(Map<String, PopulationData> fishMap, boolean markDirty) {
        this.fishPopulationMap.clear();
        this.fishPopulationMap.putAll(fishMap);
        if (markDirty && this.chunk != null) {
            this.chunk.func_76630_e();
        }
    }

    @Override
    public Map<String, PopulationData> getFishes(long currentTime) {
        if (ConfigurationManager.server.regenerateEmptyChunks) {
            this.checkForRegeneration(currentTime);
        }
        this.checkForReproduction(currentTime);
        return this.fishPopulationMap;
    }

    @Override
    public Map<String, PopulationData> getRawFishMap() {
        return this.fishPopulationMap;
    }

    @Override
    public void reducePopulation(String fishId, int reduce, long currentTime, boolean markDirty) {
        if (!this.fishPopulationMap.containsKey(fishId)) {
            return;
        }
        PopulationData populationData = this.fishPopulationMap.get(fishId);
        int quantity = populationData.getQuantity();
        int newPopulation = quantity - reduce;
        if (newPopulation <= 0) {
            this.removeFish(fishId, currentTime, markDirty);
        } else {
            populationData.setQuantity(newPopulation);
        }
        if (markDirty && this.chunk != null) {
            this.chunk.func_76630_e();
        }
    }

    @Override
    public boolean hasFishes() {
        return this.fishPopulationMap.size() > 0;
    }

    @Override
    public long getTimeSinceLastRegen() {
        return this.timeSinceRegenerated;
    }

    @Override
    public long getTimeSinceLastReproduced() {
        return this.timeSinceReproduction;
    }

    @Override
    public void setTimeSinceLastRegen(long time, boolean markDirty) {
        this.timeSinceRegenerated = time;
        if (markDirty) {
            this.chunk.func_76630_e();
        }
    }

    @Override
    public void setTimeSinceLastReproduced(long time, boolean markDirty) {
        this.timeSinceReproduction = time;
        if (markDirty && this.chunk != null) {
            this.chunk.func_76630_e();
        }
    }

    @Override
    public void setPopulationData(String fishId, PopulationData populationData, boolean markDirty) {
        if (!this.fishPopulationMap.containsKey(fishId)) {
            return;
        }
        this.fishPopulationMap.put(fishId, populationData);
        if (markDirty && this.chunk != null) {
            this.chunk.func_76630_e();
        }
    }

    private void checkForRegeneration(long currentTime) {
        if (this.hasFishes()) {
            return;
        }
        if (currentTime >= this.timeSinceRegenerated) {
            this.regenerateInitialFishes();
        }
    }

    private void checkForReproduction(long currentTime) {
        boolean updated = false;
        if (!this.hasFishes()) {
            return;
        }
        long timeDiff = currentTime - this.timeSinceReproduction;
        int steps = (int)(timeDiff / this.getReproductionTime());
        if (steps < 1) {
            return;
        }
        for (int i = 0; i < steps; ++i) {
            for (PopulationData populationData : this.fishPopulationMap.values()) {
                FishData fishData = CustomConfigurationHandler.fishDataMap.get(populationData.getFishType());
                if (fishData == null || populationData.getQuantity() < 2 || populationData.isHungry(currentTime)) continue;
                updated = true;
                this.timeSinceReproduction = currentTime;
                populationData.setReproductionTick(populationData.getReproductionTick() + 1);
                if (populationData.getReproductionTick() < fishData.reproductionTime) continue;
                populationData.setReproductionTick(0);
                populationData.setQuantity(populationData.getQuantity() + 1);
            }
        }
        if (updated && this.chunk != null) {
            this.chunk.func_76630_e();
        }
    }

    private void regenerateInitialFishes() {
        HashMap<String, PopulationData> fishPopulationMap = new HashMap<String, PopulationData>();
        Random random = this.chunk.func_177412_p().field_73012_v;
        for (FishData fishData : CustomConfigurationHandler.getAllFishData()) {
            int popCount;
            if (fishData.dimensionBlacklist == this.isChunkInDimension(fishData.dimensionList) || fishData.biomeBlacklist == this.isChunkBiomeInBiomeList(fishData.biomeTagList) || (popCount = this.getInitialPopulationCount(random, fishData)) <= 0) continue;
            PopulationData populationData = new PopulationData(fishData.fishId, popCount, 0, this.world.func_82737_E());
            fishPopulationMap.put(fishData.fishId, populationData);
        }
        this.addFishes(fishPopulationMap, true);
    }

    private void removeFish(String fishId, long currentTime, boolean markDirty) {
        if (!this.fishPopulationMap.containsKey(fishId)) {
            return;
        }
        this.fishPopulationMap.remove(fishId);
        if (!this.hasFishes()) {
            this.timeSinceRegenerated = currentTime + this.getRegenTime();
        }
        if (markDirty && this.chunk != null) {
            this.chunk.func_76630_e();
        }
    }

    private long getRegenTime() {
        return TimeUtil.minutesToMinecraftTicks(ConfigurationManager.server.fishRegenerationTime);
    }

    private long getReproductionTime() {
        return TimeUtil.minutesToMinecraftTicks(ConfigurationManager.server.fishReproductionTime);
    }

    private int getInitialPopulationCount(Random random, FishData fishData) {
        float popRarity = (float)fishData.rarity * 0.5f;
        int popFactor = ConfigurationManager.server.randomPopulationFactor;
        return Math.max(0, (int)((double)popRarity * (1.0 + (double)RandomUtil.getRandomInRange(random, -popFactor, popFactor) / 100.0) + 0.5));
    }

    private boolean isChunkBiomeInBiomeList(List<String> biomeTagList) {
        if (this.chunk == null) {
            return false;
        }
        if (biomeTagList.isEmpty()) {
            return false;
        }
        if (this.byName.isEmpty()) {
            this.initByName();
        }
        ChunkPos chunkPos = this.chunk.func_76632_l();
        BiomeProvider biomeProv = this.world.func_72959_q();
        for (String biomeTag : biomeTagList) {
            if (this.byName.get(biomeTag) == null || !BiomeDictionary.hasType((Biome)this.chunk.func_177411_a(chunkPos.func_180331_a(0, 60, 0), biomeProv), (BiomeDictionary.Type)this.byName.get(biomeTag)) && !BiomeDictionary.hasType((Biome)this.chunk.func_177411_a(chunkPos.func_180331_a(8, 60, 0), biomeProv), (BiomeDictionary.Type)this.byName.get(biomeTag)) && !BiomeDictionary.hasType((Biome)this.chunk.func_177411_a(chunkPos.func_180331_a(15, 60, 0), biomeProv), (BiomeDictionary.Type)this.byName.get(biomeTag)) && !BiomeDictionary.hasType((Biome)this.chunk.func_177411_a(chunkPos.func_180331_a(0, 60, 0), biomeProv), (BiomeDictionary.Type)this.byName.get(biomeTag)) && !BiomeDictionary.hasType((Biome)this.chunk.func_177411_a(chunkPos.func_180331_a(0, 60, 8), biomeProv), (BiomeDictionary.Type)this.byName.get(biomeTag)) && !BiomeDictionary.hasType((Biome)this.chunk.func_177411_a(chunkPos.func_180331_a(0, 60, 15), biomeProv), (BiomeDictionary.Type)this.byName.get(biomeTag)) && !BiomeDictionary.hasType((Biome)this.chunk.func_177411_a(chunkPos.func_180331_a(8, 60, 15), biomeProv), (BiomeDictionary.Type)this.byName.get(biomeTag)) && !BiomeDictionary.hasType((Biome)this.chunk.func_177411_a(chunkPos.func_180331_a(15, 60, 8), biomeProv), (BiomeDictionary.Type)this.byName.get(biomeTag))) continue;
            return true;
        }
        return false;
    }

    private boolean isChunkInDimension(List<Integer> dimensionList) {
        if (this.chunk == null) {
            return false;
        }
        if (dimensionList.isEmpty()) {
            return false;
        }
        return dimensionList.contains(this.chunk.func_177412_p().field_73011_w.getDimension());
    }

    private void initByName() {
        for (BiomeDictionary.Type type : BiomeDictionary.Type.getAll()) {
            this.byName.put(type.getName(), type);
        }
    }
}

