/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.common.capability.fishing;

import java.util.Random;
import net.minecraft.item.ItemStack;
import net.theawesomegem.fishingmadebetter.common.capability.fishing.FishPopulation;
import net.theawesomegem.fishingmadebetter.common.capability.fishing.IFishingData;
import net.theawesomegem.fishingmadebetter.common.configuration.CustomConfigurationHandler;
import net.theawesomegem.fishingmadebetter.common.data.FishCaughtData;
import net.theawesomegem.fishingmadebetter.common.data.FishData;
import net.theawesomegem.fishingmadebetter.common.item.fishingrod.ItemBetterFishingRod;
import net.theawesomegem.fishingmadebetter.common.networking.packet.PacketKeybindS;
import net.theawesomegem.fishingmadebetter.util.RandomUtil;

public class FishingData
implements IFishingData {
    private int fishTime;
    private boolean fishing;
    private int reelAmount;
    private int reelTarget;
    private int errorVariance;
    private int timeBeforeFishSwimToHook;
    private int fishDistance;
    private int fishDeepLevel;
    private int fishDistanceTime;
    private FishCaughtData fishCaughtData;
    private FishPopulation fishPopulation;
    private boolean usingVanillaRod = false;
    private int fishMomentum;
    private int fishTugging;
    private int tensionMomentum;
    private PacketKeybindS.Keybind keybind;
    private Integer[] minigameBackground = new Integer[5];
    private int lineBreak;
    private int lastFailedFishing;
    private int lastFishTime;
    private int fishWeight;
    private long timeSinceTracking;

    public FishingData() {
        this.reset();
    }

    @Override
    public void setFishTime(int value) {
        this.fishTime = value;
    }

    @Override
    public int getFishTime() {
        return this.fishTime;
    }

    @Override
    public void setFishing(boolean value) {
        this.fishing = value;
    }

    @Override
    public boolean isFishing() {
        return this.fishing;
    }

    @Override
    public void setReelAmount(int value) {
        this.reelAmount = value = Math.min(1100 - this.errorVariance, Math.max(this.errorVariance, value));
    }

    @Override
    public int getReelAmount() {
        return this.reelAmount;
    }

    @Override
    public void setReelTarget(int value) {
        this.reelTarget = value = Math.min(1070, Math.max(30, value));
    }

    @Override
    public int getReelTarget() {
        return this.reelTarget;
    }

    @Override
    public void setErrorVariance(int value) {
        if (value < 0) {
            value = 0;
        }
        this.errorVariance = value;
    }

    @Override
    public int getErrorVariance() {
        return this.errorVariance;
    }

    @Override
    public void setTimeBeforeFishSwimToHook(int value) {
        this.timeBeforeFishSwimToHook = value;
    }

    @Override
    public int getTimeBeforeFishSwimToHook() {
        return this.timeBeforeFishSwimToHook;
    }

    @Override
    public void setFishPopulation(FishPopulation fishPopulation) {
        this.fishPopulation = fishPopulation;
    }

    @Override
    public FishPopulation getFishPopulation() {
        return this.fishPopulation;
    }

    @Override
    public void setLastFailedFishing(int value) {
        this.lastFailedFishing = value;
    }

    @Override
    public int getLastFailedFishing() {
        return this.lastFailedFishing;
    }

    @Override
    public void setLastFishTime(int value) {
        this.lastFishTime = value;
    }

    @Override
    public int getLastFishTime() {
        return this.lastFishTime;
    }

    @Override
    public void setFishDistance(int value) {
        this.fishDistance = Math.max(0, value);
    }

    @Override
    public int getFishDistance() {
        return this.fishDistance;
    }

    @Override
    public void setFishDistanceTime(int value) {
        this.fishDistanceTime = value;
    }

    @Override
    public int getFishDistanceTime() {
        return this.fishDistanceTime;
    }

    @Override
    public void setFishDeepLevel(int value) {
        this.fishDeepLevel = value;
    }

    @Override
    public int getFishDeepLevel() {
        return this.fishDeepLevel;
    }

    @Override
    public void setFishWeight(int value) {
        this.fishWeight = value;
    }

    @Override
    public int getFishWeight() {
        return this.fishWeight;
    }

    @Override
    public void setFishCaughtData(FishCaughtData fishCaughtData) {
        this.fishCaughtData = fishCaughtData;
    }

    @Override
    public FishCaughtData getFishCaughtData() {
        return this.fishCaughtData;
    }

    @Override
    public boolean getUsingVanillaRod() {
        return this.usingVanillaRod;
    }

    @Override
    public void setUsingVanillaRod(boolean value) {
        this.usingVanillaRod = value;
    }

    @Override
    public long getTimeSinceTracking() {
        return this.timeSinceTracking;
    }

    @Override
    public void setTimeSinceTracking(long time) {
        this.timeSinceTracking = time;
    }

    @Override
    public int getFishMomentum() {
        return this.fishMomentum;
    }

    @Override
    public void setFishMomentum(int momentum) {
        this.fishMomentum = momentum;
    }

    @Override
    public int getFishTugging() {
        return this.fishTugging;
    }

    @Override
    public void setFishTugging(int tugging) {
        this.fishTugging = tugging;
    }

    @Override
    public int getTensionMomentum() {
        return this.tensionMomentum;
    }

    @Override
    public void setTensionMomentum(int momentum) {
        this.tensionMomentum = momentum;
    }

    @Override
    public PacketKeybindS.Keybind getKeybind() {
        return this.keybind;
    }

    @Override
    public void setKeybind(PacketKeybindS.Keybind keybind) {
        this.keybind = keybind;
    }

    @Override
    public Integer[] getMinigameBackground() {
        return this.minigameBackground;
    }

    @Override
    public void setMinigameBackground(int a, int b, int c, int d, int e) {
        this.minigameBackground[0] = a;
        this.minigameBackground[1] = b;
        this.minigameBackground[2] = c;
        this.minigameBackground[3] = d;
        this.minigameBackground[4] = e;
    }

    @Override
    public int getLineBreak() {
        return this.lineBreak;
    }

    @Override
    public void setLineBreak(int value) {
        this.lineBreak = Math.min(60, Math.max(0, value));
    }

    @Override
    public void setMinigameBackground(Integer[] minigameBackground) {
        this.minigameBackground = minigameBackground;
    }

    @Override
    public void startFishing(Random random, ItemStack fishingRod, Integer[] minigameBackground) {
        if (this.isFishing()) {
            return;
        }
        if (this.fishPopulation == null) {
            return;
        }
        String fishId = this.fishPopulation.fishId;
        this.reset();
        FishData fishData = CustomConfigurationHandler.fishDataMap.get(fishId);
        FishCaughtData fishCaughtData = FishCaughtData.fromFishData(fishData, random);
        this.setFishCaughtData(fishCaughtData);
        this.setFishTime(fishCaughtData.fishTime);
        this.setFishing(true);
        this.setErrorVariance((2 + fishCaughtData.errorVariance + ItemBetterFishingRod.getBobberItem(fishingRod).getVarianceModifier()) * 10);
        this.setReelAmount(RandomUtil.getRandomInRange(random, 15, 95) * 10);
        this.setReelTarget(RandomUtil.getRandomInRange(random, 30, 80) * 10);
        this.setFishDistance((ItemBetterFishingRod.getReelItem(fishingRod).getReelRange() - fishCaughtData.deepLevel) * 10);
        this.setFishDistanceTime(0);
        this.setFishDeepLevel(ItemBetterFishingRod.getReelItem(fishingRod).getReelRange() * 10);
        this.setFishWeight(fishCaughtData.weight);
        this.setFishMomentum(0);
        this.setFishTugging(0);
        this.setTensionMomentum(0);
        this.setKeybind(PacketKeybindS.Keybind.NONE);
        this.setMinigameBackground(minigameBackground);
        this.setLineBreak(0);
        this.setLastFishTime(this.getFishTime());
    }

    @Override
    public void reset(boolean alsoResetFishSwimToHook) {
        if (alsoResetFishSwimToHook) {
            this.setTimeBeforeFishSwimToHook(-1);
            this.fishPopulation = null;
        }
        this.fishCaughtData = null;
        this.setFishTime(0);
        this.setFishing(false);
        this.setErrorVariance(0);
        this.setReelAmount(0);
        this.setReelTarget(0);
        this.setFishDistance(0);
        this.setFishDistanceTime(0);
        this.setFishDeepLevel(0);
        this.setFishWeight(0);
        this.setFishMomentum(0);
        this.setFishTugging(0);
        this.setTensionMomentum(0);
        this.setKeybind(PacketKeybindS.Keybind.NONE);
        this.setMinigameBackground(new Integer[]{0, 0, 0, 0, 0});
        this.setLineBreak(0);
    }

    @Override
    public void reset() {
        this.reset(true);
    }
}

