/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.dispenser;

import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import knightminer.inspirations.recipes.block.BlockEnhancedCauldron;
import knightminer.inspirations.recipes.tileentity.TileCauldron;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DispenseCauldronRecipe
extends BehaviorDefaultDispenseItem {
    private static final BehaviorDefaultDispenseItem DEFAULT = new BehaviorDefaultDispenseItem();
    private IBehaviorDispenseItem fallback;
    private int[] validMeta;

    public DispenseCauldronRecipe(IBehaviorDispenseItem fallback, int ... validMeta) {
        this.fallback = fallback;
        this.validMeta = validMeta;
    }

    private boolean isMetaValid(ItemStack stack) {
        if (this.validMeta.length == 0) {
            return true;
        }
        int meta = stack.func_77960_j();
        for (int i : this.validMeta) {
            if (i != meta) continue;
            return true;
        }
        return false;
    }

    protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
        int newLevel;
        if (!this.isMetaValid(stack)) {
            return this.fallback.func_82482_a(source, stack);
        }
        EnumFacing side = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
        BlockPos pos = source.func_180699_d().func_177972_a(side);
        World world = source.func_82618_k();
        IBlockState state = world.func_180495_p(pos);
        if (!InspirationsRegistry.isNormalCauldron(state)) {
            return this.fallback.func_82482_a(source, stack);
        }
        TileCauldron cauldron = null;
        ICauldronRecipe.CauldronState cauldronState = ICauldronRecipe.CauldronState.WATER;
        boolean boiling = false;
        Block block = state.func_177230_c();
        if (Config.enableExtendedCauldron && block instanceof BlockEnhancedCauldron) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileCauldron) {
                cauldron = (TileCauldron)te;
                cauldronState = cauldron.getState();
                boiling = (Boolean)state.func_177229_b((IProperty)BlockEnhancedCauldron.BOILING);
            }
        } else {
            cauldronState = InspirationsRegistry.getCauldronState(state);
            boiling = InspirationsRegistry.isCauldronFire(world.func_180495_p(pos.func_177977_b()));
        }
        int level = BlockEnhancedCauldron.getCauldronLevel(state);
        ICauldronRecipe recipe = InspirationsRegistry.getCauldronResult(stack, boiling, level, cauldronState);
        if (recipe == null) {
            return DEFAULT.func_82482_a(source, stack);
        }
        ICauldronRecipe.CauldronState newState = recipe.getState(stack, boiling, level, cauldronState);
        if (!Config.enableExtendedCauldron && !ICauldronRecipe.CauldronState.WATER.matches(newState)) {
            return DEFAULT.func_82482_a(source, stack);
        }
        SoundEvent sound = recipe.getSound(stack, boiling, level, cauldronState);
        if (sound != null) {
            world.func_184133_a((EntityPlayer)null, pos, sound, SoundCategory.BLOCKS, recipe.getVolume(sound), 1.0f);
        }
        if ((newLevel = recipe.getLevel(level)) != level || !cauldronState.matches(newState)) {
            if (newLevel == InspirationsRegistry.getCauldronMax() && InspirationsRegistry.isNormalCauldron(state) && InspirationsRegistry.hasFullCauldron(newState)) {
                world.func_175656_a(pos, InspirationsRegistry.getFullCauldron(newState));
                cauldron = null;
            } else {
                if (!(block instanceof BlockCauldron)) {
                    TileEntity te;
                    Blocks.field_150383_bp.func_176590_a(world, pos, Blocks.field_150383_bp.func_176223_P(), newLevel);
                    if (Config.enableExtendedCauldron && (te = world.func_175625_s(pos)) instanceof TileCauldron) {
                        cauldron = (TileCauldron)te;
                    }
                } else {
                    ((BlockCauldron)block).func_176590_a(world, pos, state, newLevel);
                }
                if (newLevel == 0) {
                    newState = ICauldronRecipe.CauldronState.WATER;
                }
            }
        }
        if (cauldron != null) {
            cauldron.setState(newState, true);
        }
        ItemStack result = recipe.getResult(stack, boiling, level, cauldronState);
        ItemStack container = recipe.getContainer(stack);
        int oldSize = stack.func_190916_E();
        ItemStack remainder = recipe.transformInput(stack.func_77946_l(), boiling, level, cauldronState);
        if (remainder.func_190926_b()) {
            if (container.func_190926_b()) {
                return result;
            }
            container.func_190920_e(container.func_190916_E() * oldSize);
            DispenseCauldronRecipe.dispenseItem(source, result);
            return container;
        }
        DispenseCauldronRecipe.dispenseItem(source, result);
        if (!container.func_190926_b()) {
            container.func_190920_e(container.func_190916_E() * (oldSize - remainder.func_190916_E()));
            DispenseCauldronRecipe.dispenseItem(source, container);
        }
        return remainder;
    }

    private static void dispenseItem(IBlockSource source, ItemStack stack) {
        if (((TileEntityDispenser)source.func_150835_j()).func_146019_a(stack) < 0) {
            DEFAULT.func_82482_a(source, stack);
        }
    }
}

