/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes;

import com.google.common.collect.HashMultimap;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.CommonProxy;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.PulseBase;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.recipe.cauldron.CauldronBrewingRecipe;
import knightminer.inspirations.library.recipe.cauldron.CauldronDyeRecipe;
import knightminer.inspirations.library.recipe.cauldron.CauldronFluidRecipe;
import knightminer.inspirations.library.recipe.cauldron.CauldronMixRecipe;
import knightminer.inspirations.library.recipe.cauldron.FillCauldronRecipe;
import knightminer.inspirations.library.util.RecipeUtil;
import knightminer.inspirations.library.util.ReflectionUtil;
import knightminer.inspirations.recipes.RecipesEvents;
import knightminer.inspirations.recipes.block.BlockEnhancedCauldron;
import knightminer.inspirations.recipes.block.BlockSmashingAnvil;
import knightminer.inspirations.recipes.dispenser.DispenseCauldronRecipe;
import knightminer.inspirations.recipes.item.ItemDyedWaterBottle;
import knightminer.inspirations.recipes.recipe.ArmorClearRecipe;
import knightminer.inspirations.recipes.recipe.ArmorDyeingCauldronRecipe;
import knightminer.inspirations.recipes.recipe.BannerClearRecipe;
import knightminer.inspirations.recipes.recipe.DyeCauldronWater;
import knightminer.inspirations.recipes.recipe.DyeIngredientWrapper;
import knightminer.inspirations.recipes.recipe.FillCauldronFromDyedBottle;
import knightminer.inspirations.recipes.recipe.FillCauldronFromFluidContainer;
import knightminer.inspirations.recipes.recipe.FillCauldronFromPotion;
import knightminer.inspirations.recipes.recipe.FillDyedBottleFromCauldron;
import knightminer.inspirations.recipes.recipe.FillFluidContainerFromCauldron;
import knightminer.inspirations.recipes.recipe.FillPotionFromCauldron;
import knightminer.inspirations.recipes.recipe.SpongeEmptyCauldron;
import knightminer.inspirations.recipes.recipe.TippedArrowCauldronRecipe;
import knightminer.inspirations.recipes.tileentity.TileCauldron;
import knightminer.inspirations.shared.InspirationsShared;
import knightminer.inspirations.utility.InspirationsUtility;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemSoup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.AbstractBrewingRecipe;
import net.minecraftforge.common.brewing.BrewingOreRecipe;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.mantle.util.RecipeMatch;

@Pulse(id="InspirationsRecipes", description="Adds additional recipe types, including cauldrons and anvil smashing")
public class InspirationsRecipes
extends PulseBase {
    public static final String pulseID = "InspirationsRecipes";
    @SidedProxy(clientSide="knightminer.inspirations.recipes.RecipesClientProxy", serverSide="knightminer.inspirations.common.CommonProxy")
    public static CommonProxy proxy;
    public static Block anvil;
    public static BlockEnhancedCauldron cauldron;
    public static ItemDyedWaterBottle dyedWaterBottle;
    public static ItemSoup potatoSoupItem;
    public static Fluid mushroomStew;
    public static Fluid potatoSoup;
    public static Fluid beetrootSoup;
    public static Fluid rabbitStew;
    public static Fluid milk;

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
        if (Config.cauldronStew) {
            mushroomStew = InspirationsRecipes.registerColoredFluid("mushroom_stew", -3306385);
            potatoSoup = InspirationsRecipes.registerColoredFluid("potato_soup", -6232);
            beetrootSoup = InspirationsRecipes.registerColoredFluid("beetroot_soup", -4707792);
            rabbitStew = InspirationsRecipes.registerColoredFluid("rabbit_stew", -6796756);
        }
        if (Config.enableMilk) {
            milk = InspirationsRecipes.registerFluid(new Fluid("milk", Util.getResource("blocks/milk"), Util.getResource("blocks/milk_flow")));
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry r = event.getRegistry();
        if (Config.enableAnvilSmashing) {
            anvil = (Block)InspirationsRecipes.register(r, new BlockSmashingAnvil(), new ResourceLocation("anvil"));
        }
        if (Config.enableExtendedCauldron) {
            cauldron = InspirationsRecipes.register(r, new BlockEnhancedCauldron(), new ResourceLocation("cauldron"));
            InspirationsRecipes.registerTE(TileCauldron.class, "cauldron");
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        if (Config.enableCauldronDyeing) {
            dyedWaterBottle = InspirationsRecipes.registerItem((IForgeRegistry<Item>)r, new ItemDyedWaterBottle(), "dyed_bottle");
        }
        if (Config.cauldronStew) {
            potatoSoupItem = InspirationsRecipes.registerItem((IForgeRegistry<Item>)r, new ItemSoup(8), "potato_soup");
        }
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        String[] recipes;
        if (!Config.patchVanillaDyeRecipes) {
            return;
        }
        IForgeRegistry r = event.getRegistry();
        for (String recipeName : recipes = new String[]{"purple_dye", "cyan_dye", "light_gray_dye_from_ink_bonemeal", "light_gray_dye_from_gray_bonemeal", "gray_dye", "pink_dye_from_red_bonemeal", "lime_dye", "light_blue_dye_from_lapis_bonemeal", "magenta_dye_from_purple_and_pink", "magenta_dye_from_lapis_red_pink", "magenta_dye_from_lapis_ink_bonemeal", "orange_dye_from_red_yellow"}) {
            IRecipe irecipe = (IRecipe)r.getValue(new ResourceLocation(recipeName));
            if (irecipe instanceof ShapelessRecipes) {
                ShapelessRecipes recipe = (ShapelessRecipes)irecipe;
                NonNullList newIngredients = NonNullList.func_191196_a();
                recipe.field_77579_b.forEach(i -> newIngredients.add((Object)new DyeIngredientWrapper((Ingredient)i)));
                recipe.field_77579_b.clear();
                recipe.field_77579_b.addAll((Collection)newIngredients);
                continue;
            }
            String error = irecipe == null ? "recipe removed" : "recipe unexpected class " + irecipe.getClass();
            Inspirations.log.warn("Error modifying dye recipe '{}', {}", (Object)recipeName, (Object)error);
        }
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        proxy.init();
        InspirationsRegistry.registerAnvilBreaking(Material.field_151592_s);
        if (Config.enableCauldronRecipes) {
            this.registerCauldronRecipes();
        }
        this.registerDispenserBehavior();
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        MinecraftForge.EVENT_BUS.register(RecipesEvents.class);
        this.registerPostCauldronRecipes();
    }

    private void registerCauldronRecipes() {
        InspirationsRegistry.registerDefaultCauldron();
        InspirationsRegistry.addCauldronRecipe(new FillCauldronRecipe(RecipeMatch.of((Block)Blocks.field_150432_aD), FluidRegistry.WATER, InspirationsRegistry.getCauldronMax(), ItemStack.field_190927_a, true, SoundEvents.field_187627_L));
        if (Config.spongeEmptyCauldron) {
            InspirationsRegistry.addCauldronRecipe(SpongeEmptyCauldron.INSTANCE);
        }
        if (Config.cauldronObsidian) {
            CauldronMixRecipe recipe = Config.enableCauldronFluids ? new CauldronMixRecipe(FluidRegistry.LAVA, FluidRegistry.WATER, new ItemStack(Blocks.field_150343_Z)) : new CauldronMixRecipe(FluidRegistry.WATER, FluidRegistry.LAVA, new ItemStack(Blocks.field_150343_Z));
            InspirationsRegistry.addCauldronRecipe(recipe);
        }
        if (!Config.enableExtendedCauldron) {
            return;
        }
        InspirationsRegistry.addCauldronRecipe(new ArmorClearRecipe(ItemArmor.ArmorMaterial.LEATHER));
        InspirationsRegistry.addCauldronRecipe(BannerClearRecipe.INSTANCE);
        ItemStack waterBottle = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b);
        InspirationsRegistry.addCauldronRecipe(new CauldronFluidRecipe(RecipeMatch.of((Item)Items.field_151069_bo), FluidRegistry.WATER, waterBottle, null, SoundEvents.field_187615_H));
        InspirationsRegistry.addCauldronRecipe(new FillCauldronRecipe(RecipeMatch.ofNBT((ItemStack)waterBottle), FluidRegistry.WATER, 1, new ItemStack(Items.field_151069_bo)));
        if (Config.enableCauldronDyeing) {
            InspirationsRegistry.addCauldronRecipe(FillDyedBottleFromCauldron.INSTANCE);
            InspirationsRegistry.addCauldronRecipe(FillCauldronFromDyedBottle.INSTANCE);
            InspirationsRegistry.addCauldronRecipe(new ArmorDyeingCauldronRecipe(ItemArmor.ArmorMaterial.LEATHER));
            for (EnumDyeColor color : EnumDyeColor.values()) {
                InspirationsRegistry.addCauldronRecipe(new DyeCauldronWater(color));
                InspirationsRegistry.addCauldronRecipe(new CauldronDyeRecipe(new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE), color, new ItemStack(Blocks.field_150325_L, 1, color.func_176765_a())));
                InspirationsRegistry.addCauldronRecipe(new CauldronDyeRecipe(new ItemStack(Blocks.field_150404_cg, 1, Short.MAX_VALUE), color, new ItemStack(Blocks.field_150404_cg, 1, color.func_176765_a())));
                InspirationsRegistry.addCauldronRecipe(new CauldronDyeRecipe(new ItemStack(Items.field_151104_aV, 1, Short.MAX_VALUE), color, new ItemStack(Items.field_151104_aV, 1, color.func_176765_a())));
            }
            if (InspirationsUtility.carpetedTrapdoors != null) {
                RecipeMatch anyTrapdoor = RecipeMatch.of((String)"trapdoorCarpeted");
                for (EnumDyeColor color : EnumDyeColor.values()) {
                    InspirationsRegistry.addCauldronRecipe(new CauldronDyeRecipe(anyTrapdoor, color, new ItemStack(InspirationsUtility.carpetedTrapdoors[color.func_176765_a()])));
                }
            }
        }
        if (Config.enableCauldronPotions) {
            InspirationsRecipes.addPotionBottle((Item)Items.field_151068_bn, new ItemStack(Items.field_151069_bo), null);
            InspirationsRecipes.addPotionBottle((Item)Items.field_185155_bH, InspirationsShared.splashBottle, "bottleSplash");
            InspirationsRecipes.addPotionBottle((Item)Items.field_185156_bI, InspirationsShared.lingeringBottle, "bottleLingering");
            if (Config.cauldronTipArrows) {
                InspirationsRegistry.addCauldronRecipe(TippedArrowCauldronRecipe.INSTANCE);
            }
        }
        if (Config.enableCauldronFluids) {
            InspirationsRegistry.addCauldronRecipe(FillFluidContainerFromCauldron.INSTANCE);
            if (Config.cauldronStew) {
                InspirationsRecipes.addStewRecipes(new ItemStack(Items.field_185165_cW), beetrootSoup, new ItemStack(Items.field_185164_cV, 6), FluidRegistry.WATER);
                InspirationsRecipes.addStewRecipes(new ItemStack(Items.field_151009_A), mushroomStew, "mushroomAny", 2, FluidRegistry.WATER);
                InspirationsRecipes.addStewRecipes(new ItemStack((Item)potatoSoupItem), potatoSoup, new ItemStack(Items.field_151168_bH, 2), mushroomStew);
                InspirationsRecipes.addStewRecipes(new ItemStack(Items.field_179560_bq), rabbitStew, new ItemStack(Items.field_179559_bp), potatoSoup);
                InspirationsRecipes.addStewRecipes(new ItemStack(Items.field_151009_A), mushroomStew, InspirationsShared.mushrooms.func_77946_l(), FluidRegistry.WATER);
                InspirationsRecipes.addStewRecipes(new ItemStack(Items.field_179560_bq), rabbitStew, InspirationsShared.rabbitStewMix.func_77946_l(), FluidRegistry.WATER);
            }
        } else {
            InspirationsRegistry.addCauldronFluidItem(new ItemStack(Items.field_151131_as), new ItemStack(Items.field_151133_ar), FluidRegistry.WATER, 3);
        }
    }

    private void registerPostCauldronRecipes() {
        if (Config.enableCauldronBrewing) {
            for (Object recipe : PotionHelper.field_185213_a) {
                PotionType input = ReflectionUtil.getMixPredicateInput(recipe);
                Ingredient reagent = ReflectionUtil.getMixPredicateReagent(recipe);
                PotionType output = ReflectionUtil.getMixPredicateOutput(recipe);
                if (input == null || reagent == null || output == null) continue;
                InspirationsRegistry.addCauldronRecipe(new CauldronBrewingRecipe(input, reagent, output));
            }
            this.findRecipesFromBrewingRegistry();
        }
        if (Config.enableCauldronFluids) {
            InspirationsRegistry.addCauldronRecipe(FillCauldronFromFluidContainer.INSTANCE);
        }
    }

    private static void addPotionBottle(Item potion, ItemStack bottle, String bottleOre) {
        InspirationsRegistry.addCauldronRecipe(new FillCauldronFromPotion(potion, bottle));
        if (bottleOre != null) {
            InspirationsRegistry.addCauldronRecipe(new FillPotionFromCauldron(potion, bottleOre));
        } else {
            InspirationsRegistry.addCauldronRecipe(new FillPotionFromCauldron(potion, bottle));
        }
    }

    private static void addStewRecipes(ItemStack stew, Fluid fluid, ItemStack ingredient, Fluid base) {
        InspirationsRegistry.addCauldronScaledTransformRecipe(ingredient, base, fluid, true);
        InspirationsRegistry.addCauldronRecipe(new CauldronFluidRecipe(RecipeMatch.of((Item)Items.field_151054_z), fluid, stew, null, SoundEvents.field_187615_H));
        InspirationsRegistry.addCauldronRecipe(new FillCauldronRecipe(RecipeMatch.of((ItemStack)stew), fluid, 1, new ItemStack(Items.field_151054_z)));
    }

    private static void addStewRecipes(ItemStack stew, Fluid fluid, String ingredient, int count, Fluid base) {
        InspirationsRegistry.addCauldronScaledTransformRecipe(ingredient, count, base, fluid, true);
        InspirationsRegistry.addCauldronRecipe(new CauldronFluidRecipe(RecipeMatch.of((Item)Items.field_151054_z), fluid, stew, null, SoundEvents.field_187615_H));
        InspirationsRegistry.addCauldronRecipe(new FillCauldronRecipe(RecipeMatch.of((ItemStack)stew), fluid, 1, new ItemStack(Items.field_151054_z)));
    }

    private void findRecipesFromBrewingRegistry() {
        for (IBrewingRecipe irecipe : BrewingRecipeRegistry.getRecipes()) {
            if (!(irecipe instanceof AbstractBrewingRecipe)) continue;
            AbstractBrewingRecipe recipe = (AbstractBrewingRecipe)irecipe;
            ItemStack inputStack = recipe.getInput();
            ItemStack outputStack = recipe.getOutput();
            Ingredient ingredient = null;
            if (recipe instanceof BrewingRecipe) {
                ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)((BrewingRecipe)recipe).getIngredient()});
            } else if (recipe instanceof BrewingOreRecipe) {
                ingredient = Ingredient.func_193369_a((ItemStack[])((ItemStack[])((List)((BrewingOreRecipe)recipe).getIngredient()).stream().toArray(ItemStack[]::new)));
            }
            if (ingredient == null || inputStack == null || inputStack.func_77973_b() != Items.field_151068_bn || outputStack == null || outputStack.func_77973_b() != Items.field_151068_bn) continue;
            PotionType input = PotionUtils.func_185191_c((ItemStack)inputStack);
            PotionType output = PotionUtils.func_185191_c((ItemStack)outputStack);
            if (input == PotionTypes.field_185229_a || output == PotionTypes.field_185229_a) continue;
            InspirationsRegistry.addCauldronRecipe(new CauldronBrewingRecipe(input, ingredient, output));
        }
    }

    private void registerDispenserBehavior() {
        if (Config.enableCauldronDispenser) {
            HashMultimap map = HashMultimap.create();
            for (String line : Config.cauldronDispenserRecipes) {
                if (StringUtils.func_151246_b((String)line)) continue;
                ItemStack stack = RecipeUtil.getItemStackFromString(line, true);
                map.put((Object)stack.func_77973_b(), (Object)stack.func_77960_j());
            }
            for (Map.Entry entry : map.asMap().entrySet()) {
                InspirationsRecipes.registerDispenseCauldronLogic((Item)entry.getKey(), InspirationsRecipes.toArray((Collection)entry.getValue()));
            }
        }
    }

    private static int[] toArray(Collection<Integer> list) {
        if (list.contains(Short.MAX_VALUE)) {
            return new int[0];
        }
        return list.stream().mapToInt(i -> i).toArray();
    }

    private static void registerDispenseCauldronLogic(Item item, int[] meta) {
        InspirationsRecipes.registerDispenserBehavior(item, (IBehaviorDispenseItem)new DispenseCauldronRecipe((IBehaviorDispenseItem)BlockDispenser.field_149943_a.func_82594_a((Object)item), meta));
    }
}

