/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron;

import java.util.List;
import javax.annotation.Nullable;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.ISimpleCauldronRecipe;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import slimeknights.mantle.util.RecipeMatch;

public abstract class CauldronRecipeMatchRecipe
implements ISimpleCauldronRecipe {
    private RecipeMatch input;
    @Nullable
    protected Boolean boiling;
    private SoundEvent sound;
    private ItemStack result;
    private int levels;

    public CauldronRecipeMatchRecipe(RecipeMatch input, ItemStack result, @Nullable Boolean boiling, int levels, SoundEvent sound) {
        this.input = input;
        this.result = result;
        this.levels = levels;
        this.boiling = boiling;
        this.sound = sound;
    }

    public CauldronRecipeMatchRecipe(RecipeMatch input, ItemStack result, @Nullable Boolean boiling, int levels) {
        this(input, result, boiling, levels, SoundEvents.field_187609_F);
    }

    @Override
    public boolean matches(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        if (level < this.levels || !this.matches(state) || this.boiling != null && boiling != this.boiling) {
            return false;
        }
        return this.matches(stack);
    }

    protected abstract boolean matches(ICauldronRecipe.CauldronState var1);

    protected boolean matches(ItemStack stack) {
        return this.input.matches(Util.createNonNullList(stack)).isPresent();
    }

    @Override
    public ItemStack transformInput(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        NonNullList<ItemStack> list = Util.createNonNullList(stack);
        RecipeMatch.removeMatch(list, (RecipeMatch.Match)((RecipeMatch.Match)this.input.matches(list).get()));
        return (ItemStack)list.get(0);
    }

    @Override
    public List<ItemStack> getInput() {
        return this.input.getInputs();
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public int getLevel(int level) {
        return level - this.levels;
    }

    @Override
    public int getInputLevel() {
        return this.levels == 0 ? 1 : this.levels;
    }

    @Override
    public boolean isBoiling() {
        return this.boiling == Boolean.TRUE;
    }

    @Override
    public SoundEvent getSound(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        return this.sound;
    }
}

