/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.structures;

import com.github.alexthe666.iceandfire.block.BlockMyrmexConnectedResin;
import com.github.alexthe666.iceandfire.block.BlockMyrmexResin;
import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexQueen;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexRoyal;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexSentinel;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexSoldier;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexWorker;
import com.github.alexthe666.iceandfire.entity.util.MyrmexHive;
import com.github.alexthe666.iceandfire.structures.WorldGenMyrmexDecoration;
import com.github.alexthe666.iceandfire.world.MyrmexWorldData;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenMyrmexHive
extends WorldGenerator {
    private static final IBlockState DESERT_RESIN = ModBlocks.myrmex_resin.func_176223_P();
    private static final IBlockState STICKY_DESERT_RESIN = ModBlocks.myrmex_resin_sticky.func_176223_P();
    private static final IBlockState JUNGLE_RESIN = ModBlocks.myrmex_resin.func_176223_P().func_177226_a(BlockMyrmexResin.VARIANT, (Comparable)((Object)BlockMyrmexResin.EnumType.JUNGLE));
    private static final IBlockState STICKY_JUNGLE_RESIN = ModBlocks.myrmex_resin_sticky.func_176223_P().func_177226_a(BlockMyrmexResin.VARIANT, (Comparable)((Object)BlockMyrmexResin.EnumType.JUNGLE));
    private int entrances = 0;
    private int totalRooms;
    private boolean hasFoodRoom;
    private boolean hasNursery;
    private boolean small;
    private boolean jungle;

    public WorldGenMyrmexHive(boolean jungle) {
        this.jungle = jungle;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        this.small = false;
        this.hasFoodRoom = false;
        this.hasNursery = false;
        this.totalRooms = 0;
        BlockPos undergroundPos = new BlockPos(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        this.entrances = 0;
        this.generateHive(worldIn, rand, undergroundPos);
        return false;
    }

    public void generateForQueen(EntityMyrmexQueen queen, Random rand, BlockPos position) {
        this.small = true;
        this.hasFoodRoom = false;
        this.hasNursery = false;
        this.totalRooms = 0;
        BlockPos undergroundPos = new BlockPos(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        this.entrances = 0;
        MyrmexHive hive = this.generateHive(queen.field_70170_p, rand, undergroundPos);
        queen.setHive(hive);
    }

    private MyrmexHive generateHive(World world, Random rand, BlockPos position) {
        MyrmexHive hive = new MyrmexHive(world, position, 100);
        MyrmexWorldData.addHive(world, hive);
        IBlockState resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
        IBlockState sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
        this.generateSphere(world, rand, position, 14, 7, resin, sticky_resin);
        this.generateSphere(world, rand, position, 12, 5, Blocks.field_150350_a.func_176223_P());
        this.decorateSphere(world, rand, hive, position, 12, 5, RoomType.QUEEN);
        this.generatePath(world, rand, hive, position.func_177967_a(EnumFacing.NORTH, 9).func_177977_b(), 15 + rand.nextInt(10), EnumFacing.NORTH, 100);
        this.generatePath(world, rand, hive, position.func_177967_a(EnumFacing.SOUTH, 9).func_177977_b(), 15 + rand.nextInt(10), EnumFacing.SOUTH, 100);
        this.generatePath(world, rand, hive, position.func_177967_a(EnumFacing.WEST, 9).func_177977_b(), 15 + rand.nextInt(10), EnumFacing.WEST, 100);
        this.generatePath(world, rand, hive, position.func_177967_a(EnumFacing.EAST, 9).func_177977_b(), 15 + rand.nextInt(10), EnumFacing.EAST, 100);
        if (!this.small) {
            EntityMyrmexBase myrmex;
            int i;
            EntityMyrmexQueen queen = new EntityMyrmexQueen(world);
            BlockPos ground = MyrmexHive.getGroundedPos(world, position);
            queen.func_180482_a(world.func_175649_E(ground), null);
            queen.setHive(hive);
            queen.setJungleVariant(this.jungle);
            queen.func_70080_a((double)ground.func_177958_n() + 0.5, (double)ground.func_177956_o() + 1.0, (double)ground.func_177952_p() + 0.5, 0.0f, 0.0f);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)queen);
            }
            for (i = 0; i < 4 + rand.nextInt(3); ++i) {
                myrmex = new EntityMyrmexWorker(world);
                myrmex.func_180482_a(world.func_175649_E(ground), null);
                myrmex.setHive(hive);
                myrmex.func_70080_a((double)ground.func_177958_n() + 0.5, (double)ground.func_177956_o() + 1.0, (double)ground.func_177952_p() + 0.5, 0.0f, 0.0f);
                myrmex.setJungleVariant(this.jungle);
                if (world.field_72995_K) continue;
                world.func_72838_d((Entity)myrmex);
            }
            for (i = 0; i < 2 + rand.nextInt(2); ++i) {
                myrmex = new EntityMyrmexSoldier(world);
                myrmex.func_180482_a(world.func_175649_E(ground), null);
                myrmex.setHive(hive);
                myrmex.func_70080_a((double)ground.func_177958_n() + 0.5, (double)ground.func_177956_o() + 1.0, (double)ground.func_177952_p() + 0.5, 0.0f, 0.0f);
                myrmex.setJungleVariant(this.jungle);
                if (world.field_72995_K) continue;
                world.func_72838_d((Entity)myrmex);
            }
            for (i = 0; i < rand.nextInt(2); ++i) {
                myrmex = new EntityMyrmexSentinel(world);
                myrmex.func_180482_a(world.func_175649_E(ground), null);
                myrmex.setHive(hive);
                myrmex.func_70080_a((double)ground.func_177958_n() + 0.5, (double)ground.func_177956_o() + 1.0, (double)ground.func_177952_p() + 0.5, 0.0f, 0.0f);
                myrmex.setJungleVariant(this.jungle);
                if (world.field_72995_K) continue;
                world.func_72838_d((Entity)myrmex);
            }
        }
        return hive;
    }

    private void generatePath(World world, Random rand, MyrmexHive hive, BlockPos offset, int length, EnumFacing direction, int roomChance) {
        if (roomChance == 0) {
            return;
        }
        if (this.small) {
            length /= 2;
            if (this.entrances < 1) {
                for (int i = 0; i < length; ++i) {
                    this.generateCircle(world, rand, hive, offset.func_177967_a(direction, i), 3, 5, direction);
                }
                this.generateEntrance(world, rand, hive, offset.func_177967_a(direction, length), 4, 4, direction);
            } else if (this.totalRooms < 2) {
                int i;
                for (i = 0; i < length; ++i) {
                    this.generateCircle(world, rand, hive, offset.func_177967_a(direction, i), 3, 5, direction);
                }
                this.generateRoom(world, rand, hive, offset.func_177967_a(direction, length), 6, 4, roomChance / 2, direction);
                for (i = -3; i < 3; ++i) {
                    this.generateCircleAir(world, rand, hive, offset.func_177967_a(direction, i), 3, 5, direction);
                    this.generateCircleAir(world, rand, hive, offset.func_177967_a(direction, length + i), 3, 5, direction);
                }
                ++this.totalRooms;
            }
        } else if (rand.nextInt(100) < roomChance) {
            int i;
            for (i = 0; i < length; ++i) {
                this.generateCircle(world, rand, hive, offset.func_177967_a(direction, i), 3, 5, direction);
            }
            if (this.entrances < 3 && rand.nextInt(1 + this.entrances * 2) == 0 && this.hasFoodRoom && this.hasNursery && this.totalRooms > 3) {
                this.generateEntrance(world, rand, hive, offset.func_177967_a(direction, length), 4, 4, direction);
            } else {
                this.generateRoom(world, rand, hive, offset.func_177967_a(direction, length), 7, 4, roomChance / 2, direction);
                for (i = -3; i < 3; ++i) {
                    this.generateCircleAir(world, rand, hive, offset.func_177967_a(direction, length + i), 3, 5, direction);
                }
                ++this.totalRooms;
            }
        }
    }

    private void generateRoom(World world, Random rand, MyrmexHive hive, BlockPos position, int size, int height, int roomChance, EnumFacing direction) {
        IBlockState resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
        IBlockState sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
        RoomType type = RoomType.random(rand);
        if (!this.hasFoodRoom) {
            type = RoomType.FOOD;
            this.hasFoodRoom = true;
        } else if (!this.hasNursery) {
            type = RoomType.NURSERY;
            this.hasNursery = true;
        }
        this.generateSphereRespectResin(world, rand, position, size + 2, height + 2, resin, sticky_resin);
        this.generateSphere(world, rand, position, size, height - 1, Blocks.field_150350_a.func_176223_P());
        this.decorateSphere(world, rand, hive, position, size, height - 1, type);
        hive.addRoom(position, type);
        if (!this.small) {
            if (rand.nextInt(3) == 0 && direction.func_176734_d() != EnumFacing.NORTH) {
                this.generatePath(world, rand, hive, position.func_177967_a(EnumFacing.NORTH, size - 2), 5 + rand.nextInt(20), EnumFacing.NORTH, roomChance);
            }
            if (rand.nextInt(3) == 0 && direction.func_176734_d() != EnumFacing.SOUTH) {
                this.generatePath(world, rand, hive, position.func_177967_a(EnumFacing.SOUTH, size - 2), 5 + rand.nextInt(20), EnumFacing.SOUTH, roomChance);
            }
            if (rand.nextInt(3) == 0 && direction.func_176734_d() != EnumFacing.WEST) {
                this.generatePath(world, rand, hive, position.func_177967_a(EnumFacing.WEST, size - 2), 5 + rand.nextInt(20), EnumFacing.WEST, roomChance);
            }
            if (rand.nextInt(3) == 0 && direction.func_176734_d() != EnumFacing.EAST) {
                this.generatePath(world, rand, hive, position.func_177967_a(EnumFacing.EAST, size - 2), 5 + rand.nextInt(20), EnumFacing.EAST, roomChance);
            }
        }
    }

    private void generateEntrance(World world, Random rand, MyrmexHive hive, BlockPos position, int size, int height, EnumFacing direction) {
        BlockPos up = position.func_177984_a();
        hive.getEntranceBottoms().put(up, direction);
        while (!world.func_175710_j(up)) {
            this.generateCircleRespectSky(world, rand, hive, up, size, height, direction);
            up = up.func_177984_a().func_177972_a(direction);
        }
        IBlockState resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
        IBlockState sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
        this.generateSphereRespectAir(world, rand, up, size + 2, height + 2, resin, sticky_resin);
        this.generateSphere(world, rand, up.func_177984_a(), size, height - 1, Blocks.field_150350_a.func_176223_P());
        this.decorateSphere(world, rand, hive, up.func_177984_a(), size, height - 1, RoomType.ENTERANCE);
        hive.getEntrances().put(up, direction);
        ++this.entrances;
    }

    private void generateCircle(World world, Random rand, MyrmexHive hive, BlockPos position, int size, int height, EnumFacing direction) {
        int z;
        int x;
        float j;
        IBlockState resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
        IBlockState sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
        int radius = size + 2;
        float i = 0.0f;
        while (i < (float)radius) {
            j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                x = (int)Math.floor(Math.sin(j) * (double)i);
                z = (int)Math.floor(Math.cos(j) * (double)i);
                if (direction == EnumFacing.WEST || direction == EnumFacing.EAST) {
                    world.func_175656_a(position.func_177982_a(0, x, z), rand.nextInt(3) == 0 ? sticky_resin : resin);
                } else {
                    world.func_175656_a(position.func_177982_a(x, z, 0), rand.nextInt(3) == 0 ? sticky_resin : resin);
                }
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
        radius -= 2;
        i = 0.0f;
        while (i < (float)radius) {
            j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                x = (int)Math.floor(Math.sin(j) * (double)i * (double)MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.5f, (float)1.0f));
                z = (int)Math.floor(Math.cos(j) * (double)i * (double)MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.5f, (float)1.0f));
                if (direction == EnumFacing.WEST || direction == EnumFacing.EAST) {
                    world.func_175656_a(position.func_177982_a(0, x, z), Blocks.field_150350_a.func_176223_P());
                } else {
                    world.func_175656_a(position.func_177982_a(x, z, 0), Blocks.field_150350_a.func_176223_P());
                }
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
        this.decorateCircle(world, rand, hive, position, size, height, direction);
    }

    private void generateCircleRespectSky(World world, Random rand, MyrmexHive hive, BlockPos position, int size, int height, EnumFacing direction) {
        int z;
        int x;
        float j;
        IBlockState resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
        IBlockState sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
        int radius = size + 2;
        float i = 0.0f;
        while (i < (float)radius) {
            j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                x = (int)Math.floor(Math.sin(j) * (double)i);
                z = (int)Math.floor(Math.cos(j) * (double)i);
                if (direction == EnumFacing.WEST || direction == EnumFacing.EAST) {
                    if (!world.func_175710_j(position.func_177982_a(0, x, z))) {
                        world.func_175656_a(position.func_177982_a(0, x, z), rand.nextInt(3) == 0 ? sticky_resin : resin);
                    }
                } else if (!world.func_175710_j(position.func_177982_a(x, z, 0))) {
                    world.func_175656_a(position.func_177982_a(x, z, 0), rand.nextInt(3) == 0 ? sticky_resin : resin);
                }
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
        radius -= 2;
        i = 0.0f;
        while (i < (float)radius) {
            j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                x = (int)Math.floor(Math.sin(j) * (double)i * (double)MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.5f, (float)1.0f));
                z = (int)Math.floor(Math.cos(j) * (double)i * (double)MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.5f, (float)1.0f));
                if (direction == EnumFacing.WEST || direction == EnumFacing.EAST) {
                    world.func_175656_a(position.func_177982_a(0, x, z), Blocks.field_150350_a.func_176223_P());
                } else {
                    world.func_175656_a(position.func_177982_a(x, z, 0), Blocks.field_150350_a.func_176223_P());
                }
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
        this.decorateCircle(world, rand, hive, position, size, height, direction);
    }

    private void generateCircleAir(World world, Random rand, MyrmexHive hive, BlockPos position, int size, int height, EnumFacing direction) {
        int radius = size;
        float i = 0.0f;
        while (i < (float)radius) {
            float j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                int x = (int)Math.floor(Math.sin(j) * (double)i * (double)MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.5f, (float)1.0f));
                int z = (int)Math.floor(Math.cos(j) * (double)i * (double)MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.5f, (float)1.0f));
                if (direction == EnumFacing.WEST || direction == EnumFacing.EAST) {
                    world.func_175656_a(position.func_177982_a(0, x, z), Blocks.field_150350_a.func_176223_P());
                } else {
                    world.func_175656_a(position.func_177982_a(x, z, 0), Blocks.field_150350_a.func_176223_P());
                }
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
        this.decorateCircle(world, rand, hive, position, size, height, direction);
    }

    public void generateSphere(World world, Random rand, BlockPos position, int size, int height, IBlockState fill) {
        int i2 = size;
        int ySize = rand.nextInt(2);
        int j = i2 + rand.nextInt(2);
        int k = height + ySize;
        int l = i2 + rand.nextInt(2);
        float f = (float)(j + k + l) * 0.333f;
        for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l))) {
            if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f * MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.75f, (float)1.0f))) || world.func_175623_d(blockpos)) continue;
            world.func_180501_a(blockpos, fill, 3);
        }
    }

    public void generateSphere(World world, Random rand, BlockPos position, int size, int height, IBlockState fill, IBlockState fill2) {
        int i2 = size;
        int ySize = rand.nextInt(2);
        int j = i2 + rand.nextInt(2);
        int k = height + ySize;
        int l = i2 + rand.nextInt(2);
        float f = (float)(j + k + l) * 0.333f;
        for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l))) {
            if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f * MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.75f, (float)1.0f)))) continue;
            world.func_180501_a(blockpos, rand.nextInt(3) == 0 ? fill2 : fill, 3);
        }
    }

    public void generateSphereRespectResin(World world, Random rand, BlockPos position, int size, int height, IBlockState fill, IBlockState fill2) {
        int i2 = size;
        int ySize = rand.nextInt(2);
        int j = i2 + rand.nextInt(2);
        int k = height + ySize;
        int l = i2 + rand.nextInt(2);
        float f = (float)(j + k + l) * 0.333f;
        for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l))) {
            if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f * MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.75f, (float)1.0f))) || world.func_175623_d(blockpos) && (!world.func_175623_d(blockpos) || this.hasResinUnder(blockpos, world))) continue;
            world.func_180501_a(blockpos, rand.nextInt(3) == 0 ? fill2 : fill, 3);
        }
    }

    public void generateSphereRespectAir(World world, Random rand, BlockPos position, int size, int height, IBlockState fill, IBlockState fill2) {
        int i2 = size;
        int ySize = rand.nextInt(2);
        int j = i2 + rand.nextInt(2);
        int k = height + ySize;
        int l = i2 + rand.nextInt(2);
        float f = (float)(j + k + l) * 0.333f;
        for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l))) {
            if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f * MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.75f, (float)1.0f))) || world.func_175623_d(blockpos)) continue;
            world.func_180501_a(blockpos, rand.nextInt(3) == 0 ? fill2 : fill, 3);
        }
    }

    private boolean hasResinUnder(BlockPos pos, World world) {
        BlockPos copy = pos.func_177977_b();
        while (world.func_175623_d(copy) && copy.func_177956_o() > 1) {
            copy = copy.func_177977_b();
        }
        return world.func_180495_p(copy).func_177230_c() instanceof BlockMyrmexResin || world.func_180495_p(copy).func_177230_c() instanceof BlockMyrmexConnectedResin;
    }

    private void decorateCircle(World world, Random rand, MyrmexHive hive, BlockPos position, int size, int height, EnumFacing direction) {
        int radius = size + 2;
        float i = 0.0f;
        while (i < (float)radius) {
            float j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                int x = (int)Math.floor(Math.sin(j) * (double)i);
                int z = (int)Math.floor(Math.cos(j) * (double)i);
                if (direction == EnumFacing.WEST || direction == EnumFacing.EAST) {
                    if (world.func_175623_d(position.func_177982_a(0, x, z))) {
                        this.decorate(world, hive, position.func_177982_a(0, x, z), position, size, rand, RoomType.TUNNEL);
                    }
                    if (world.func_175623_d(position.func_177982_a(0, x, z))) {
                        this.decorateTubers(world, position.func_177982_a(0, x, z), rand, RoomType.TUNNEL);
                    }
                } else {
                    if (world.func_175623_d(position.func_177982_a(x, z, 0))) {
                        this.decorate(world, hive, position.func_177982_a(x, z, 0), position, size, rand, RoomType.TUNNEL);
                    }
                    if (world.func_175623_d(position.func_177982_a(0, x, z))) {
                        this.decorateTubers(world, position.func_177982_a(0, x, z), rand, RoomType.TUNNEL);
                    }
                }
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
    }

    private void decorateSphere(World world, Random rand, MyrmexHive hive, BlockPos position, int size, int height, RoomType roomType) {
        int i2 = size;
        int ySize = rand.nextInt(2);
        int j = i2 + rand.nextInt(2);
        int k = height + ySize;
        int l = i2 + rand.nextInt(2);
        float f = (float)(j + k + l) * 0.333f;
        for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k + 2, l))) {
            if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f))) continue;
            if (world.func_180495_p(blockpos.func_177977_b()).func_185917_h() && world.func_175623_d(blockpos)) {
                this.decorate(world, hive, blockpos, position, size, rand, roomType);
            }
            if (!world.func_175623_d(blockpos)) continue;
            this.decorateTubers(world, blockpos, rand, roomType);
        }
    }

    private void decorate(World world, MyrmexHive hive, BlockPos blockpos, BlockPos center, int size, Random random, RoomType roomType) {
        switch (roomType) {
            case FOOD: {
                if (random.nextInt(45) == 0 && world.func_180495_p(blockpos.func_177977_b()).func_177230_c() instanceof BlockMyrmexResin) {
                    WorldGenMyrmexDecoration.generateSkeleton(world, blockpos, center, size, random);
                }
                if (random.nextInt(13) == 0) {
                    WorldGenMyrmexDecoration.generateLeaves(world, blockpos, center, size, random);
                }
                if (random.nextInt(12) == 0) {
                    WorldGenMyrmexDecoration.generatePumpkins(world, blockpos, center, size, random);
                }
                if (random.nextInt(6) == 0) {
                    WorldGenMyrmexDecoration.generateMushrooms(world, blockpos, center, size, random);
                }
                if (random.nextInt(12) != 0) break;
                WorldGenMyrmexDecoration.generateCocoon(world, blockpos, random, this.jungle, this.jungle ? WorldGenMyrmexDecoration.JUNGLE_MYRMEX_FOOD_CHEST : WorldGenMyrmexDecoration.DESERT_MYRMEX_FOOD_CHEST);
                break;
            }
            case NURSERY: {
                EntityMyrmexBase baby;
                if (random.nextInt(4) != 0 || this.small) break;
                switch (random.nextInt(4)) {
                    default: {
                        baby = new EntityMyrmexWorker(world);
                        break;
                    }
                    case 1: {
                        baby = new EntityMyrmexSoldier(world);
                        break;
                    }
                    case 2: {
                        baby = new EntityMyrmexSentinel(world);
                        break;
                    }
                    case 3: {
                        baby = new EntityMyrmexRoyal(world);
                    }
                }
                baby.setGrowthStage(random.nextInt(2));
                baby.func_70012_b(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                baby.func_70034_d(random.nextFloat() * 360.0f);
                baby.setHive(hive);
                baby.setJungleVariant(this.jungle);
                if (world.field_72995_K || baby.func_70094_T()) break;
                world.func_72838_d((Entity)baby);
                break;
            }
            case SHINY: {
                if (random.nextInt(12) != 0) break;
                WorldGenMyrmexDecoration.generateGold(world, blockpos, center, size, random);
                break;
            }
            case TRASH: {
                if (random.nextInt(24) == 0) {
                    WorldGenMyrmexDecoration.generateTrashHeap(world, blockpos, center, size, random);
                }
                if (random.nextBoolean()) {
                    WorldGenMyrmexDecoration.generateTrashOre(world, blockpos, center, size, random);
                }
                if (random.nextInt(12) != 0) break;
                WorldGenMyrmexDecoration.generateCocoon(world, blockpos, random, this.jungle, WorldGenMyrmexDecoration.MYRMEX_TRASH_CHEST);
                break;
            }
        }
    }

    private void decorateTubers(World world, BlockPos blockpos, Random random, RoomType roomType) {
        if (world.func_180495_p(blockpos.func_177984_a()).func_185914_p() && random.nextInt(roomType == RoomType.ENTERANCE || roomType == RoomType.TUNNEL ? 20 : 6) == 0) {
            int tuberLength = roomType == RoomType.ENTERANCE || roomType == RoomType.TUNNEL ? 1 : (roomType == RoomType.QUEEN ? 1 + random.nextInt(5) : 1 + random.nextInt(3));
            for (int i = 0; i < tuberLength; ++i) {
                if (!world.func_175623_d(blockpos.func_177979_c(i))) continue;
                world.func_175656_a(blockpos.func_177979_c(i), this.jungle ? ModBlocks.myrmex_jungle_biolight.func_176223_P() : ModBlocks.myrmex_desert_biolight.func_176223_P());
            }
        }
    }

    public static enum RoomType {
        DEFAULT(false),
        TUNNEL(false),
        ENTERANCE(false),
        QUEEN(false),
        FOOD(true),
        EMPTY(true),
        NURSERY(true),
        SHINY(true),
        TRASH(true);

        boolean random;

        private RoomType(boolean random) {
            this.random = random;
        }

        public static RoomType random(Random rand) {
            ArrayList<RoomType> list = new ArrayList<RoomType>();
            for (RoomType type : RoomType.values()) {
                if (!type.random) continue;
                list.add(type);
            }
            return (RoomType)((Object)list.get(rand.nextInt(list.size())));
        }
    }
}

