/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.structures;

import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityLightningDragon;
import com.github.alexthe666.iceandfire.integration.CompatLoadUtil;
import com.github.alexthe666.iceandfire.structures.WorldGenDragonRoost;
import com.github.alexthe666.iceandfire.structures.WorldGenLightningDragonCave;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenLightningDragonRoost
extends WorldGenDragonRoost {
    @Override
    protected void transformState(World world, BlockPos blockpos, IBlockState state) {
        if (state.func_185904_a() == Material.field_151577_b && state.func_177230_c() == Blocks.field_150349_c) {
            world.func_175656_a(blockpos, ModBlocks.crackledGrass.func_176223_P());
        } else if (state.func_185904_a() == Material.field_151577_b || state.func_185904_a() == Material.field_151578_c && state.func_177230_c() == Blocks.field_150346_d) {
            world.func_175656_a(blockpos, ModBlocks.crackledDirt.func_176223_P());
        } else if (state.func_185904_a() == Material.field_151578_c && state.func_177230_c() == Blocks.field_150351_n) {
            world.func_175656_a(blockpos, ModBlocks.crackledGravel.func_176223_P());
        } else if (state.func_185904_a() == Material.field_151576_e && (state.func_177230_c() == Blocks.field_150347_e || state.func_177230_c().func_149739_a().contains("cobblestone"))) {
            world.func_175656_a(blockpos, ModBlocks.crackledCobblestone.func_176223_P());
        } else if (state.func_185904_a() == Material.field_151576_e && state.func_177230_c() != ModBlocks.crackledCobblestone) {
            world.func_175656_a(blockpos, ModBlocks.crackledStone.func_176223_P());
        } else if (state.func_177230_c() == Blocks.field_185774_da) {
            world.func_175656_a(blockpos, ModBlocks.crackledGrassPath.func_176223_P());
        } else if (state.func_185904_a() == Material.field_151575_d) {
            world.func_175656_a(blockpos, ModBlocks.ash.func_176223_P());
        } else if (state.func_185904_a() == Material.field_151584_j || state.func_185904_a() == Material.field_151585_k) {
            world.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
        }
    }

    @Override
    protected IBlockState getPileBlock() {
        if (CompatLoadUtil.isVariedCommoditiesLoaded()) {
            return ModBlocks.diamondPile.func_176223_P();
        }
        return ModBlocks.copperPile.func_176223_P();
    }

    @Override
    protected IBlockState getBuildingBlock() {
        return ModBlocks.crackledCobblestone.func_176223_P();
    }

    @Override
    protected Block[] getDragonTransformedBlocks() {
        return new Block[]{ModBlocks.crackledGrass, ModBlocks.crackledDirt, ModBlocks.crackledGravel, ModBlocks.crackledGrassPath, ModBlocks.crackledStone, ModBlocks.crackledCobblestone};
    }

    @Override
    protected ResourceLocation getLootTable() {
        return WorldGenLightningDragonCave.LIGHTNINGDRAGON_CHEST;
    }

    @Override
    protected EntityDragonBase createDragon(World worldIn) {
        return new EntityLightningDragon(worldIn);
    }
}

