/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.structures;

import com.github.alexthe666.iceandfire.IceAndFireConfig;
import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityLightningDragon;
import com.github.alexthe666.iceandfire.integration.CompatLoadUtil;
import com.github.alexthe666.iceandfire.structures.WorldGenDragonCave;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class WorldGenLightningDragonCave
extends WorldGenDragonCave {
    public static final ResourceLocation LIGHTNINGDRAGON_CHEST = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "lightning_dragon_female_cave"));
    public static final ResourceLocation LIGHTNINGDRAGON_MALE_CHEST = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "lightning_dragon_male_cave"));

    @Override
    protected IBlockState getStone() {
        return ModBlocks.crackledStone.func_176223_P();
    }

    @Override
    protected IBlockState getCobblestone() {
        return ModBlocks.crackledCobblestone.func_176223_P();
    }

    @Override
    protected IBlockState getPile() {
        if (CompatLoadUtil.isVariedCommoditiesLoaded()) {
            return ModBlocks.diamondPile.func_176223_P();
        }
        return ModBlocks.copperPile.func_176223_P();
    }

    @Override
    protected IBlockState getGemstone() {
        return IceAndFireConfig.WORLDGEN.generateAmethystOre ? ModBlocks.amethystOre.func_176223_P() : Blocks.field_150412_bA.func_176223_P();
    }

    @Override
    protected ResourceLocation getLootTable() {
        if (this.isMale) {
            return LIGHTNINGDRAGON_MALE_CHEST;
        }
        return LIGHTNINGDRAGON_CHEST;
    }

    @Override
    protected EntityDragonBase createDragon(World worldIn) {
        return new EntityLightningDragon(worldIn);
    }
}

