/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.structures;

import com.github.alexthe666.iceandfire.block.BlockCoinPile;
import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.entity.EntityCyclops;
import java.util.Random;
import net.minecraft.block.BlockBone;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.loot.LootTableList;

public class WorldGenCyclopsCave
extends WorldGenerator {
    public static final ResourceLocation CYCLOPS_CHEST = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "cyclops_cave"));

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int i1 = 16;
        int i2 = i1 - 2;
        int sheepPenCount = 0;
        int dist = 6;
        if (worldIn.func_175623_d(position.func_177982_a(i1 - dist, -3, -i1 + dist)) || worldIn.func_175623_d(position.func_177982_a(i1 - dist, -3, i1 - dist)) || worldIn.func_175623_d(position.func_177982_a(-i1 + dist, -3, -i1 + dist)) || worldIn.func_175623_d(position.func_177982_a(-i1 + dist, -3, i1 - dist))) {
            return false;
        }
        int ySize = rand.nextInt(2);
        int j = i1 + rand.nextInt(2);
        int k = 12 + ySize;
        int l = i1 + rand.nextInt(2);
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l))) {
            boolean isNotInDoorway;
            boolean doorwayX = blockpos.func_177958_n() >= position.func_177958_n() - 2 + rand.nextInt(2) && blockpos.func_177958_n() <= position.func_177958_n() + 2 + rand.nextInt(2);
            boolean doorwayZ = blockpos.func_177952_p() >= position.func_177952_p() - 2 + rand.nextInt(2) && blockpos.func_177952_p() <= position.func_177952_p() + 2 + rand.nextInt(2);
            boolean bl = isNotInDoorway = !doorwayX && !doorwayZ && blockpos.func_177956_o() > position.func_177956_o() || blockpos.func_177956_o() > position.func_177956_o() + k - (3 + rand.nextInt(2));
            if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f))) continue;
            if (!(worldIn.func_180495_p(position).func_177230_c() instanceof BlockChest) && worldIn.func_180495_p(position).func_177230_c().func_176195_g(worldIn.func_180495_p(position), worldIn, position) >= 0.0f && isNotInDoorway) {
                worldIn.func_180501_a(blockpos, Blocks.field_150348_b.func_176223_P(), 3);
            }
            if (blockpos.func_177956_o() == position.func_177956_o()) {
                worldIn.func_180501_a(blockpos, Blocks.field_150341_Y.func_176223_P(), 3);
            }
            if (blockpos.func_177956_o() > position.func_177956_o() - 1 || worldIn.func_175665_u(blockpos)) continue;
            worldIn.func_180501_a(blockpos, Blocks.field_150347_e.func_176223_P(), 3);
        }
        ySize = rand.nextInt(2);
        j = i2 + rand.nextInt(2);
        k = 10 + ySize;
        l = i2 + rand.nextInt(2);
        f = (float)(j + k + l) * 0.333f + 0.5f;
        for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l))) {
            if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f)) || blockpos.func_177956_o() <= position.func_177956_o() || worldIn.func_180495_p(position).func_177230_c() instanceof BlockChest) continue;
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 3);
        }
        for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l))) {
            if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f)) || blockpos.func_177956_o() != position.func_177956_o()) continue;
            if (rand.nextInt(130) == 0 && this.isTouchingAir(worldIn, blockpos.func_177984_a())) {
                this.genSkeleton(worldIn, blockpos.func_177984_a(), rand, position, f);
            }
            if (rand.nextInt(130) == 0 && blockpos.func_177951_i((Vec3i)position) <= (double)(f * f) * (double)0.8f && sheepPenCount < 2) {
                this.genSheepPen(worldIn, blockpos.func_177984_a(), rand, position, f);
                ++sheepPenCount;
            }
            if (rand.nextInt(80) == 0 && this.isTouchingAir(worldIn, blockpos.func_177984_a())) {
                TileEntity tileentity1;
                worldIn.func_180501_a(blockpos.func_177984_a(), ModBlocks.goldPile.func_176223_P().func_177226_a((IProperty)BlockCoinPile.LAYERS, (Comparable)Integer.valueOf(8)), 3);
                worldIn.func_180501_a(blockpos.func_177984_a().func_177978_c(), ModBlocks.goldPile.func_176223_P().func_177226_a((IProperty)BlockCoinPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
                worldIn.func_180501_a(blockpos.func_177984_a().func_177968_d(), ModBlocks.goldPile.func_176223_P().func_177226_a((IProperty)BlockCoinPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
                worldIn.func_180501_a(blockpos.func_177984_a().func_177976_e(), ModBlocks.goldPile.func_176223_P().func_177226_a((IProperty)BlockCoinPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
                worldIn.func_180501_a(blockpos.func_177984_a().func_177974_f(), ModBlocks.goldPile.func_176223_P().func_177226_a((IProperty)BlockCoinPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
                worldIn.func_180501_a(blockpos.func_177981_b(2), Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.field_176754_o[new Random().nextInt(3)]), 3);
                if (worldIn.func_180495_p(blockpos.func_177981_b(2)).func_177230_c() instanceof BlockChest && (tileentity1 = worldIn.func_175625_s(blockpos.func_177981_b(2))) instanceof TileEntityChest && !((TileEntityChest)tileentity1).func_145837_r()) {
                    ((TileEntityChest)tileentity1).func_189404_a(CYCLOPS_CHEST, rand.nextLong());
                }
            }
            if (rand.nextInt(50) != 0 || !this.isTouchingAir(worldIn, blockpos.func_177984_a())) continue;
            int torchHeight = rand.nextInt(2) + 1;
            for (int fence = 0; fence < torchHeight; ++fence) {
                worldIn.func_175656_a(blockpos.func_177981_b(1 + fence), Blocks.field_180407_aO.func_176223_P());
            }
            worldIn.func_175656_a(blockpos.func_177981_b(1 + torchHeight), Blocks.field_150478_aa.func_176223_P());
        }
        EntityCyclops cyclops = new EntityCyclops(worldIn);
        cyclops.setVariant(rand.nextInt(3));
        cyclops.func_70080_a((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 1.5, (double)position.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        worldIn.func_72838_d((Entity)cyclops);
        return true;
    }

    private void genSheepPen(World worldIn, BlockPos blockpos, Random rand, BlockPos origin, float radius) {
        int width = 5 + rand.nextInt(3);
        int sheeps = 2 + rand.nextInt(3);
        int sheepsSpawned = 0;
        EnumFacing direction = EnumFacing.NORTH;
        BlockPos end = blockpos;
        for (int sideCount = 0; sideCount < 4; ++sideCount) {
            for (int side = 0; side < width; ++side) {
                if (!(origin.func_177951_i((Vec3i)end.func_177967_a(direction, side)) <= (double)(radius * radius))) continue;
                worldIn.func_175656_a(end.func_177967_a(direction, side), Blocks.field_180407_aO.func_176223_P());
                if (!worldIn.func_175623_d(end.func_177967_a(direction, side).func_177972_a(direction.func_176746_e())) || sheepsSpawned >= sheeps) continue;
                BlockPos sheepPos = end.func_177967_a(direction, side).func_177972_a(direction.func_176746_e());
                EntitySheep entitySheep = new EntitySheep(worldIn);
                entitySheep.func_70107_b((double)((float)sheepPos.func_177958_n() + 0.5f), (double)((float)sheepPos.func_177956_o() + 0.5f), (double)((float)sheepPos.func_177952_p() + 0.5f));
                entitySheep.func_175512_b(rand.nextInt(4) == 0 ? EnumDyeColor.YELLOW : EnumDyeColor.WHITE);
                if (!worldIn.field_72995_K) {
                    worldIn.func_72838_d((Entity)entitySheep);
                }
                ++sheepsSpawned;
            }
            end = end.func_177967_a(direction, width);
            direction = direction.func_176746_e();
        }
        for (int x = 1; x < width - 1; ++x) {
            for (int z = 1; z < width - 1; ++z) {
                if (!(origin.func_177951_i((Vec3i)end.func_177982_a(x, 0, z)) <= (double)(radius * radius))) continue;
                worldIn.func_175698_g(end.func_177982_a(x, 0, z));
            }
        }
    }

    private boolean isTouchingAir(World worldIn, BlockPos pos) {
        boolean isTouchingAir = true;
        for (EnumFacing direction : EnumFacing.field_176754_o) {
            if (worldIn.func_175623_d(pos.func_177972_a(direction))) continue;
            isTouchingAir = false;
        }
        return isTouchingAir;
    }

    private void genSkeleton(World worldIn, BlockPos blockpos, Random rand, BlockPos origin, float radius) {
        EnumFacing direction = EnumFacing.field_176754_o[new Random().nextInt(3)];
        EnumFacing.Axis oppositeAxis = direction.func_176740_k() == EnumFacing.Axis.X ? EnumFacing.Axis.Z : EnumFacing.Axis.X;
        int maxRibHeight = rand.nextInt(2);
        for (int spine = 0; spine < 5 + rand.nextInt(2) * 2; ++spine) {
            BlockPos segment = blockpos.func_177967_a(direction, spine);
            if (origin.func_177951_i((Vec3i)segment) <= (double)(radius * radius)) {
                worldIn.func_175656_a(segment, Blocks.field_189880_di.func_176223_P().func_177226_a((IProperty)BlockBone.field_176298_M, (Comparable)direction.func_176740_k()));
            }
            if (spine % 2 == 0) continue;
            BlockPos rightRib = segment.func_177972_a(direction.func_176735_f());
            BlockPos leftRib = segment.func_177972_a(direction.func_176746_e());
            if (origin.func_177951_i((Vec3i)rightRib) <= (double)(radius * radius)) {
                worldIn.func_175656_a(rightRib, Blocks.field_189880_di.func_176223_P().func_177226_a((IProperty)BlockBone.field_176298_M, (Comparable)oppositeAxis));
            }
            if (origin.func_177951_i((Vec3i)leftRib) <= (double)(radius * radius)) {
                worldIn.func_175656_a(leftRib, Blocks.field_189880_di.func_176223_P().func_177226_a((IProperty)BlockBone.field_176298_M, (Comparable)oppositeAxis));
            }
            for (int ribHeight = 1; ribHeight < maxRibHeight + 2; ++ribHeight) {
                if (origin.func_177951_i((Vec3i)rightRib.func_177981_b(ribHeight).func_177972_a(direction.func_176735_f())) <= (double)(radius * radius)) {
                    worldIn.func_175656_a(rightRib.func_177981_b(ribHeight).func_177972_a(direction.func_176735_f()), Blocks.field_189880_di.func_176223_P().func_177226_a((IProperty)BlockBone.field_176298_M, (Comparable)EnumFacing.Axis.Y));
                }
                if (!(origin.func_177951_i((Vec3i)leftRib.func_177981_b(ribHeight).func_177972_a(direction.func_176746_e())) <= (double)(radius * radius))) continue;
                worldIn.func_175656_a(leftRib.func_177981_b(ribHeight).func_177972_a(direction.func_176746_e()), Blocks.field_189880_di.func_176223_P().func_177226_a((IProperty)BlockBone.field_176298_M, (Comparable)EnumFacing.Axis.Y));
            }
            if (origin.func_177951_i((Vec3i)rightRib.func_177981_b(maxRibHeight + 2)) <= (double)(radius * radius)) {
                worldIn.func_175656_a(rightRib.func_177981_b(maxRibHeight + 2), Blocks.field_189880_di.func_176223_P().func_177226_a((IProperty)BlockBone.field_176298_M, (Comparable)oppositeAxis));
            }
            if (!(origin.func_177951_i((Vec3i)leftRib.func_177981_b(maxRibHeight + 2)) <= (double)(radius * radius))) continue;
            worldIn.func_175656_a(leftRib.func_177981_b(maxRibHeight + 2), Blocks.field_189880_di.func_176223_P().func_177226_a((IProperty)BlockBone.field_176298_M, (Comparable)oppositeAxis));
        }
    }
}

