/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.enums.EnumParticle;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.ilexiconn.llibrary.server.network.AbstractMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageParticleFX
extends AbstractMessage<MessageParticleFX> {
    private List<EnumParticle> types;
    private List<Particle> particles;

    public MessageParticleFX(EnumParticle type, List<Particle> particles) {
        this.types = Collections.singletonList(type);
        this.particles = particles;
    }

    public MessageParticleFX(List<EnumParticle> types, List<Particle> particles) {
        this.types = types;
        this.particles = particles;
    }

    public MessageParticleFX() {
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        int numTypes = buf.readInt();
        int numParticles = buf.readInt();
        this.types = new ArrayList<EnumParticle>(numTypes);
        for (i = 0; i < numTypes; ++i) {
            int ordinal = buf.readInt();
            this.types.add(EnumParticle.values()[ordinal]);
        }
        this.particles = new ArrayList<Particle>(numParticles);
        for (i = 0; i < numParticles; ++i) {
            this.particles.add(MessageParticleFX.createParticle(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble()));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.types.size());
        buf.writeInt(this.particles.size());
        for (EnumParticle type : this.types) {
            buf.writeInt(type.ordinal());
        }
        for (Particle particle : this.particles) {
            buf.writeDouble(particle.x);
            buf.writeDouble(particle.y);
            buf.writeDouble(particle.z);
            buf.writeDouble(particle.motX);
            buf.writeDouble(particle.motY);
            buf.writeDouble(particle.motZ);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientReceived(Minecraft client, MessageParticleFX message, EntityPlayer player, MessageContext messageContext) {
        if (this.particles.isEmpty()) {
            return;
        }
        for (EnumParticle type : this.types) {
            for (Particle particle : this.particles) {
                IceAndFire.PROXY.spawnParticle(type, player.field_70170_p, particle.x, particle.y, particle.z, particle.motX, particle.motY, particle.motZ);
            }
        }
    }

    public void onServerReceived(MinecraftServer server, MessageParticleFX message, EntityPlayer player, MessageContext messageContext) {
    }

    public static Particle createParticle(double x, double y, double z, double motX, double motY, double motZ) {
        return new Particle(x, y, z, motX, motY, motZ);
    }

    public static class Particle {
        public final double x;
        public final double y;
        public final double z;
        public final double motX;
        public final double motY;
        public final double motZ;

        private Particle(double x, double y, double z, double motX, double motY, double motZ) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.motX = motX;
            this.motY = motY;
            this.motZ = motZ;
        }
    }
}

