/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.event;

import com.github.alexthe666.iceandfire.IceAndFireConfig;
import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.entity.EntityCyclops;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.entity.EntityHippocampus;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexQueen;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpent;
import com.github.alexthe666.iceandfire.entity.EntityStymphalianBird;
import com.github.alexthe666.iceandfire.enums.EnumDragonType;
import com.github.alexthe666.iceandfire.structures.WorldGenCyclopsCave;
import com.github.alexthe666.iceandfire.structures.WorldGenFireDragonCave;
import com.github.alexthe666.iceandfire.structures.WorldGenFireDragonRoost;
import com.github.alexthe666.iceandfire.structures.WorldGenHydraCave;
import com.github.alexthe666.iceandfire.structures.WorldGenIceDragonCave;
import com.github.alexthe666.iceandfire.structures.WorldGenIceDragonRoost;
import com.github.alexthe666.iceandfire.structures.WorldGenLightningDragonCave;
import com.github.alexthe666.iceandfire.structures.WorldGenLightningDragonRoost;
import com.github.alexthe666.iceandfire.structures.WorldGenMyrmexHive;
import com.github.alexthe666.iceandfire.structures.WorldGenSirenIsland;
import com.github.alexthe666.iceandfire.world.MyrmexWorldData;
import com.github.alexthe666.iceandfire.world.village.MapGenPixieVillage;
import com.github.alexthe666.iceandfire.world.village.MapGenSnowVillage;
import com.google.common.base.Predicate;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class StructureGenerator
implements IWorldGenerator {
    private static final MapGenSnowVillage SNOW_VILLAGE = new MapGenSnowVillage();
    private static final MapGenPixieVillage PIXIE_VILLAGE = new MapGenPixieVillage();
    private static final WorldGenMyrmexHive JUNGLE_MYRMEX_HIVE = new WorldGenMyrmexHive(true);
    private static final WorldGenMyrmexHive DESERT_MYRMEX_HIVE = new WorldGenMyrmexHive(false);
    private static final WorldGenFireDragonCave FIRE_DRAGON_CAVE = new WorldGenFireDragonCave();
    private static final WorldGenFireDragonRoost FIRE_DRAGON_ROOST = new WorldGenFireDragonRoost();
    private static final WorldGenIceDragonCave ICE_DRAGON_CAVE = new WorldGenIceDragonCave();
    private static final WorldGenIceDragonRoost ICE_DRAGON_ROOST = new WorldGenIceDragonRoost();
    private static final WorldGenLightningDragonCave LIGHTNING_DRAGON_CAVE = new WorldGenLightningDragonCave();
    private static final WorldGenLightningDragonRoost LIGHTNING_DRAGON_ROOST = new WorldGenLightningDragonRoost();
    private static final WorldGenCyclopsCave CYCLOPS_CAVE = new WorldGenCyclopsCave();
    private static final WorldGenSirenIsland SIREN_ISLAND = new WorldGenSirenIsland();
    private static final WorldGenHydraCave HYDRA_CAVE = new WorldGenHydraCave();
    private static final ResourceLocation GORGON_TEMPLE = new ResourceLocation("iceandfire", "gorgon_temple");
    private BlockPos lastCyclopsCave = null;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        BlockPos surface;
        IBlockState state;
        BlockPos pos;
        if (!StructureGenerator.genAllowedInDim(world.field_73011_w.getDimension())) {
            return;
        }
        double spawnCheck = IceAndFireConfig.WORLDGEN.dangerousWorldGenDistanceLimit * IceAndFireConfig.WORLDGEN.dangerousWorldGenDistanceLimit;
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        BlockPos height = world.func_175645_m(new BlockPos(x, 0, z));
        Biome biome = world.func_180494_b(height);
        ResourceLocation resourceLocation = ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome);
        String biomeName = resourceLocation != null ? resourceLocation.toString() : "";
        Set types = BiomeDictionary.getTypes((Biome)biome);
        boolean isCold = types.contains(BiomeDictionary.Type.COLD);
        boolean isSnowy = types.contains(BiomeDictionary.Type.SNOWY);
        if (StructureGenerator.isFarEnoughFromSpawn(world, height)) {
            BlockPos pos2;
            EnumDragonType dragonType;
            if (IceAndFireConfig.WORLDGEN.generateGorgonTemple && random.nextInt(IceAndFireConfig.WORLDGEN.generateGorgonChance) == 0 && types.contains(BiomeDictionary.Type.BEACH) && world.func_180495_p(height.func_177977_b()).func_185913_b() && world.func_175623_d(height.func_177984_a())) {
                Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
                Mirror mirror = Mirror.values()[random.nextInt(Mirror.values().length)];
                MinecraftServer server = world.func_73046_m();
                TemplateManager templateManager = world.func_72860_G().func_186340_h();
                PlacementSettings settings = new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror);
                Template template = templateManager.func_186237_a(server, GORGON_TEMPLE);
                BlockPos center = height.func_177982_a(template.func_186259_a().func_177958_n() / 2, -9, template.func_186259_a().func_177952_p() / 2);
                BlockPos corner1 = height.func_177977_b();
                BlockPos corner2 = height.func_177982_a(template.func_186259_a().func_177958_n(), -1, 0);
                BlockPos corner3 = height.func_177982_a(template.func_186259_a().func_177958_n(), -1, template.func_186259_a().func_177952_p());
                BlockPos corner4 = height.func_177982_a(0, -1, template.func_186259_a().func_177952_p());
                if (world.func_180495_p(center).func_185914_p() && world.func_180495_p(corner1).func_185914_p() && world.func_180495_p(corner2).func_185914_p() && world.func_180495_p(corner3).func_185914_p() && world.func_180495_p(corner4).func_185914_p()) {
                    template.func_186260_a(world, center, settings);
                }
            }
            if (IceAndFireConfig.WORLDGEN.generateSirenIslands && random.nextInt(IceAndFireConfig.WORLDGEN.generateSirenChance) == 0 && types.contains(BiomeDictionary.Type.OCEAN) && !isCold) {
                SIREN_ISLAND.func_180709_b(world, random, height);
            }
            if (IceAndFireConfig.WORLDGEN.generateCyclopsCaves && random.nextInt(IceAndFireConfig.WORLDGEN.generateCyclopsChance) == 0 && types.contains(BiomeDictionary.Type.BEACH) && world.func_180495_p(height.func_177977_b()).func_185914_p() && (this.lastCyclopsCave == null || this.lastCyclopsCave.func_177951_i((Vec3i)height) >= spawnCheck)) {
                CYCLOPS_CAVE.func_180709_b(world, random, height);
                this.lastCyclopsCave = height;
            }
            if (IceAndFireConfig.WORLDGEN.generateWanderingCyclops && StructureGenerator.isFarEnoughFromSpawn(world, height) && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) && !isSnowy && !isCold && (this.lastCyclopsCave == null || this.lastCyclopsCave.func_177951_i((Vec3i)height) >= spawnCheck) && random.nextInt(IceAndFireConfig.WORLDGEN.generateWanderingCyclopsChance + 1) == 0 && !world.func_180495_p(height).func_185904_a().func_76224_d()) {
                EntityCyclops cyclops = new EntityCyclops(world);
                cyclops.func_70107_b(x, height.func_177956_o() + 1, z);
                cyclops.setVariant(random.nextInt(3));
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)cyclops);
                }
                for (int i = 0; i < 3 + random.nextInt(3); ++i) {
                    EntitySheep sheep = new EntitySheep(world);
                    sheep.func_70107_b((double)x, (double)(height.func_177956_o() + 1), (double)z);
                    sheep.func_175512_b(EntitySheep.func_175510_a((Random)random));
                    if (world.field_72995_K) continue;
                    world.func_72838_d((Entity)sheep);
                }
                this.lastCyclopsCave = height;
            }
            if (IceAndFireConfig.WORLDGEN.generatePixieVillages && random.nextInt(IceAndFireConfig.WORLDGEN.generatePixieChance) == 0 && types.contains(BiomeDictionary.Type.FOREST) && (types.contains(BiomeDictionary.Type.SPOOKY) || types.contains(BiomeDictionary.Type.MAGICAL))) {
                PIXIE_VILLAGE.func_180709_b(world, random, height);
            }
            if (IceAndFireConfig.WORLDGEN.generateHydraCaves && random.nextInt(IceAndFireConfig.WORLDGEN.generateHydrasChance) == 0 && types.contains(BiomeDictionary.Type.SWAMP) && world.func_180495_p(height.func_177977_b()).func_185914_p()) {
                HYDRA_CAVE.func_180709_b(world, random, height);
            }
            if ((IceAndFireConfig.WORLDGEN.generateDragonRoosts || IceAndFireConfig.WORLDGEN.generateDragonDens) && StructureGenerator.isDragonGenAllowedInDim(world.field_73011_w.getDimension()) && StructureGenerator.isDragonGenAllowedInBiome(types, biomeName) && (dragonType = this.getDragonGenType(types, biome, biomeName, isCold, isSnowy)) != null) {
                int newY;
                BlockPos pos3;
                if (IceAndFireConfig.WORLDGEN.generateDragonRoosts) {
                    Integer chance = IceAndFireConfig.getDragonRoostChance().get(biomeName);
                    if (chance == null) {
                        boolean isHills = types.contains(BiomeDictionary.Type.HILLS) || types.contains(BiomeDictionary.Type.MOUNTAIN) && !isSnowy;
                        chance = isHills ? IceAndFireConfig.WORLDGEN.generateDragonRoostChance : IceAndFireConfig.WORLDGEN.generateDragonRoostChance * 2;
                    }
                    if (random.nextInt(chance) == 0) {
                        if (dragonType == EnumDragonType.FIRE) {
                            FIRE_DRAGON_ROOST.func_180709_b(world, random, height);
                        } else if (dragonType == EnumDragonType.ICE) {
                            ICE_DRAGON_ROOST.func_180709_b(world, random, height);
                        } else if (dragonType == EnumDragonType.LIGHTNING) {
                            LIGHTNING_DRAGON_ROOST.func_180709_b(world, random, height);
                        }
                    }
                }
                if (IceAndFireConfig.WORLDGEN.generateDragonDens && !types.contains(BiomeDictionary.Type.BEACH) && !types.contains(BiomeDictionary.Type.OCEAN) && !world.func_175710_j(pos3 = new BlockPos(x, newY = 20 + random.nextInt(20), z))) {
                    Integer chance = IceAndFireConfig.getDragonDenChance().get(biomeName);
                    if (chance == null) {
                        boolean isHills = types.contains(BiomeDictionary.Type.HILLS) || types.contains(BiomeDictionary.Type.MOUNTAIN);
                        chance = isHills ? IceAndFireConfig.WORLDGEN.generateDragonDenChance : IceAndFireConfig.WORLDGEN.generateDragonDenChance * 2;
                    }
                    if (random.nextInt(chance) == 0) {
                        if (dragonType == EnumDragonType.FIRE) {
                            FIRE_DRAGON_CAVE.func_180709_b(world, random, pos3);
                        } else if (dragonType == EnumDragonType.ICE) {
                            ICE_DRAGON_CAVE.func_180709_b(world, random, pos3);
                        } else if (dragonType == EnumDragonType.LIGHTNING) {
                            LIGHTNING_DRAGON_CAVE.func_180709_b(world, random, pos3);
                        }
                    }
                }
            }
            if (IceAndFireConfig.WORLDGEN.generateDragonSkeletons) {
                if (random.nextInt(IceAndFireConfig.WORLDGEN.generateDragonSkeletonChance) == 0 && types.contains(BiomeDictionary.Type.DRY) && types.contains(BiomeDictionary.Type.SANDY)) {
                    EntityFireDragon firedragon = new EntityFireDragon(world);
                    firedragon.func_70107_b(x, height.func_177956_o() + 1, z);
                    int dragonage = 10 + random.nextInt(IceAndFireConfig.WORLDGEN.generateDragonSkeletonMaximumStage) * 25;
                    firedragon.growDragon(dragonage);
                    firedragon.modelDeadProgress = 20.0f;
                    firedragon.setModelDead(true);
                    firedragon.setDeathStage(dragonage / 5 / 2);
                    firedragon.field_70177_z = random.nextInt(360);
                    if (!world.field_72995_K) {
                        world.func_72838_d((Entity)firedragon);
                    }
                } else if (random.nextInt(IceAndFireConfig.WORLDGEN.generateDragonSkeletonChance) == 0 && isCold && isSnowy) {
                    EntityIceDragon icedragon = new EntityIceDragon(world);
                    icedragon.func_70107_b(x, height.func_177956_o() + 1, z);
                    int dragonage = 10 + random.nextInt(IceAndFireConfig.WORLDGEN.generateDragonSkeletonMaximumStage) * 25;
                    icedragon.growDragon(dragonage);
                    icedragon.modelDeadProgress = 20.0f;
                    icedragon.setModelDead(true);
                    icedragon.setDeathStage(dragonage / 5 / 2);
                    icedragon.field_70177_z = random.nextInt(360);
                    if (!world.field_72995_K) {
                        world.func_72838_d((Entity)icedragon);
                    }
                }
            }
            if (IceAndFireConfig.ENTITY_SPAWNING.spawnSeaSerpents && random.nextInt(IceAndFireConfig.ENTITY_SPAWNING.seaSerpentSpawnChance) == 0 && types.contains(BiomeDictionary.Type.OCEAN) && world.func_180495_p(pos2 = new BlockPos(x + random.nextInt(10) - 5, 20 + random.nextInt(40), z + random.nextInt(10) - 5)).func_185904_a() == Material.field_151586_h) {
                EntitySeaSerpent serpent = new EntitySeaSerpent(world);
                serpent.onWorldSpawn(random);
                serpent.func_70012_b((float)pos2.func_177958_n() + 0.5f, (float)pos2.func_177956_o() + 0.5f, (float)pos2.func_177952_p() + 0.5f, 0.0f, 0.0f);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)serpent);
                }
            }
            if (IceAndFireConfig.ENTITY_SPAWNING.spawnStymphalianBirds && random.nextInt(IceAndFireConfig.ENTITY_SPAWNING.stymphalianBirdSpawnChance) == 0 && types.contains(BiomeDictionary.Type.SWAMP)) {
                for (int i = 0; i < 4 + random.nextInt(4); ++i) {
                    BlockPos pos4 = height.func_177982_a(random.nextInt(10) - 5, 0, random.nextInt(10) - 5);
                    if (!world.func_180495_p(pos4.func_177977_b()).func_185914_p()) continue;
                    EntityStymphalianBird bird = new EntityStymphalianBird(world);
                    bird.func_70012_b((float)pos4.func_177958_n() + 0.5f, (float)pos4.func_177956_o() + 0.5f, (float)pos4.func_177952_p() + 0.5f, 0.0f, 0.0f);
                    if (!bird.func_70058_J() || world.field_72995_K) continue;
                    world.func_72838_d((Entity)bird);
                }
            }
            if (IceAndFireConfig.WORLDGEN.generateMyrmexColonies && StructureGenerator.isMyrmexGenAllowedInBiome(types, biomeName) && random.nextInt(IceAndFireConfig.WORLDGEN.myrmexColonyGenChance) == 0 && (types.contains(BiomeDictionary.Type.JUNGLE) || types.contains(BiomeDictionary.Type.HOT) && types.contains(BiomeDictionary.Type.DRY) && types.contains(BiomeDictionary.Type.SANDY)) && MyrmexWorldData.get(world).getNearestHive(height, 500) == null) {
                BlockPos lowestHeight = new BlockPos(height.func_177958_n(), world.func_82734_g(height.func_177958_n(), height.func_177952_p()), height.func_177952_p());
                int down = Math.max(15, lowestHeight.func_177956_o() - 20 + random.nextInt(10));
                if (types.contains(BiomeDictionary.Type.JUNGLE)) {
                    JUNGLE_MYRMEX_HIVE.func_180709_b(world, random, new BlockPos(lowestHeight.func_177958_n(), down, lowestHeight.func_177952_p()));
                } else {
                    DESERT_MYRMEX_HIVE.func_180709_b(world, random, new BlockPos(lowestHeight.func_177958_n(), down, lowestHeight.func_177952_p()));
                }
            }
        }
        if (IceAndFireConfig.WORLDGEN.generateSnowVillages && StructureGenerator.isVillageGenAllowedInDim(world.field_73011_w.getDimension()) && isCold && isSnowy) {
            SNOW_VILLAGE.func_180709_b(world, random, height);
        }
        if (IceAndFireConfig.ENTITY_SPAWNING.spawnHippocampus && random.nextInt(IceAndFireConfig.ENTITY_SPAWNING.hippocampusSpawnChance) == 0 && types.contains(BiomeDictionary.Type.OCEAN)) {
            for (int i = 0; i < random.nextInt(5); ++i) {
                BlockPos pos5 = new BlockPos(x + random.nextInt(10) - 5, 20 + random.nextInt(40), z + random.nextInt(10) - 5);
                if (world.func_180495_p(pos5).func_185904_a() != Material.field_151586_h) continue;
                EntityHippocampus campus = new EntityHippocampus(world);
                campus.setVariant(random.nextInt(5));
                campus.func_70012_b((float)pos5.func_177958_n() + 0.5f, (float)pos5.func_177956_o() + 0.5f, (float)pos5.func_177952_p() + 0.5f, 0.0f, 0.0f);
                if (!campus.func_70058_J() || world.field_72995_K) continue;
                world.func_72838_d((Entity)campus);
            }
        }
        if (IceAndFireConfig.WORLDGEN.generateCopperOre) {
            for (int copperAmount = 0; copperAmount < 2; ++copperAmount) {
                int oreHeight = random.nextInt(128);
                int xOre = chunkX * 16 + random.nextInt(16);
                int zOre = chunkZ * 16 + random.nextInt(16);
                new WorldGenMinable(ModBlocks.copperOre.func_176223_P(), 4 + random.nextInt(4)).func_180709_b(world, random, new BlockPos(xOre, oreHeight, zOre));
            }
        }
        if (IceAndFireConfig.WORLDGEN.generateSilverOre) {
            for (int silverAmount = 0; silverAmount < 2; ++silverAmount) {
                int oreHeight = random.nextInt(32);
                int xOre = chunkX * 16 + random.nextInt(16);
                int zOre = chunkZ * 16 + random.nextInt(16);
                new WorldGenMinable(ModBlocks.silverOre.func_176223_P(), 4 + random.nextInt(4)).func_180709_b(world, random, new BlockPos(xOre, oreHeight, zOre));
            }
        }
        if (IceAndFireConfig.WORLDGEN.generateAmethystOre && types.contains(BiomeDictionary.Type.JUNGLE)) {
            int count = 3 + random.nextInt(6);
            for (int amethystAmount = 0; amethystAmount < count; ++amethystAmount) {
                int zOre;
                int oreHeight = random.nextInt(28) + 4;
                int xOre = chunkX * 16 + random.nextInt(16);
                pos = new BlockPos(xOre, oreHeight, zOre = chunkZ * 16 + random.nextInt(16));
                state = world.func_180495_p(pos);
                if (!state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, pos, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b))) continue;
                world.func_175656_a(pos, ModBlocks.amethystOre.func_176223_P());
            }
        }
        if (IceAndFireConfig.WORLDGEN.generateSapphireOre && isSnowy) {
            int count = 3 + random.nextInt(6);
            for (int sapphireAmount = 0; sapphireAmount < count; ++sapphireAmount) {
                int zOre;
                int oreHeight = random.nextInt(28) + 4;
                int xOre = chunkX * 16 + random.nextInt(16);
                pos = new BlockPos(xOre, oreHeight, zOre = chunkZ * 16 + random.nextInt(16));
                state = world.func_180495_p(pos);
                if (!state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, pos, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b))) continue;
                world.func_175656_a(pos, ModBlocks.sapphireOre.func_176223_P());
            }
        }
        if (random.nextInt(5) == 0) {
            if (types.contains(BiomeDictionary.Type.JUNGLE)) {
                if (ModBlocks.lightning_lily.func_176196_c(world, height)) {
                    world.func_175656_a(height, ModBlocks.lightning_lily.func_176223_P());
                }
            } else if (isCold && isSnowy) {
                if (ModBlocks.frost_lily.func_176196_c(world, height)) {
                    world.func_175656_a(height, ModBlocks.frost_lily.func_176223_P());
                }
            } else if (types.contains(BiomeDictionary.Type.HOT) && types.contains(BiomeDictionary.Type.SANDY) && ModBlocks.fire_lily.func_176196_c(world, height)) {
                world.func_175656_a(height, ModBlocks.fire_lily.func_176223_P());
            }
        }
        if (random.nextInt(5) == 0 && types.contains(BiomeDictionary.Type.NETHER) && (surface = this.getNetherHeight(world, new BlockPos(x, 0, z))) != null) {
            world.func_175656_a(surface.func_177984_a(), ModBlocks.fire_lily.func_176223_P());
        }
    }

    public static void generateMyrmexHiveForQueen(EntityMyrmexQueen queen, Random rand, BlockPos position) {
        if (queen.isJungle()) {
            JUNGLE_MYRMEX_HIVE.generateForQueen(queen, rand, position);
        } else {
            DESERT_MYRMEX_HIVE.generateForQueen(queen, rand, position);
        }
    }

    private static boolean isFarEnoughFromSpawn(World world, BlockPos pos) {
        if (IceAndFireConfig.WORLDGEN.dangerousWorldGenDistanceLimit == 0) {
            return true;
        }
        BlockPos spawnRelative = new BlockPos(world.func_175694_M().func_177958_n(), pos.func_177956_o(), world.func_175694_M().func_177952_p());
        return spawnRelative.func_177951_i((Vec3i)pos) > (double)(IceAndFireConfig.WORLDGEN.dangerousWorldGenDistanceLimit * IceAndFireConfig.WORLDGEN.dangerousWorldGenDistanceLimit);
    }

    private static boolean genAllowedInDim(int id) {
        for (int i : IceAndFireConfig.WORLDGEN.chunkGenBlacklist) {
            if (i != id) continue;
            return IceAndFireConfig.WORLDGEN.chunkGenWhitelist;
        }
        return !IceAndFireConfig.WORLDGEN.chunkGenWhitelist;
    }

    private static boolean isDragonGenAllowedInDim(int id) {
        for (int i : IceAndFireConfig.WORLDGEN.dragonDimensionBlacklistedDimensions) {
            if (i != id) continue;
            return IceAndFireConfig.WORLDGEN.dragonDimensionWhitelist;
        }
        return !IceAndFireConfig.WORLDGEN.dragonDimensionWhitelist;
    }

    private static boolean isVillageGenAllowedInDim(int id) {
        for (int i : IceAndFireConfig.WORLDGEN.snowVillageBlacklistedDimensions) {
            if (i != id) continue;
            return IceAndFireConfig.WORLDGEN.snowVillageWhitelist;
        }
        return !IceAndFireConfig.WORLDGEN.snowVillageWhitelist;
    }

    private static boolean isMyrmexGenAllowedInBiome(Set<BiomeDictionary.Type> dictSet, String biomeName) {
        if (IceAndFireConfig.getMyrmexDisabledNames().contains(biomeName)) {
            return false;
        }
        for (BiomeDictionary.Type type : IceAndFireConfig.getMyrmexDisabledTypes()) {
            if (!dictSet.contains(type)) continue;
            return false;
        }
        return true;
    }

    private static boolean isDragonGenAllowedInBiome(Set<BiomeDictionary.Type> dictSet, String biomeName) {
        return !IceAndFireConfig.getDragonDisabledNames().contains(biomeName) && !StructureGenerator.doesBiomeMatchTypeInSet(dictSet, IceAndFireConfig.getDragonDisabledTypes());
    }

    private static boolean doesBiomeMatchTypeInSet(Set<BiomeDictionary.Type> dictSet, Set<BiomeDictionary.Type> biomeTypes) {
        for (BiomeDictionary.Type biomeType : biomeTypes) {
            if (!dictSet.contains(biomeType)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private EnumDragonType getDragonGenType(Set<BiomeDictionary.Type> dictSet, Biome biome, String biomeName, boolean isCold, boolean isSnowy) {
        if (IceAndFireConfig.getFireDragonEnabledNames().contains(biomeName)) {
            return EnumDragonType.FIRE;
        }
        if (IceAndFireConfig.getIceDragonEnabledNames().contains(biomeName)) {
            return EnumDragonType.ICE;
        }
        if (IceAndFireConfig.getLightningDragonEnabledNames().contains(biomeName)) {
            return EnumDragonType.LIGHTNING;
        }
        if (!StructureGenerator.doesBiomeMatchTypeInSet(dictSet, IceAndFireConfig.getLightningDragonDisabledTypes()) && StructureGenerator.doesBiomeMatchTypeInSet(dictSet, IceAndFireConfig.getLightningDragonEnabledTypes())) {
            return EnumDragonType.LIGHTNING;
        }
        if (!StructureGenerator.doesBiomeMatchTypeInSet(dictSet, IceAndFireConfig.getFireDragonDisabledTypes()) && !biome.func_76746_c() && (double)biome.func_185353_n() > -0.5 || StructureGenerator.doesBiomeMatchTypeInSet(dictSet, IceAndFireConfig.getFireDragonEnabledTypes())) {
            return EnumDragonType.FIRE;
        }
        if (!StructureGenerator.doesBiomeMatchTypeInSet(dictSet, IceAndFireConfig.getIceDragonDisabledTypes()) && (isCold && isSnowy || StructureGenerator.doesBiomeMatchTypeInSet(dictSet, IceAndFireConfig.getIceDragonEnabledTypes()))) {
            return EnumDragonType.ICE;
        }
        return null;
    }

    private BlockPos getNetherHeight(World world, BlockPos pos) {
        for (int i = 0; i < 255; ++i) {
            BlockPos ground = pos.func_177981_b(i);
            if (world.func_180495_p(ground).func_177230_c() != Blocks.field_150424_aL || !world.func_175623_d(ground.func_177984_a())) continue;
            return ground;
        }
        return null;
    }
}

