/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.enums;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.IceAndFireConfig;
import com.github.alexthe666.iceandfire.core.ModItems;
import com.github.alexthe666.iceandfire.item.ItemTrollArmor;
import com.github.alexthe666.iceandfire.item.ItemTrollWeapon;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.GameRegistry;

public enum EnumTroll {
    FOREST(BiomeDictionary.Type.FOREST, ModItems.troll_forest, ModItems.troll_leather_forest, Weapon.TRUNK, Weapon.COLUMN_FOREST, Weapon.AXE, Weapon.HAMMER),
    FROST(BiomeDictionary.Type.SNOWY, ModItems.troll_frost, ModItems.troll_leather_frost, Weapon.COLUMN_FROST, Weapon.TRUNK_FROST, Weapon.AXE, Weapon.HAMMER),
    MOUNTAIN(BiomeDictionary.Type.MOUNTAIN, ModItems.troll_mountain, ModItems.troll_leather_mountain, Weapon.COLUMN, Weapon.AXE, Weapon.HAMMER);

    public final ResourceLocation TEXTURE;
    public final ResourceLocation TEXTURE_STONE;
    public final ResourceLocation TEXTURE_EYES;
    public final BiomeDictionary.Type spawnBiome;
    public final ItemArmor.ArmorMaterial material;
    public final Item leather;
    private Weapon[] weapons;
    @GameRegistry.ObjectHolder(value="iceandfire:troll_helmet")
    public Item helmet;
    @GameRegistry.ObjectHolder(value="iceandfire:troll_chestplate")
    public Item chestplate;
    @GameRegistry.ObjectHolder(value="iceandfire:troll_leggings")
    public Item leggings;
    @GameRegistry.ObjectHolder(value="iceandfire:troll_boots")
    public Item boots;

    private EnumTroll(BiomeDictionary.Type biome, ItemArmor.ArmorMaterial material, Item leather, Weapon ... weapons) {
        this.spawnBiome = biome;
        this.weapons = weapons;
        this.material = material;
        this.leather = leather;
        this.TEXTURE = new ResourceLocation("iceandfire:textures/models/troll/troll_" + this.name().toLowerCase() + ".png");
        this.TEXTURE_STONE = new ResourceLocation("iceandfire:textures/models/troll/troll_" + this.name().toLowerCase() + "_stone.png");
        this.TEXTURE_EYES = new ResourceLocation("iceandfire:textures/models/troll/troll_" + this.name().toLowerCase() + "_eyes.png");
        this.helmet = new ItemTrollArmor(this, material, 0, EntityEquipmentSlot.HEAD);
        this.chestplate = new ItemTrollArmor(this, material, 1, EntityEquipmentSlot.CHEST);
        this.leggings = new ItemTrollArmor(this, material, 2, EntityEquipmentSlot.LEGS);
        this.boots = new ItemTrollArmor(this, material, 3, EntityEquipmentSlot.FEET);
    }

    public static EnumTroll getBiomeType(Biome biome) {
        if (!IceAndFireConfig.getTrollSpawnType().isEmpty()) {
            String value;
            EnumTroll type;
            String biomeName;
            String string = biomeName = biome.getRegistryName() != null ? biome.getRegistryName().toString() : null;
            if (IceAndFireConfig.getTrollSpawnType().containsKey(biomeName) && (type = EnumTroll.getType(value = IceAndFireConfig.getTrollSpawnType().get(biomeName))) != null) {
                return type;
            }
        }
        ArrayList<EnumTroll> types = new ArrayList<EnumTroll>();
        for (EnumTroll type : EnumTroll.values()) {
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)type.spawnBiome)) continue;
            types.add(type);
        }
        if (types.isEmpty()) {
            return EnumTroll.values()[new Random().nextInt(EnumTroll.values().length)];
        }
        return (EnumTroll)((Object)types.get(new Random().nextInt(types.size())));
    }

    public static Weapon getWeaponForType(EnumTroll troll) {
        return troll.weapons[new Random().nextInt(troll.weapons.length)];
    }

    private static EnumTroll getType(String value) {
        EnumTroll type = null;
        try {
            type = EnumTroll.valueOf(value.toUpperCase());
        }
        catch (Exception e) {
            IceAndFire.logger.error("Invalid troll spawn type: " + value);
        }
        return type;
    }

    public static enum Weapon {
        AXE,
        COLUMN,
        COLUMN_FOREST,
        COLUMN_FROST,
        HAMMER,
        TRUNK,
        TRUNK_FROST;

        public ResourceLocation TEXTURE = new ResourceLocation("iceandfire:textures/models/troll/weapon/weapon_" + this.name().toLowerCase() + ".png");
        public Item item = new ItemTrollWeapon(this);
    }
}

