/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.enums;

import com.github.alexthe666.iceandfire.IceAndFireConfig;
import com.github.alexthe666.iceandfire.block.BlockEggInIce;
import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.core.ModSounds;
import com.github.alexthe666.iceandfire.entity.EntityDragonEgg;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.entity.EntityLightningDragon;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityEggInIce;
import java.util.Objects;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.math.BlockPos;

public enum EnumDragonType {
    FIRE("fire"){

        @Override
        public void updateEggCondition(EntityDragonEgg egg) {
            BlockPos pos = new BlockPos((Entity)egg);
            if (!this.meetsEggCondition(egg, pos)) {
                return;
            }
            egg.setDragonAge(egg.getDragonAge() + 1);
            if (egg.getDragonAge() > IceAndFireConfig.DRAGON_SETTINGS.dragonEggTime) {
                egg.field_70170_p.func_175698_g(pos);
                EntityFireDragon dragon = new EntityFireDragon(egg.field_70170_p);
                if (egg.func_145818_k_()) {
                    dragon.func_96094_a(egg.func_95999_t());
                }
                dragon.setVariant(egg.getType().meta % 4);
                dragon.setGender(egg.field_70170_p.field_73012_v.nextBoolean());
                dragon.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
                dragon.setHunger(50);
                if (!egg.field_70170_p.field_72995_K) {
                    egg.field_70170_p.func_72838_d((Entity)dragon);
                }
                dragon.func_70903_f(true);
                dragon.func_184754_b(egg.getOwnerId());
                egg.field_70170_p.func_184134_a(egg.field_70165_t, egg.field_70163_u + (double)egg.func_70047_e(), egg.field_70161_v, SoundEvents.field_187646_bt, egg.func_184176_by(), 2.5f, 1.0f, false);
                egg.field_70170_p.func_184134_a(egg.field_70165_t, egg.field_70163_u + (double)egg.func_70047_e(), egg.field_70161_v, ModSounds.DRAGON_HATCH, egg.func_184176_by(), 2.5f, 1.0f, false);
                egg.func_70106_y();
            }
        }

        @Override
        public boolean meetsEggCondition(EntityDragonEgg egg, BlockPos pos) {
            return egg.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151581_o;
        }
    }
    ,
    ICE("ice", true){

        @Override
        public void updateEggCondition(EntityDragonEgg egg) {
            BlockPos pos = new BlockPos((Entity)egg);
            if (!this.meetsEggCondition(egg, pos)) {
                return;
            }
            egg.func_70106_y();
            egg.field_70170_p.func_175656_a(pos, ModBlocks.eggInIce.func_176223_P());
            egg.field_70170_p.func_184134_a(egg.field_70165_t, egg.field_70163_u + (double)egg.func_70047_e(), egg.field_70161_v, SoundEvents.field_187561_bM, egg.func_184176_by(), 2.5f, 1.0f, false);
            if (egg.field_70170_p.func_180495_p(pos).func_177230_c() instanceof BlockEggInIce) {
                ((TileEntityEggInIce)Objects.requireNonNull(egg.field_70170_p.func_175625_s((BlockPos)pos))).type = egg.getType();
                ((TileEntityEggInIce)Objects.requireNonNull(egg.field_70170_p.func_175625_s((BlockPos)pos))).ownerUUID = egg.getOwnerId();
            }
        }

        @Override
        public boolean meetsEggCondition(EntityDragonEgg egg, BlockPos pos) {
            return egg.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h && egg.field_70170_p.field_73012_v.nextInt(500) == 0;
        }
    }
    ,
    LIGHTNING("lightning"){

        @Override
        public void updateEggCondition(EntityDragonEgg egg) {
            BlockPos pos = new BlockPos((Entity)egg);
            if (!this.meetsEggCondition(egg, pos)) {
                return;
            }
            egg.setDragonAge(egg.getDragonAge() + 1);
            if (egg.getDragonAge() > IceAndFireConfig.DRAGON_SETTINGS.dragonEggTime) {
                egg.field_70170_p.func_175698_g(pos);
                EntityLightningDragon dragon = new EntityLightningDragon(egg.field_70170_p);
                if (egg.func_145818_k_()) {
                    dragon.func_96094_a(egg.func_95999_t());
                }
                dragon.setVariant(egg.getType().meta % 4);
                dragon.setGender(egg.field_70170_p.field_73012_v.nextBoolean());
                dragon.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
                dragon.setHunger(50);
                if (!egg.field_70170_p.field_72995_K) {
                    egg.field_70170_p.func_72838_d((Entity)dragon);
                }
                dragon.func_70903_f(true);
                dragon.func_184754_b(egg.getOwnerId());
                if (!egg.field_70170_p.field_72995_K) {
                    EntityLightningBolt lightningBolt = new EntityLightningBolt(egg.field_70170_p, egg.field_70165_t, egg.field_70163_u, egg.field_70161_v, true);
                    egg.field_70170_p.func_72838_d((Entity)lightningBolt);
                }
                egg.field_70170_p.func_184134_a(egg.field_70165_t, egg.field_70163_u + (double)egg.func_70047_e(), egg.field_70161_v, SoundEvents.field_187754_de, egg.func_184176_by(), 2.5f, 1.0f, false);
                egg.field_70170_p.func_184134_a(egg.field_70165_t, egg.field_70163_u + (double)egg.func_70047_e(), egg.field_70161_v, ModSounds.DRAGON_HATCH, egg.func_184176_by(), 2.5f, 1.0f, false);
                egg.func_70106_y();
            }
        }

        @Override
        public boolean meetsEggCondition(EntityDragonEgg egg, BlockPos pos) {
            return egg.field_70170_p.func_175727_C(pos) || egg.field_70170_p.func_175727_C(pos.func_177963_a(0.0, (double)egg.field_70131_O, 0.0));
        }
    };

    private final String name;
    private final boolean piscivore;

    private EnumDragonType(String name) {
        this(name, false);
    }

    private EnumDragonType(String name, boolean piscivore) {
        this.name = name;
        this.piscivore = piscivore;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPiscivore() {
        return this.piscivore;
    }

    public void updateEggCondition(EntityDragonEgg egg) {
    }

    public boolean meetsEggCondition(EntityDragonEgg egg, BlockPos pos) {
        return false;
    }
}

