/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.util;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.IceAndFireConfig;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexQueen;
import com.github.alexthe666.iceandfire.structures.WorldGenMyrmexHive;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.VillageDoorInfo;
import net.minecraft.world.World;

public class MyrmexHive {
    private World world;
    private final List<VillageDoorInfo> villageDoorInfoList = Lists.newArrayList();
    private final List<BlockPos> foodRooms = Lists.newArrayList();
    private final List<BlockPos> babyRooms = Lists.newArrayList();
    private final List<BlockPos> miscRooms = Lists.newArrayList();
    private final List<BlockPos> allRooms = Lists.newArrayList();
    private final Map<BlockPos, EnumFacing> entrances = Maps.newHashMap();
    private final Map<BlockPos, EnumFacing> entranceBottoms = Maps.newHashMap();
    private BlockPos centerHelper = BlockPos.field_177992_a;
    private BlockPos center = BlockPos.field_177992_a;
    private int villageRadius;
    private int lastAddDoorTimestamp;
    private int tickCounter;
    private int numMyrmex;
    private int noBreedTicks;
    private final Map<UUID, Integer> playerReputation = Maps.newHashMap();
    private final List<HiveAggressor> villageAgressors = Lists.newArrayList();
    private final List<UUID> myrmexList = Lists.newArrayList();
    public UUID hiveUUID;
    public String colonyName = "";
    public boolean reproduces = true;
    public boolean hasOwner = false;
    public UUID ownerUUID = null;

    public MyrmexHive() {
        this.hiveUUID = UUID.randomUUID();
    }

    public MyrmexHive(World worldIn) {
        this.world = worldIn;
        this.hiveUUID = UUID.randomUUID();
    }

    public MyrmexHive(World worldIn, BlockPos center, int radius) {
        this.world = worldIn;
        this.center = center;
        this.villageRadius = radius;
        this.hiveUUID = UUID.randomUUID();
    }

    public void setWorld(World worldIn) {
        this.world = worldIn;
    }

    public void tick(int tickCounterIn, World world) {
        ++this.tickCounter;
        this.removeDeadAndOldAgressors();
        if (this.tickCounter % 20 == 0) {
            this.updateNumMyrmex(world);
        }
    }

    private void updateNumMyrmex(World world) {
        this.numMyrmex = this.myrmexList.size();
        if (this.numMyrmex == 0) {
            this.playerReputation.clear();
        }
    }

    public EntityMyrmexQueen getQueen() {
        List allQueens = this.world.func_175644_a(EntityMyrmexQueen.class, EntitySelectors.field_180132_d);
        ArrayList<EntityMyrmexQueen> ourQueens = new ArrayList<EntityMyrmexQueen>();
        for (EntityMyrmexQueen queen : allQueens) {
            if (!queen.getHive().equals(this)) continue;
            ourQueens.add(queen);
        }
        return ourQueens.isEmpty() ? null : (EntityMyrmexQueen)((Object)ourQueens.get(0));
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public BlockPos getCenterGround() {
        return MyrmexHive.getGroundedPos(this.world, this.center);
    }

    public static BlockPos getGroundedPos(World world, BlockPos pos) {
        BlockPos current = pos;
        while (world.func_175623_d(current.func_177977_b()) && current.func_177956_o() > 0) {
            current = current.func_177977_b();
        }
        return current;
    }

    public int getVillageRadius() {
        return this.villageRadius;
    }

    public int getNumMyrmex() {
        return this.numMyrmex;
    }

    public boolean isBlockPosWithinSqVillageRadius(BlockPos pos) {
        return this.center.func_177951_i((Vec3i)pos) < (double)(this.villageRadius * this.villageRadius);
    }

    public boolean isAnnihilated() {
        return false;
    }

    public void addOrRenewAgressor(EntityLivingBase entitylivingbaseIn, int agressiveLevel) {
        for (HiveAggressor hive$villageaggressor : this.villageAgressors) {
            if (hive$villageaggressor.agressor != entitylivingbaseIn) continue;
            hive$villageaggressor.agressionTime = this.tickCounter;
            return;
        }
        this.villageAgressors.add(new HiveAggressor(entitylivingbaseIn, this.tickCounter, agressiveLevel));
    }

    @Nullable
    public EntityLivingBase findNearestVillageAggressor(EntityLivingBase entitylivingbaseIn) {
        double d0 = Double.MAX_VALUE;
        int previousAgressionLevel = 0;
        HiveAggressor hive$villageaggressor = null;
        for (int i = 0; i < this.villageAgressors.size(); ++i) {
            HiveAggressor hive$villageaggressor1 = this.villageAgressors.get(i);
            double d1 = hive$villageaggressor1.agressor.func_70068_e((Entity)entitylivingbaseIn);
            int agressionLevel = hive$villageaggressor1.agressionLevel;
            if (d1 <= d0 || agressionLevel > previousAgressionLevel) {
                hive$villageaggressor = hive$villageaggressor1;
                d0 = d1;
            }
            previousAgressionLevel = agressionLevel;
        }
        return hive$villageaggressor == null ? null : hive$villageaggressor.agressor;
    }

    public EntityPlayer getNearestTargetPlayer(EntityLivingBase villageDefender, World world) {
        double d0 = Double.MAX_VALUE;
        EntityPlayer entityplayer = null;
        for (UUID s : this.playerReputation.keySet()) {
            double d1;
            EntityPlayer entityplayer1;
            if (!this.isPlayerReputationTooLowToFight(s) || (entityplayer1 = world.func_152378_a(s)) == null || !((d1 = entityplayer1.func_70068_e((Entity)villageDefender)) <= d0)) continue;
            entityplayer = entityplayer1;
            d0 = d1;
        }
        return entityplayer;
    }

    private void removeDeadAndOldAgressors() {
        Iterator<HiveAggressor> iterator = this.villageAgressors.iterator();
        while (iterator.hasNext()) {
            HiveAggressor hive$villageaggressor = iterator.next();
            if (hive$villageaggressor.agressor.func_70089_S() && Math.abs(this.tickCounter - hive$villageaggressor.agressionTime) <= 300) continue;
            iterator.remove();
        }
    }

    public int getPlayerReputation(UUID playerName) {
        Integer integer = this.playerReputation.get(playerName);
        return integer == null ? 0 : integer;
    }

    private UUID findUUID(String name) {
        if (this.world == null || this.world.func_73046_m() == null) {
            return EntityPlayer.func_175147_b((String)name);
        }
        GameProfile profile = this.world.func_73046_m().func_152358_ax().func_152655_a(name);
        return profile == null ? EntityPlayer.func_175147_b((String)name) : profile.getId();
    }

    public int modifyPlayerReputation(UUID playerName, int reputation) {
        int i = this.getPlayerReputation(playerName);
        int j = MathHelper.func_76125_a((int)(i + reputation), (int)0, (int)100);
        if (this.hasOwner && playerName.equals(this.ownerUUID)) {
            j = 100;
        }
        EntityPlayer player = null;
        try {
            player = this.world.func_152378_a(playerName);
        }
        catch (Exception e) {
            IceAndFire.logger.warn("Myrmex Hive could not find player with associated UUID");
        }
        if (player != null) {
            if (j - i != 0) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation(j - i >= 0 ? "myrmex.message.raised_reputation" : "myrmex.message.lowered_reputation", new Object[]{Math.abs(j - i), j}), true);
            }
            if (i < 25 && j >= 25) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("myrmex.message.peaceful", new Object[0]), false);
            }
            if (i >= 25 && j < 25) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("myrmex.message.hostile", new Object[0]), false);
            }
            if (i < 50 && j >= 50) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("myrmex.message.trade", new Object[0]), false);
            }
            if (i >= 50 && j < 50) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("myrmex.message.no_trade", new Object[0]), false);
            }
            if (i < 75 && j >= 75) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("myrmex.message.can_use_staff", new Object[0]), false);
            }
            if (i >= 75 && j < 75) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("myrmex.message.cant_use_staff", new Object[0]), false);
            }
        }
        this.playerReputation.put(playerName, j);
        return j;
    }

    public boolean isPlayerReputationTooLowToTrade(UUID uuid) {
        return this.getPlayerReputation(uuid) < 50;
    }

    public boolean canPlayerCommandHive(UUID uuid) {
        return this.getPlayerReputation(uuid) >= 75;
    }

    public boolean isPlayerReputationTooLowToFight(UUID uuid) {
        return this.getPlayerReputation(uuid) < 25;
    }

    public boolean isPlayerReputationMaxed(UUID uuid) {
        return this.getPlayerReputation(uuid) >= 100;
    }

    public void readVillageDataFromNBT(NBTTagCompound compound) {
        this.numMyrmex = compound.func_74762_e("PopSize");
        this.reproduces = compound.func_74767_n("Reproduces");
        this.hasOwner = compound.func_74767_n("HasOwner");
        this.ownerUUID = compound.func_186857_a("OwnerUUID");
        this.colonyName = compound.func_74779_i("ColonyName");
        this.villageRadius = compound.func_74762_e("Radius");
        this.lastAddDoorTimestamp = compound.func_74762_e("Stable");
        this.tickCounter = compound.func_74762_e("Tick");
        this.noBreedTicks = compound.func_74762_e("MTick");
        this.center = new BlockPos(compound.func_74762_e("CX"), compound.func_74762_e("CY"), compound.func_74762_e("CZ"));
        this.centerHelper = new BlockPos(compound.func_74762_e("ACX"), compound.func_74762_e("ACY"), compound.func_74762_e("ACZ"));
        NBTTagList nbttaglist = compound.func_150295_c("Doors", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            VillageDoorInfo villagedoorinfo = new VillageDoorInfo(new BlockPos(nbttagcompound.func_74762_e("X"), nbttagcompound.func_74762_e("Y"), nbttagcompound.func_74762_e("Z")), nbttagcompound.func_74762_e("IDX"), nbttagcompound.func_74762_e("IDZ"), nbttagcompound.func_74762_e("TS"));
            this.villageDoorInfoList.add(villagedoorinfo);
        }
        NBTTagList hiveMembers = compound.func_150295_c("HiveMembers", 10);
        this.myrmexList.clear();
        for (int i = 0; i < hiveMembers.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = hiveMembers.func_150305_b(i);
            this.myrmexList.add(nbttagcompound.func_186857_a("MyrmexUUID"));
        }
        NBTTagList foodRoomList = compound.func_150295_c("FoodRooms", 10);
        this.foodRooms.clear();
        for (int i = 0; i < foodRoomList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = foodRoomList.func_150305_b(i);
            this.foodRooms.add(new BlockPos(nbttagcompound.func_74762_e("X"), nbttagcompound.func_74762_e("Y"), nbttagcompound.func_74762_e("Z")));
        }
        NBTTagList babyRoomList = compound.func_150295_c("BabyRooms", 10);
        this.babyRooms.clear();
        for (int i = 0; i < babyRoomList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = babyRoomList.func_150305_b(i);
            this.babyRooms.add(new BlockPos(nbttagcompound.func_74762_e("X"), nbttagcompound.func_74762_e("Y"), nbttagcompound.func_74762_e("Z")));
        }
        NBTTagList miscRoomList = compound.func_150295_c("MiscRooms", 10);
        this.miscRooms.clear();
        for (int i = 0; i < miscRoomList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = miscRoomList.func_150305_b(i);
            this.miscRooms.add(new BlockPos(nbttagcompound.func_74762_e("X"), nbttagcompound.func_74762_e("Y"), nbttagcompound.func_74762_e("Z")));
        }
        NBTTagList entrancesList = compound.func_150295_c("Entrances", 10);
        this.entrances.clear();
        for (int i = 0; i < entrancesList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = entrancesList.func_150305_b(i);
            this.entrances.put(new BlockPos(nbttagcompound.func_74762_e("X"), nbttagcompound.func_74762_e("Y"), nbttagcompound.func_74762_e("Z")), EnumFacing.func_176731_b((int)nbttagcompound.func_74762_e("Facing")));
        }
        NBTTagList entranceBottomsList = compound.func_150295_c("EntranceBottoms", 10);
        this.entranceBottoms.clear();
        for (int i = 0; i < entranceBottomsList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = entranceBottomsList.func_150305_b(i);
            this.entranceBottoms.put(new BlockPos(nbttagcompound.func_74762_e("X"), nbttagcompound.func_74762_e("Y"), nbttagcompound.func_74762_e("Z")), EnumFacing.func_176731_b((int)nbttagcompound.func_74762_e("Facing")));
        }
        this.hiveUUID = compound.func_186857_a("HiveUUID");
        NBTTagList nbttaglist1 = compound.func_150295_c("Players", 10);
        for (int j = 0; j < nbttaglist1.func_74745_c(); ++j) {
            NBTTagCompound nbttagcompound1 = nbttaglist1.func_150305_b(j);
            if (nbttagcompound1.func_74764_b("UUID")) {
                this.playerReputation.put(UUID.fromString(nbttagcompound1.func_74779_i("UUID")), nbttagcompound1.func_74762_e("S"));
                continue;
            }
            this.playerReputation.put(this.findUUID(nbttagcompound1.func_74779_i("Name")), nbttagcompound1.func_74762_e("S"));
        }
    }

    public void writeVillageDataToNBT(NBTTagCompound compound) {
        compound.func_74768_a("PopSize", this.numMyrmex);
        compound.func_74757_a("Reproduces", this.reproduces);
        compound.func_74757_a("HasOwner", this.hasOwner);
        if (this.ownerUUID != null) {
            compound.func_186854_a("OwnerUUID", this.ownerUUID);
        }
        compound.func_74778_a("ColonyName", this.colonyName);
        compound.func_74768_a("Radius", this.villageRadius);
        compound.func_74768_a("Stable", this.lastAddDoorTimestamp);
        compound.func_74768_a("Tick", this.tickCounter);
        compound.func_74768_a("MTick", this.noBreedTicks);
        compound.func_74768_a("CX", this.center.func_177958_n());
        compound.func_74768_a("CY", this.center.func_177956_o());
        compound.func_74768_a("CZ", this.center.func_177952_p());
        compound.func_74768_a("ACX", this.centerHelper.func_177958_n());
        compound.func_74768_a("ACY", this.centerHelper.func_177956_o());
        compound.func_74768_a("ACZ", this.centerHelper.func_177952_p());
        NBTTagList nbttaglist = new NBTTagList();
        for (VillageDoorInfo villageDoorInfo : this.villageDoorInfoList) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74768_a("X", villageDoorInfo.func_179852_d().func_177958_n());
            nBTTagCompound.func_74768_a("Y", villageDoorInfo.func_179852_d().func_177956_o());
            nBTTagCompound.func_74768_a("Z", villageDoorInfo.func_179852_d().func_177952_p());
            nBTTagCompound.func_74768_a("IDX", villageDoorInfo.func_179847_f());
            nBTTagCompound.func_74768_a("IDZ", villageDoorInfo.func_179855_g());
            nBTTagCompound.func_74768_a("TS", villageDoorInfo.func_75473_b());
            nbttaglist.func_74742_a((NBTBase)nBTTagCompound);
        }
        NBTTagList hiveMembers = new NBTTagList();
        for (UUID uUID : this.myrmexList) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_186854_a("MyrmexUUID", uUID);
            hiveMembers.func_74742_a((NBTBase)nBTTagCompound);
        }
        compound.func_74782_a("HiveMembers", (NBTBase)hiveMembers);
        NBTTagList nBTTagList = new NBTTagList();
        for (BlockPos blockPos : this.foodRooms) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74768_a("X", blockPos.func_177958_n());
            nBTTagCompound.func_74768_a("Y", blockPos.func_177956_o());
            nBTTagCompound.func_74768_a("Z", blockPos.func_177952_p());
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound);
        }
        compound.func_74782_a("FoodRooms", (NBTBase)nBTTagList);
        NBTTagList nBTTagList2 = new NBTTagList();
        for (BlockPos blockPos : this.babyRooms) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74768_a("X", blockPos.func_177958_n());
            nBTTagCompound.func_74768_a("Y", blockPos.func_177956_o());
            nBTTagCompound.func_74768_a("Z", blockPos.func_177952_p());
            nBTTagList2.func_74742_a((NBTBase)nBTTagCompound);
        }
        compound.func_74782_a("BabyRooms", (NBTBase)nBTTagList2);
        NBTTagList nBTTagList3 = new NBTTagList();
        for (BlockPos blockPos : this.miscRooms) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74768_a("X", blockPos.func_177958_n());
            nBTTagCompound.func_74768_a("Y", blockPos.func_177956_o());
            nBTTagCompound.func_74768_a("Z", blockPos.func_177952_p());
            nBTTagList3.func_74742_a((NBTBase)nBTTagCompound);
        }
        compound.func_74782_a("MiscRooms", (NBTBase)nBTTagList3);
        NBTTagList nBTTagList4 = new NBTTagList();
        for (Map.Entry<BlockPos, EnumFacing> entry : this.entrances.entrySet()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74768_a("X", entry.getKey().func_177958_n());
            nBTTagCompound.func_74768_a("Y", entry.getKey().func_177956_o());
            nBTTagCompound.func_74768_a("Z", entry.getKey().func_177952_p());
            nBTTagCompound.func_74768_a("Facing", entry.getValue().func_176736_b());
            nBTTagList4.func_74742_a((NBTBase)nBTTagCompound);
        }
        compound.func_74782_a("Entrances", (NBTBase)nBTTagList4);
        NBTTagList nBTTagList5 = new NBTTagList();
        for (Map.Entry<BlockPos, EnumFacing> entry : this.entranceBottoms.entrySet()) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("X", entry.getKey().func_177958_n());
            nbttagcompound.func_74768_a("Y", entry.getKey().func_177956_o());
            nbttagcompound.func_74768_a("Z", entry.getKey().func_177952_p());
            nbttagcompound.func_74768_a("Facing", entry.getValue().func_176736_b());
            nBTTagList5.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("EntranceBottoms", (NBTBase)nBTTagList5);
        compound.func_186854_a("HiveUUID", this.hiveUUID);
        compound.func_74782_a("Doors", (NBTBase)nbttaglist);
        NBTTagList nBTTagList6 = new NBTTagList();
        for (UUID s : this.playerReputation.keySet()) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            try {
                nbttagcompound1.func_74778_a("UUID", s.toString());
                nbttagcompound1.func_74768_a("S", this.playerReputation.get(s).intValue());
                nBTTagList6.func_74742_a((NBTBase)nbttagcompound1);
            }
            catch (RuntimeException runtimeException) {}
        }
        compound.func_74782_a("Players", (NBTBase)nBTTagList6);
    }

    public void addRoom(BlockPos center, WorldGenMyrmexHive.RoomType roomType) {
        if (roomType == WorldGenMyrmexHive.RoomType.FOOD && !this.foodRooms.contains(center)) {
            this.foodRooms.add(center);
        } else if (roomType == WorldGenMyrmexHive.RoomType.NURSERY && !this.babyRooms.contains(center)) {
            this.babyRooms.add(center);
        } else if (!this.miscRooms.contains(center) && !this.miscRooms.contains(center)) {
            this.miscRooms.add(center);
        }
        this.allRooms.add(center);
    }

    public void addRoomWithMessage(EntityPlayer player, BlockPos center, WorldGenMyrmexHive.RoomType roomType) {
        ArrayList<BlockPos> allCurrentRooms = new ArrayList<BlockPos>(this.getAllRooms());
        allCurrentRooms.addAll(this.getEntrances().keySet());
        allCurrentRooms.addAll(this.getEntranceBottoms().keySet());
        if (roomType == WorldGenMyrmexHive.RoomType.FOOD) {
            if (!this.foodRooms.contains(center) && !allCurrentRooms.contains(center)) {
                this.foodRooms.add(center);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("myrmex.message.added_food_room", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), false);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("myrmex.message.dupe_room", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), false);
            }
        } else if (roomType == WorldGenMyrmexHive.RoomType.NURSERY) {
            if (!this.babyRooms.contains(center) && !allCurrentRooms.contains(center)) {
                this.babyRooms.add(center);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("myrmex.message.added_nursery_room", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), false);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("myrmex.message.dupe_room", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), false);
            }
        } else if (!this.miscRooms.contains(center) && !allCurrentRooms.contains(center)) {
            this.miscRooms.add(center);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("myrmex.message.added_misc_room", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), false);
        } else {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("myrmex.message.dupe_room", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), false);
        }
    }

    public void addEnteranceWithMessage(EntityPlayer player, boolean bottom, BlockPos center, EnumFacing facing) {
        ArrayList<BlockPos> allCurrentRooms = new ArrayList<BlockPos>(this.getAllRooms());
        allCurrentRooms.addAll(this.getEntrances().keySet());
        allCurrentRooms.addAll(this.getEntranceBottoms().keySet());
        if (bottom) {
            if (allCurrentRooms.contains(center)) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("myrmex.message.dupe_room", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), false);
            } else {
                this.getEntranceBottoms().put(center, facing);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("myrmex.message.added_enterance_bottom", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), false);
            }
        } else if (allCurrentRooms.contains(center)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("myrmex.message.dupe_room", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), false);
        } else {
            this.getEntrances().put(center, facing);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("myrmex.message.added_enterance_surface", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), false);
        }
    }

    public List<BlockPos> getRooms(WorldGenMyrmexHive.RoomType roomType) {
        if (roomType == WorldGenMyrmexHive.RoomType.FOOD) {
            return this.foodRooms;
        }
        if (roomType == WorldGenMyrmexHive.RoomType.NURSERY) {
            return this.babyRooms;
        }
        return this.miscRooms;
    }

    public List<BlockPos> getAllRooms() {
        this.allRooms.clear();
        this.allRooms.add(this.center);
        this.allRooms.addAll(this.foodRooms);
        this.allRooms.addAll(this.babyRooms);
        this.allRooms.addAll(this.miscRooms);
        return this.allRooms;
    }

    public BlockPos getRandomRoom(Random random, BlockPos returnPos) {
        List<BlockPos> rooms = this.getAllRooms();
        return rooms.isEmpty() ? returnPos : rooms.get(random.nextInt(Math.max(rooms.size() - 1, 1)));
    }

    public BlockPos getRandomRoom(WorldGenMyrmexHive.RoomType roomType, Random random, BlockPos returnPos) {
        List<BlockPos> rooms = this.getRooms(roomType);
        return rooms.isEmpty() ? returnPos : rooms.get(random.nextInt(Math.max(rooms.size() - 1, 1)));
    }

    public BlockPos getClosestEntranceToEntity(Entity entity, Random random, boolean randomize) {
        Map.Entry<BlockPos, EnumFacing> closest = this.getClosestEntrance(entity);
        if (closest != null) {
            if (randomize) {
                BlockPos pos = closest.getKey().func_177967_a(closest.getValue(), random.nextInt(7) + 7).func_177981_b(4);
                return pos.func_177982_a(10 - random.nextInt(20), 0, 10 - random.nextInt(20));
            }
            return closest.getKey().func_177967_a(closest.getValue(), 3);
        }
        return entity.func_180425_c();
    }

    public BlockPos getClosestEntranceBottomToEntity(Entity entity, Random random) {
        Map.Entry<BlockPos, EnumFacing> closest = null;
        for (Map.Entry<BlockPos, EnumFacing> entry : this.entranceBottoms.entrySet()) {
            if (closest != null && !(((BlockPos)closest.getKey()).func_177954_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v) > entry.getKey().func_177954_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v))) continue;
            closest = entry;
        }
        return closest != null ? (BlockPos)closest.getKey() : entity.func_180425_c();
    }

    public EntityPlayer getOwner(World world) {
        if (this.hasOwner) {
            return world.func_152378_a(this.ownerUUID);
        }
        return null;
    }

    public Map<BlockPos, EnumFacing> getEntrances() {
        return this.entrances;
    }

    public Map<BlockPos, EnumFacing> getEntranceBottoms() {
        return this.entranceBottoms;
    }

    private Map.Entry<BlockPos, EnumFacing> getClosestEntrance(Entity entity) {
        Map.Entry<BlockPos, EnumFacing> closest = null;
        for (Map.Entry<BlockPos, EnumFacing> entry : this.entrances.entrySet()) {
            if (closest != null && !(((BlockPos)closest.getKey()).func_177954_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v) > entry.getKey().func_177954_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v))) continue;
            closest = entry;
        }
        return closest;
    }

    public void setDefaultPlayerReputation(int defaultReputation) {
        for (UUID s : this.playerReputation.keySet()) {
            this.modifyPlayerReputation(s, defaultReputation);
        }
    }

    public boolean repopulate() {
        int roomCount = this.getAllRooms().size();
        return this.numMyrmex < Math.min(IceAndFireConfig.WORLDGEN.myrmexColonySize, roomCount * 9) && this.reproduces;
    }

    public void addMyrmex(EntityMyrmexBase myrmex) {
        if (!this.myrmexList.contains(myrmex.func_110124_au())) {
            this.myrmexList.add(myrmex.func_110124_au());
        }
    }

    public void removeRoom(BlockPos pos) {
        this.foodRooms.remove(pos);
        this.miscRooms.remove(pos);
        this.babyRooms.remove(pos);
        this.allRooms.remove(pos);
        this.getEntrances().remove(pos);
        this.getEntranceBottoms().remove(pos);
    }

    public String toString() {
        return "MyrmexHive(x=" + this.center.func_177958_n() + ",y=" + this.center.func_177956_o() + ",z=" + this.center.func_177952_p() + "), population=" + this.getNumMyrmex() + "\nUUID: " + this.hiveUUID;
    }

    public boolean equals(MyrmexHive hive) {
        return this.hiveUUID.equals(hive.hiveUUID);
    }

    class HiveAggressor {
        public EntityLivingBase agressor;
        public int agressionTime;
        public int agressionLevel;

        HiveAggressor(EntityLivingBase agressorIn, int agressionTimeIn, int agressionLevel) {
            this.agressor = agressorIn;
            this.agressionTime = agressionTimeIn;
            this.agressionLevel = agressionLevel;
        }
    }
}

