/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.api.IEntityEffectCapability;
import com.github.alexthe666.iceandfire.api.InFCapabilities;
import com.github.alexthe666.iceandfire.core.ModVillagers;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class EntitySnowVillager
extends EntityVillager {
    private static Field FIELD_BABY;
    private static Field FIELD_PROFESSION;
    private static Field FIELD_CAREER;
    private String professionName;
    private VillagerRegistry.VillagerProfession prof;

    public EntitySnowVillager(World worldIn) {
        super(worldIn);
    }

    public EntitySnowVillager(World worldIn, int profession) {
        super(worldIn, profession);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        IEntityEffectCapability capability = InFCapabilities.getEntityEffectCapability((EntityLivingBase)this);
        if (capability != null && capability.isStoned()) {
            return false;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70938_b(int professionId) {
        if (professionId > 2) {
            professionId = 2;
        }
        this.field_70180_af.func_187227_b(this.PROFESSION(), (Object)professionId);
    }

    private DataParameter<Boolean> BABY() {
        try {
            if (FIELD_BABY == null) {
                FIELD_BABY = ObfuscationReflectionHelper.findField(EntityAgeable.class, (String)"field_184751_bv");
                FIELD_BABY.setAccessible(true);
            }
            return (DataParameter)FIELD_BABY.get((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private DataParameter<Integer> PROFESSION() {
        try {
            if (FIELD_PROFESSION == null) {
                FIELD_PROFESSION = ObfuscationReflectionHelper.findField(EntityVillager.class, (String)"field_184752_bw");
                FIELD_PROFESSION.setAccessible(true);
            }
            return (DataParameter)FIELD_PROFESSION.get((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (field_184621_as.equals(key) && this.field_70170_p.field_72995_K) {
            if (this.func_184587_cr() && this.field_184627_bm.func_190926_b()) {
                this.field_184627_bm = this.func_184586_b(this.func_184600_cs());
                if (!this.field_184627_bm.func_190926_b()) {
                    this.field_184628_bn = this.field_184627_bm.func_77988_m();
                }
            } else if (!this.func_184587_cr() && !this.field_184627_bm.func_190926_b()) {
                this.field_184627_bm = ItemStack.field_190927_a;
                this.field_184628_bn = 0;
            }
        }
        if (this.BABY().equals(key)) {
            this.func_98054_a(this.func_70631_g_());
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (cause.func_76346_g() == null || !(cause.func_76346_g() instanceof EntityZombie) || this.field_70170_p.func_175659_aa() != EnumDifficulty.NORMAL && this.field_70170_p.func_175659_aa() != EnumDifficulty.HARD) {
            super.func_70645_a(cause);
        }
    }

    public void setProfession(VillagerRegistry.VillagerProfession prof) {
        if (ModVillagers.INSTANCE.professions.containsValue(prof)) {
            this.func_70938_b(VillagerRegistry.getId((VillagerRegistry.VillagerProfession)prof));
        } else {
            ModVillagers.INSTANCE.setRandomProfession(this, this.field_70170_p.field_73012_v);
        }
    }

    public EntityVillager func_90011_a(EntityAgeable ageable) {
        EntitySnowVillager entityvillager = new EntitySnowVillager(this.field_70170_p);
        entityvillager.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityvillager)), null);
        return entityvillager;
    }

    public VillagerRegistry.VillagerProfession getProfessionForge() {
        if (this.prof == null) {
            String p = this.getEntityData().func_74779_i("ProfessionName");
            this.prof = p.isEmpty() ? ModVillagers.INSTANCE.professions.get(this.func_70681_au().nextInt(3)) : ModVillagers.INSTANCE.professions.get(this.intFromProfesion(p));
            try {
                if (FIELD_CAREER == null) {
                    FIELD_CAREER = ObfuscationReflectionHelper.findField(EntityVillager.class, (String)"field_175563_bv");
                    FIELD_CAREER.setAccessible(true);
                }
                FIELD_CAREER.set((Object)this, 1);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return this.prof;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_70938_b(compound.func_74762_e("Profession"));
        if (compound.func_74764_b("ProfessionName")) {
            VillagerRegistry.VillagerProfession p = ModVillagers.INSTANCE.professions.get(this.intFromProfesion(compound.func_74779_i("ProfessionName")));
            if (p == null) {
                p = ModVillagers.INSTANCE.professions.get(0);
            }
            this.setProfession(p);
        }
    }

    public IEntityLivingData func_190672_a(DifficultyInstance difficulty, @Nullable IEntityLivingData data, boolean forgeCheck) {
        this.prof = ModVillagers.INSTANCE.professions.get(this.func_70681_au().nextInt(3));
        return data;
    }

    private int intFromProfesion(String prof) {
        if (prof.contains("fisherman")) {
            return 0;
        }
        if (prof.contains("craftsman")) {
            return 1;
        }
        if (prof.contains("shaman")) {
            return 2;
        }
        return 0;
    }

    protected boolean func_70692_ba() {
        return false;
    }
}

