/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.api.IEntityEffectCapability;
import com.github.alexthe666.iceandfire.api.InFCapabilities;
import com.github.alexthe666.iceandfire.core.ModItems;
import com.github.alexthe666.iceandfire.core.ModVillagers;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexEgg;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIAttackPlayers;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIDefendHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIForage;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIForageForItems;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAILeaveHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAILookAtTradePlayer;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIMoveThroughHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIPickupBabies;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIReEnterHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIStoreBabies;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIStoreItems;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAITradePlayer;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIWander;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.item.ItemMyrmexEgg;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class EntityMyrmexWorker
extends EntityMyrmexBase {
    private static final ResourceLocation TEXTURE_DESERT = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_desert_worker.png");
    private static final ResourceLocation TEXTURE_JUNGLE = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_jungle_worker.png");
    public boolean keepSearching = true;
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_STING = Animation.create((int)15);
    public static final ResourceLocation DESERT_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "myrmex_worker_desert"));
    public static final ResourceLocation JUNGLE_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "myrmex_worker_jungle"));

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.isJungle() ? JUNGLE_LOOT : DESERT_LOOT;
    }

    public EntityMyrmexWorker(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 0.6f);
    }

    @Override
    protected int func_70693_a(EntityPlayer player) {
        return 3;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.getAnimation() == ANIMATION_BITE && this.func_70638_az() != null && this.getAnimationTick() == 6) {
            this.playBiteSound();
            if (this.getAttackBounds().func_72326_a(this.func_70638_az().func_174813_aQ())) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
            }
        }
        if (this.getAnimation() == ANIMATION_STING && this.getAnimationTick() == 0) {
            this.playStingSound();
        }
        if (this.getAnimation() == ANIMATION_STING && this.func_70638_az() != null && this.getAnimationTick() == 6 && this.getAttackBounds().func_72326_a(this.func_70638_az().func_174813_aQ())) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 2));
            this.func_70638_az().func_70690_d(new PotionEffect(MobEffects.field_76436_u, 60, 1));
        }
        if (!this.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && this.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemMyrmexEgg) {
            boolean isJungle = this.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == ModItems.myrmex_jungle_egg;
            int metadata = this.func_184586_b(EnumHand.MAIN_HAND).func_77960_j();
            EntityMyrmexEgg egg = new EntityMyrmexEgg(this.field_70170_p);
            egg.func_82149_j((Entity)this);
            egg.setJungle(isJungle);
            egg.setMyrmexCaste(metadata);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)egg);
            }
            egg.func_184220_m((Entity)this);
            this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        }
        if (!this.func_184188_bt().isEmpty()) {
            for (Entity entity : this.func_184188_bt()) {
                if (!(entity instanceof EntityMyrmexBase) || ((EntityMyrmexBase)entity).getGrowthStage() < 2) continue;
                entity.func_184210_p();
            }
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new MyrmexAITradePlayer(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new MyrmexAILookAtTradePlayer(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new MyrmexAIStoreBabies(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new MyrmexAIStoreItems(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new MyrmexAIReEnterHive(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new MyrmexAILeaveHive(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new MyrmexAIForage(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new MyrmexAIMoveThroughHive(this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new MyrmexAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new MyrmexAIDefendHive(this));
        this.field_70715_bh.func_75776_a(2, new MyrmexAIForageForItems(this));
        this.field_70715_bh.func_75776_a(3, new MyrmexAIPickupBabies(this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new MyrmexAIAttackPlayers(this));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, true, true, (Predicate)new Predicate<EntityLiving>(){

            public boolean apply(@Nullable EntityLiving entity) {
                return entity != null && !IMob.field_175450_e.apply((Object)entity) && !EntityMyrmexBase.haveSameHive(EntityMyrmexWorker.this, (Entity)entity) && DragonUtils.isAlive((EntityLivingBase)entity);
            }
        }));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    @Override
    public ResourceLocation getAdultTexture() {
        return this.isJungle() ? TEXTURE_JUNGLE : TEXTURE_DESERT;
    }

    @Override
    public float getModelScale() {
        return 0.6f;
    }

    @Override
    public boolean shouldLeaveHive() {
        return !this.holdingSomething();
    }

    @Override
    public boolean shouldEnterHive() {
        return this.holdingSomething();
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getGrowthStage() < 2) {
            return false;
        }
        if (this.getAnimation() != ANIMATION_STING && this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(this.func_70681_au().nextBoolean() ? ANIMATION_STING : ANIMATION_BITE);
            if (!this.field_70170_p.field_72995_K && this.func_70681_au().nextInt(3) == 0 && this.func_184586_b(EnumHand.MAIN_HAND) != ItemStack.field_190927_a) {
                this.func_70099_a(this.func_184586_b(EnumHand.MAIN_HAND), 0.0f);
                this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            }
            if (!this.func_184188_bt().isEmpty()) {
                for (Entity entity : this.func_184188_bt()) {
                    entity.func_184210_p();
                }
            }
            return true;
        }
        return false;
    }

    private boolean holdingSomething() {
        return this.getHeldEntity() != null || !this.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() || this.func_70638_az() != null;
    }

    public boolean holdingBaby() {
        return this.getHeldEntity() != null && (this.getHeldEntity() instanceof EntityMyrmexBase || this.getHeldEntity() instanceof EntityMyrmexEgg);
    }

    @Override
    public int getCasteImportance() {
        return 0;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PUPA_WIGGLE, ANIMATION_BITE, ANIMATION_STING};
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            this.field_70761_aq = this.field_70177_z;
            float radius = 1.05f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            passenger.func_70107_b(this.field_70165_t + extraX, this.field_70163_u + 0.25, this.field_70161_v + extraZ);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        IEntityEffectCapability capability = InFCapabilities.getEntityEffectCapability((EntityLivingBase)this);
        if ((double)amount >= 1.0 && !this.field_70170_p.field_72995_K && this.func_70681_au().nextInt(3) == 0 && this.func_184586_b(EnumHand.MAIN_HAND) != ItemStack.field_190927_a && capability != null && !capability.isStoned()) {
            this.func_70099_a(this.func_184586_b(EnumHand.MAIN_HAND), 0.0f);
            this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        }
        if ((double)amount >= 1.0 && !this.func_184188_bt().isEmpty()) {
            for (Entity entity : this.func_184188_bt()) {
                entity.func_184210_p();
            }
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public VillagerRegistry.VillagerProfession getProfessionForge() {
        return this.isJungle() ? ModVillagers.INSTANCE.jungleMyrmexWorker : ModVillagers.INSTANCE.desertMyrmexWorker;
    }

    public Entity getHeldEntity() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public void onPickupItem(EntityItem itemEntity) {
        Item item = itemEntity.func_92059_d().func_77973_b();
        if (item == ModItems.myrmex_jungle_resin && this.isJungle() || item == ModItems.myrmex_desert_resin && !this.isJungle()) {
            EntityPlayer owner = null;
            try {
                owner = this.field_70170_p.func_72924_a(itemEntity.func_145800_j());
            }
            catch (Exception e) {
                IceAndFire.logger.warn("Myrmex picked up resin that wasn't thrown!");
            }
            if (owner != null && this.getHive() != null) {
                this.getHive().modifyPlayerReputation(owner.func_110124_au(), 5);
                this.func_184185_a(SoundEvents.field_187886_fs, 1.0f, 1.0f);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, owner.field_70165_t, owner.field_70163_u, owner.field_70161_v, 1 + this.field_70146_Z.nextInt(3)));
                }
            }
        }
    }
}

