/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.core.ModSounds;
import com.github.alexthe666.iceandfire.entity.ai.DreadAITargetNonDread;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.EntityDreadMob;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.IDreadMob;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityDreadGhoul
extends EntityDreadMob
implements IAnimatedEntity,
IVillagerFear,
IAnimalFear {
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "dread_ghoul"));
    private static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(EntityDreadGhoul.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityDreadGhoul.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SCREAMS = EntityDataManager.func_187226_a(EntityDreadGhoul.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final float INITIAL_WIDTH = 0.6f;
    private static final float INITIAL_HEIGHT = 1.8f;
    public static Animation ANIMATION_SPAWN = Animation.create((int)40);
    public static Animation ANIMATION_SLASH = Animation.create((int)25);
    private int animationTick;
    private Animation currentAnimation;
    private int hostileTicks = 0;
    private float firstWidth = 1.0f;
    private float firstHeight = 1.0f;

    public EntityDreadGhoul(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.8f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{IDreadMob.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new DreadAITargetNonDread((EntityCreature)this, EntityLivingBase.class, false, (Predicate<? super EntityLivingBase>)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity instanceof EntityLivingBase && DragonUtils.canHostilesTarget(entity);
            }
        }));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(SCREAMS, (Object)0);
        this.field_70180_af.func_187214_a(SCALE, (Object)Float.valueOf(1.0f));
    }

    public float getScale() {
        return ((Float)this.field_70180_af.func_187225_a(SCALE)).floatValue();
    }

    public void setScale(float scale) {
        this.field_70180_af.func_187227_b(SCALE, (Object)Float.valueOf(Math.min(Math.max(scale, 0.75f), 2.0f)));
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SLASH);
        }
        return true;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (Math.abs(this.firstWidth - 0.6f * this.getScale()) > 0.01f || Math.abs(this.firstHeight - 1.8f * this.getScale()) > 0.01f) {
            this.firstWidth = 0.6f * this.getScale();
            this.firstHeight = 1.8f * this.getScale();
            this.func_70105_a(this.firstWidth, this.firstHeight);
        }
        if (this.getAnimation() == ANIMATION_SPAWN && this.getAnimationTick() < 30) {
            Block belowBlock = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c();
            if (belowBlock != Blocks.field_150350_a) {
                for (int i = 0; i < 5; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.func_174813_aQ().field_72338_b, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[]{Block.func_149682_b((Block)belowBlock)});
                }
            }
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
        }
        if (this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) < 4.0f && this.func_70685_l((Entity)this.func_70638_az())) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_SLASH);
            }
            this.func_70625_a((Entity)this.func_70638_az(), 360.0f, 80.0f);
            if (this.getAnimation() == ANIMATION_SLASH && (this.getAnimationTick() == 9 || this.getAnimationTick() == 19)) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                this.func_70638_az().func_70653_a((Entity)this.func_70638_az(), 0.25f, this.field_70165_t - this.func_70638_az().field_70165_t, this.field_70161_v - this.func_70638_az().field_70161_v);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() != null) {
                ++this.hostileTicks;
                if (this.getScreamStage() == 0) {
                    if (this.hostileTicks > 20) {
                        this.setScreamStage(1);
                    }
                } else if (this.field_70173_aa % 20 < 10) {
                    this.setScreamStage(1);
                } else {
                    this.setScreamStage(2);
                }
            } else {
                if (this.getScreamStage() > 0) {
                    if (this.field_70173_aa % 20 < 10 && this.getScreamStage() == 2) {
                        this.setScreamStage(1);
                    } else {
                        this.setScreamStage(0);
                    }
                }
                this.hostileTicks = 0;
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74768_a("ScreamStage", this.getScreamStage());
        compound.func_74776_a("Scale", this.getScale());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.setScreamStage(compound.func_74762_e("ScreamStage"));
        this.setScale(compound.func_74760_g("Scale"));
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public int getScreamStage() {
        return (Integer)this.field_70180_af.func_187225_a(SCREAMS);
    }

    public void setScreamStage(int screamStage) {
        this.field_70180_af.func_187227_b(SCREAMS, (Object)screamStage);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData data = super.func_180482_a(difficulty, livingdata);
        this.setAnimation(ANIMATION_SPAWN);
        this.setVariant(this.field_70146_Z.nextInt(3));
        return data;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SPAWN, ANIMATION_SLASH};
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return ModSounds.DREAD_GHOUL_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187934_hh;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187930_hd;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187939_hm, 0.15f, 1.0f);
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.7f;
    }
}

