/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFireConfig;
import com.github.alexthe666.iceandfire.api.FoodUtils;
import com.github.alexthe666.iceandfire.core.ModSounds;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.IBlacklistedFromStatues;
import com.github.alexthe666.iceandfire.entity.ai.CockatriceAIAggroLook;
import com.github.alexthe666.iceandfire.entity.ai.CockatriceAIFollowOwner;
import com.github.alexthe666.iceandfire.entity.ai.CockatriceAIStareAttack;
import com.github.alexthe666.iceandfire.entity.ai.CockatriceAITarget;
import com.github.alexthe666.iceandfire.entity.ai.CockatriceAITargetItems;
import com.github.alexthe666.iceandfire.entity.ai.CockatriceAIWander;
import com.github.alexthe666.iceandfire.entity.ai.EntityAIAttackMeleeNoCooldown;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.event.EventLiving;
import com.github.alexthe666.iceandfire.util.ParticleHelper;
import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCockatrice
extends EntityTameable
implements IAnimatedEntity,
IBlacklistedFromStatues,
IVillagerFear {
    private int animationTick;
    private Animation currentAnimation;
    private static final DataParameter<Boolean> HEN = EntityDataManager.func_187226_a(EntityCockatrice.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> STARING = EntityDataManager.func_187226_a(EntityCockatrice.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TARGET_ENTITY = EntityDataManager.func_187226_a(EntityCockatrice.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TAMING_PLAYER = EntityDataManager.func_187226_a(EntityCockatrice.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TAMING_LEVEL = EntityDataManager.func_187226_a(EntityCockatrice.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> COMMAND = EntityDataManager.func_187226_a(EntityCockatrice.class, (DataSerializer)DataSerializers.field_187192_b);
    private boolean isSitting;
    public float sitProgress;
    private boolean isStaring;
    public float stareProgress;
    public int ticksStaring = 0;
    public static final Animation ANIMATION_JUMPAT = Animation.create((int)30);
    public static final Animation ANIMATION_WATTLESHAKE = Animation.create((int)20);
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)10);
    public static final Animation ANIMATION_EAT = Animation.create((int)20);
    private CockatriceAIStareAttack aiStare;
    private EntityAIAttackMelee aiMelee;
    private boolean isMeleeMode = false;
    private EntityLivingBase targetedEntity;
    private int clientSideAttackTime;
    public static final float VIEW_RADIUS = 0.6f;
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "cockatrice"));

    public EntityCockatrice(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.95f, 0.95f);
    }

    protected int func_70693_a(EntityPlayer player) {
        return 10;
    }

    public boolean func_70601_bi() {
        return this.func_70681_au().nextInt(IceAndFireConfig.ENTITY_SPAWNING.cockatriceSpawnCheckChance + 1) == 0 && super.func_70601_bi();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.aiStare = new CockatriceAIStareAttack(this, 1.0, 0, 15.0f);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiStare);
        this.aiMelee = new EntityAIAttackMeleeNoCooldown((EntityCreature)this, 1.5, false);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiMelee);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new CockatriceAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new CockatriceAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new CockatriceAIAggroLook(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, new CockatriceAITargetItems(this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(5, new CockatriceAITarget<Entity>(this, EntityLivingBase.class, true, new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return (entity instanceof IMob && EntityCockatrice.this.func_70909_n() && !(entity instanceof EntityCreeper) && !(entity instanceof EntityPigZombie) && !(entity instanceof EntityEnderman) || entity instanceof EntityPlayer || EventLiving.isAnimaniaFerret(entity)) && !EventLiving.isAnimaniaChicken(entity);
            }
        }));
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiMelee);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    public boolean func_184191_r(Entity entityIn) {
        return EventLiving.isAnimaniaChicken(entityIn) || super.func_184191_r(entityIn);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_76346_g() != null && EventLiving.isAnimaniaFerret(source.func_76346_g())) {
            damage *= 5.0f;
        }
        if (source == DamageSource.field_76368_d) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    private boolean canUseStareOn(Entity entity) {
        return (!(entity instanceof IBlacklistedFromStatues) || ((IBlacklistedFromStatues)entity).canBeTurnedToStone()) && !EventLiving.isAnimaniaFerret(entity);
    }

    private void switchAI(boolean melee) {
        if (melee) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiStare);
            if (this.aiMelee != null) {
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiMelee);
            }
            this.isMeleeMode = true;
        } else {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiMelee);
            if (this.aiStare != null) {
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiStare);
            }
            this.isMeleeMode = false;
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.isStaring()) {
            return false;
        }
        if (this.func_70681_au().nextBoolean()) {
            if (this.getAnimation() != ANIMATION_JUMPAT && this.getAnimation() != ANIMATION_BITE) {
                this.setAnimation(ANIMATION_JUMPAT);
            }
            return false;
        }
        if (this.getAnimation() != ANIMATION_BITE && this.getAnimation() != ANIMATION_JUMPAT) {
            this.setAnimation(ANIMATION_BITE);
        }
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
    }

    public boolean canMove() {
        return !this.func_70906_o() && (this.getAnimation() != ANIMATION_JUMPAT || this.getAnimationTick() >= 7);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HEN, (Object)false);
        this.field_70180_af.func_187214_a(STARING, (Object)false);
        this.field_70180_af.func_187214_a(TARGET_ENTITY, (Object)0);
        this.field_70180_af.func_187214_a(TAMING_PLAYER, (Object)0);
        this.field_70180_af.func_187214_a(TAMING_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(COMMAND, (Object)0);
    }

    public void setTargetedEntity(int entityId) {
        this.field_70180_af.func_187227_b(TARGET_ENTITY, (Object)entityId);
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY) != 0;
    }

    public void setTamingPlayer(int entityId) {
        this.field_70180_af.func_187227_b(TAMING_PLAYER, (Object)entityId);
    }

    public boolean hasTamingPlayer() {
        return (Integer)this.field_70180_af.func_187225_a(TAMING_PLAYER) != 0;
    }

    @Nullable
    public Entity getTamingPlayer() {
        if (!this.hasTamingPlayer()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TAMING_PLAYER)).intValue());
            if (entity instanceof EntityLivingBase) {
                this.targetedEntity = (EntityLivingBase)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TAMING_PLAYER)).intValue());
    }

    @Nullable
    public EntityLivingBase getTargetedEntity() {
        boolean blindness;
        boolean bl = blindness = this.func_70644_a(MobEffects.field_76440_q) || this.func_70638_az() != null && this.func_70638_az().func_70644_a(MobEffects.field_76440_q) || this.func_70638_az() != null && EntityGorgon.isBlindfolded(this.func_70638_az());
        if (blindness) {
            return null;
        }
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY)).intValue());
            if (entity instanceof EntityLivingBase) {
                this.targetedEntity = (EntityLivingBase)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (TARGET_ENTITY.equals(key)) {
            this.clientSideAttackTime = 0;
            this.targetedEntity = null;
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a("Hen", this.isHen());
        tag.func_74757_a("Staring", this.isStaring());
        tag.func_74768_a("TamingLevel", this.getTamingLevel());
        tag.func_74768_a("TamingPlayer", ((Integer)this.field_70180_af.func_187225_a(TAMING_PLAYER)).intValue());
        tag.func_74768_a("Command", this.getCommand());
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.setHen(tag.func_74767_n("Hen"));
        this.setStaring(tag.func_74767_n("Staring"));
        this.setTamingLevel(tag.func_74762_e("TamingLevel"));
        this.setTamingPlayer(tag.func_74762_e("TamingPlayer"));
        this.setCommand(tag.func_74762_e("Command"));
    }

    public boolean func_70906_o() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSitting;
            this.isSitting = isSitting = ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 1) != 0;
            return isSitting;
        }
        return this.isSitting;
    }

    public void func_70904_g(boolean sitting) {
        super.func_70904_g(sitting);
        if (!this.field_70170_p.field_72995_K) {
            this.isSitting = sitting;
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setHen(this.func_70681_au().nextBoolean());
        return livingdata;
    }

    public void setHen(boolean hen) {
        this.field_70180_af.func_187227_b(HEN, (Object)hen);
    }

    public boolean isHen() {
        return (Boolean)this.field_70180_af.func_187225_a(HEN);
    }

    public void setTamingLevel(int level) {
        this.field_70180_af.func_187227_b(TAMING_LEVEL, (Object)level);
    }

    public int getTamingLevel() {
        return (Integer)this.field_70180_af.func_187225_a(TAMING_LEVEL);
    }

    public void setCommand(int command) {
        this.field_70180_af.func_187227_b(COMMAND, (Object)command);
        this.func_70904_g(command == 1);
    }

    public int getCommand() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND);
    }

    public boolean isStaring() {
        if (this.field_70170_p.field_72995_K) {
            this.isStaring = (Boolean)this.field_70180_af.func_187225_a(STARING);
            return this.isStaring;
        }
        return this.isStaring;
    }

    public void setStaring(boolean staring) {
        this.field_70180_af.func_187227_b(STARING, (Object)staring);
        if (!this.field_70170_p.field_72995_K) {
            this.isStaring = staring;
        }
    }

    public void forcePreyToLook(EntityLiving mob) {
        mob.func_70671_ap().func_75650_a(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, (float)mob.func_184649_cE(), (float)mob.func_70646_bf());
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean flag;
        boolean bl = flag = player.func_184586_b(hand).func_77973_b() == Items.field_151057_cb || player.func_184586_b(hand).func_77973_b() == Items.field_151058_ca;
        if (flag) {
            player.func_184586_b(hand).func_111282_a(player, (EntityLivingBase)this, hand);
            return true;
        }
        if (player.func_184586_b(hand).func_77973_b() == Items.field_151170_bI) {
            return super.func_184645_a(player, hand);
        }
        if (this.func_70909_n() && this.func_152114_e((EntityLivingBase)player)) {
            if (FoodUtils.isSeeds(player.func_184586_b(hand)) || player.func_184586_b(hand).func_77973_b() == Items.field_151078_bh) {
                if (this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_70691_i(8.0f);
                    this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                    player.func_184586_b(hand).func_190918_g(1);
                }
                return true;
            }
            if (player.func_184586_b(hand).func_190926_b()) {
                this.setCommand(this.getCommand() + 1);
                if (this.getCommand() > 2) {
                    this.setCommand(0);
                }
                player.func_146105_b((ITextComponent)new TextComponentTranslation("cockatrice.command." + this.getCommand(), new Object[0]), true);
                this.func_184185_a(SoundEvents.field_187945_hs, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    public void func_70636_d() {
        boolean blindness;
        boolean sitting;
        double dist;
        super.func_70636_d();
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && this.func_70638_az() != null && this.func_70638_az() instanceof EntityPlayer) {
            this.func_70624_b(null);
        }
        if (this.func_70906_o() && this.getCommand() != 1) {
            this.func_70904_g(false);
        }
        if (this.func_70906_o() && this.func_70638_az() != null) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() != null && this.func_184191_r((Entity)this.func_70638_az())) {
            this.func_70624_b(null);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() == null || this.func_70638_az().field_70128_L) {
                this.setTargetedEntity(0);
            } else if (this.isStaring() || this.shouldStareAttack((Entity)this.func_70638_az())) {
                this.setTargetedEntity(this.func_70638_az().func_145782_y());
            }
        }
        if (this.getAnimation() == ANIMATION_BITE && this.func_70638_az() != null && this.getAnimationTick() == 7 && (dist = this.func_70068_e((Entity)this.func_70638_az())) < 8.0) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        }
        if (this.getAnimation() == ANIMATION_JUMPAT && this.func_70638_az() != null) {
            dist = this.func_70068_e((Entity)this.func_70638_az());
            double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
            float leap = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
            if (dist <= 16.0 && this.field_70122_E && this.getAnimationTick() > 7 && this.getAnimationTick() < 12) {
                if ((double)leap >= 1.0E-4) {
                    this.field_70159_w += d0 / (double)leap * (double)0.8f + this.field_70159_w * (double)0.2f;
                    this.field_70179_y += d1 / (double)leap * (double)0.8f + this.field_70179_y * (double)0.2f;
                }
                this.field_70181_x = 0.5;
            }
            if (dist < 4.0 && this.getAnimationTick() > 10) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
                if ((double)leap >= 1.0E-4) {
                    this.func_70638_az().field_70159_w += d0 / (double)leap * (double)0.8f + this.field_70159_w * (double)0.2f;
                    this.func_70638_az().field_70179_y += d1 / (double)leap * (double)0.8f + this.field_70179_y * (double)0.2f;
                }
            }
        }
        if ((sitting = this.func_70906_o()) && this.sitProgress < 20.0f) {
            this.sitProgress += 0.5f;
        } else if (!sitting && this.sitProgress > 0.0f) {
            this.sitProgress -= 0.5f;
        }
        boolean staring = this.isStaring();
        if (staring && this.stareProgress < 20.0f) {
            this.stareProgress += 0.5f;
        } else if (!staring && this.stareProgress > 0.0f) {
            this.stareProgress -= 0.5f;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.ticksStaring = staring ? ++this.ticksStaring : 0;
        }
        if (!this.field_70170_p.field_72995_K && staring && (this.func_70638_az() == null || this.shouldMelee())) {
            this.setStaring(false);
        }
        if (this.func_70638_az() != null) {
            this.func_70671_ap().func_75650_a(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u + (double)this.func_70638_az().func_70047_e(), this.func_70638_az().field_70161_v, (float)this.func_184649_cE(), (float)this.func_70646_bf());
            if (!this.shouldMelee() && this.func_70638_az() instanceof EntityLiving && !(this.func_70638_az() instanceof EntityPlayer)) {
                this.forcePreyToLook((EntityLiving)this.func_70638_az());
            }
        }
        boolean bl = blindness = this.func_70644_a(MobEffects.field_76440_q) || this.func_70638_az() != null && this.func_70638_az().func_70644_a(MobEffects.field_76440_q) || this.func_70638_az() != null && EntityGorgon.isBlindfolded(this.func_70638_az());
        if (blindness) {
            this.setStaring(false);
        }
        if (!this.field_70170_p.field_72995_K && !blindness && this.func_70638_az() != null && EntityGorgon.isEntityLookingAt((EntityLivingBase)this, this.func_70638_az(), 0.6f) && EntityGorgon.isEntityLookingAt(this.func_70638_az(), (EntityLivingBase)this, 0.6f) && !this.shouldMelee()) {
            if (!this.isStaring()) {
                this.setStaring(true);
            } else {
                int attackStrength = this.getFriendsCount(this.func_70638_az());
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    ++attackStrength;
                }
                this.func_70638_az().func_70690_d(new PotionEffect(MobEffects.field_82731_v, 10, 2 + Math.min(1, attackStrength)));
                this.func_70638_az().func_70690_d(new PotionEffect(MobEffects.field_76421_d, 10, Math.min(4, attackStrength)));
                this.func_70638_az().func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 0));
                if (attackStrength >= 2 && this.func_70638_az().field_70173_aa % 40 == 0) {
                    this.func_70638_az().func_70097_a(DamageSource.field_82727_n, (float)(attackStrength - 1));
                }
                this.func_70638_az().func_70604_c((EntityLivingBase)this);
                if (!this.func_70909_n() && this.func_70638_az() instanceof EntityPlayer) {
                    this.setTamingPlayer(this.func_70638_az().func_145782_y());
                    this.setTamingLevel(this.getTamingLevel() + 1);
                    if (this.getTamingLevel() % 100 == 0) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)46);
                    }
                    if (this.getTamingLevel() >= 1000) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)45);
                        if (this.getTamingPlayer() != null && this.getTamingPlayer() instanceof EntityPlayer) {
                            this.func_193101_c((EntityPlayer)this.getTamingPlayer());
                        }
                        this.func_70624_b(null);
                        this.setTamingPlayer(0);
                        this.setTargetedEntity(0);
                    }
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.func_70681_au().nextInt(300) == 0 && this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_WATTLESHAKE);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.shouldMelee() && !this.isMeleeMode) {
                this.switchAI(true);
            }
            if (!this.shouldMelee() && this.isMeleeMode) {
                this.switchAI(false);
            }
        }
        if (this.field_70170_p.field_72995_K && this.getTargetedEntity() != null && EntityGorgon.isEntityLookingAt((EntityLivingBase)this, this.getTargetedEntity(), 0.6f) && EntityGorgon.isEntityLookingAt(this.getTargetedEntity(), (EntityLivingBase)this, 0.6f) && this.isStaring() && this.hasTargetedEntity()) {
            EntityLivingBase entitylivingbase;
            if (this.clientSideAttackTime < this.getAttackDuration()) {
                ++this.clientSideAttackTime;
            }
            if ((entitylivingbase = this.getTargetedEntity()) != null) {
                this.func_70671_ap().func_75651_a((Entity)entitylivingbase, 90.0f, 90.0f);
                this.func_70671_ap().func_75649_a();
                double d5 = this.getAttackAnimationScale(0.0f);
                double d0 = entitylivingbase.field_70165_t - this.field_70165_t;
                double d1 = entitylivingbase.field_70163_u + (double)(entitylivingbase.field_70131_O * 0.5f) - (this.field_70163_u + (double)this.func_70047_e());
                double d2 = entitylivingbase.field_70161_v - this.field_70161_v;
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d0 /= d3;
                d1 /= d3;
                d2 /= d3;
                double d4 = this.field_70146_Z.nextDouble();
                while (d4 < d3) {
                    ParticleHelper.spawnParticle(this.field_70170_p, EnumParticleTypes.SPELL_MOB, this.field_70165_t + d0 * (d4 += 1.8 - d5 + this.field_70146_Z.nextDouble() * (1.7 - d5)), this.field_70163_u + d1 * d4 + (double)this.func_70047_e(), this.field_70161_v + d2 * d4, 0.20784313725490197, 0.16470588235294117, 0.15294117647058825, new int[0]);
                }
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    private int getFriendsCount(EntityLivingBase attackTarget) {
        if (this.func_70638_az() == null) {
            return 0;
        }
        float dist = IceAndFireConfig.ENTITY_SETTINGS.cockatriceChickenSearchLength;
        List list = this.field_70170_p.func_72872_a(EntityCockatrice.class, this.func_174813_aQ().func_72321_a((double)dist, (double)dist, (double)dist));
        int i = 0;
        for (EntityCockatrice cockatrice : list) {
            boolean bothLooking;
            if (cockatrice.func_70028_i((Entity)this) || cockatrice.func_70638_az() == null || cockatrice.func_70638_az() != this.func_70638_az() || !(bothLooking = EntityGorgon.isEntityLookingAt((EntityLivingBase)cockatrice, cockatrice.func_70638_az(), 0.6f) && EntityGorgon.isEntityLookingAt(cockatrice.func_70638_az(), (EntityLivingBase)cockatrice, 0.6f))) continue;
            ++i;
        }
        return i;
    }

    public float getAttackAnimationScale(float f) {
        return ((float)this.clientSideAttackTime + f) / (float)this.getAttackDuration();
    }

    public boolean shouldStareAttack(Entity entity) {
        return this.func_70032_d(entity) > 5.0f;
    }

    public int getAttackDuration() {
        return 80;
    }

    private boolean shouldMelee() {
        boolean blindness;
        boolean bl = blindness = this.func_70644_a(MobEffects.field_76440_q) || this.func_70638_az() != null && this.func_70638_az().func_70644_a(MobEffects.field_76440_q);
        if (this.func_70638_az() != null) {
            return (double)this.func_70032_d((Entity)this.func_70638_az()) < 4.0 || EventLiving.isAnimaniaFerret((Entity)this.func_70638_az()) || blindness || !this.canUseStareOn((Entity)this.func_70638_az());
        }
        return false;
    }

    public void func_191986_a(float strafe, float forward, float vertical) {
        if (!this.canMove() && !this.func_184207_aI()) {
            strafe = 0.0f;
            forward = 0.0f;
        }
        super.func_191986_a(strafe, forward, vertical);
    }

    public void func_70642_aH() {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_70642_aH();
    }

    protected void func_184581_c(DamageSource source) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_184581_c(source);
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_72314_b(1.5, 0.5, 1.5);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_JUMPAT, ANIMATION_WATTLESHAKE, ANIMATION_BITE, ANIMATION_SPEAK, ANIMATION_EAT};
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    public boolean isTargetBlocked(Vec3d target) {
        BlockPos pos;
        RayTraceResult rayTrace;
        return target != null && (rayTrace = this.field_70170_p.func_72901_a(new Vec3d((Vec3i)this.func_180425_c()), target, false)) != null && rayTrace.field_72307_f != null && !this.field_70170_p.func_175623_d(pos = new BlockPos(rayTrace.field_72307_f));
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return ModSounds.COCKATRICE_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.COCKATRICE_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return ModSounds.COCKATRICE_DIE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 45) {
            this.playEffect(true);
        } else if (id == 46) {
            this.playEffect(false);
        } else {
            super.func_70103_a(id);
        }
    }

    protected void playEffect(boolean play) {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
        if (!play) {
            enumparticletypes = EnumParticleTypes.DAMAGE_INDICATOR;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            ParticleHelper.spawnParticle(this.field_70170_p, enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }
}

