/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.tile;

import com.github.alexthe666.iceandfire.client.model.ModelDragonEgg;
import com.github.alexthe666.iceandfire.client.render.entity.RenderDragonEgg;
import com.github.alexthe666.iceandfire.client.render.entity.RenderMyrmexEgg;
import com.github.alexthe666.iceandfire.core.ModItems;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityPodium;
import com.github.alexthe666.iceandfire.enums.EnumDragonEgg;
import com.github.alexthe666.iceandfire.item.ItemDragonEgg;
import com.github.alexthe666.iceandfire.item.ItemMyrmexEgg;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class RenderPodium
extends TileEntitySpecialRenderer<TileEntityPodium> {
    public static final ModelDragonEgg MODEL = new ModelDragonEgg();

    public void render(TileEntityPodium te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Item item;
        ItemStack stack = te.func_70301_a(0);
        if (!stack.func_190926_b() && ((item = stack.func_77973_b()) instanceof ItemDragonEgg || item instanceof ItemMyrmexEgg)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.475), (double)(z + 0.5));
            if (item instanceof ItemDragonEgg) {
                this.func_147499_a(RenderPodium.getEggTexture(((ItemDragonEgg)item).type));
            } else if (item instanceof ItemMyrmexEgg) {
                this.func_147499_a(item == ModItems.myrmex_jungle_egg ? RenderMyrmexEgg.EGG_JUNGLE : RenderMyrmexEgg.EGG_DESERT);
            }
            MODEL.renderPodium();
            GlStateManager.func_179121_F();
        } else {
            GlStateManager.func_179094_E();
            float ageInTicks = (float)te.ticksExisted + partialTicks;
            float yOffset = MathHelper.func_76126_a((float)(ageInTicks / 10.0f)) * 0.1f + 0.1f;
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.55 + (double)yOffset), (double)(z + 0.5));
            float rotation = (float)Math.toDegrees(ageInTicks / 20.0f);
            GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_175597_ag().func_178099_a((EntityLivingBase)mc.field_71439_g, stack, ItemCameraTransforms.TransformType.GROUND);
            GlStateManager.func_179121_F();
        }
    }

    public static ResourceLocation getEggTexture(EnumDragonEgg type) {
        switch (type) {
            default: {
                return RenderDragonEgg.EGG_RED;
            }
            case GREEN: {
                return RenderDragonEgg.EGG_GREEN;
            }
            case BRONZE: {
                return RenderDragonEgg.EGG_BRONZE;
            }
            case GRAY: {
                return RenderDragonEgg.EGG_GREY;
            }
            case BLUE: {
                return RenderDragonEgg.EGG_BLUE;
            }
            case WHITE: {
                return RenderDragonEgg.EGG_WHITE;
            }
            case SAPPHIRE: {
                return RenderDragonEgg.EGG_SAPPHIRE;
            }
            case SILVER: {
                return RenderDragonEgg.EGG_SILVER;
            }
            case ELECTRIC: {
                return RenderDragonEgg.EGG_ELECTRIC;
            }
            case AMETHYST: {
                return RenderDragonEgg.EGG_AMETHYST;
            }
            case COPPER: {
                return RenderDragonEgg.EGG_COPPER;
            }
            case BLACK: 
        }
        return RenderDragonEgg.EGG_BLACK;
    }
}

