/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity.player;

import com.github.alexthe666.iceandfire.IceAndFireConfig;
import com.github.alexthe666.iceandfire.item.ItemCopperArmor;
import com.github.alexthe666.iceandfire.item.ItemDeathwormArmor;
import com.github.alexthe666.iceandfire.item.ItemScaleArmor;
import com.github.alexthe666.iceandfire.item.ItemSeaSerpentArmor;
import com.github.alexthe666.iceandfire.item.ItemSilverArmor;
import com.github.alexthe666.iceandfire.item.ItemTrollArmor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderModArmor {
    private static final Map<EntityEquipmentSlot, Boolean> MOD_EQUIPMENT_MAP = new HashMap<EntityEquipmentSlot, Boolean>();

    @SubscribeEvent
    public void playerRender(RenderPlayerEvent.Pre event) {
        if (!IceAndFireConfig.CLIENT_SETTINGS.fixArmorRenderingBugs) {
            return;
        }
        if (event.getEntityPlayer() instanceof AbstractClientPlayer) {
            boolean hasModHelmet = false;
            boolean hasModChestplate = false;
            boolean hasModLeggings = false;
            boolean hasModBoots = false;
            for (ItemStack stack : event.getEntityPlayer().func_184193_aE()) {
                ItemArmor armor;
                ItemStack disguise = this.getPhantomThreadDisguise(stack);
                if (disguise != null) {
                    stack = disguise;
                }
                if (!(stack.func_77973_b() instanceof ItemArmor) || !this.isModArmor(armor = (ItemArmor)stack.func_77973_b())) continue;
                if (this.isHelmet(armor)) {
                    hasModHelmet = true;
                    continue;
                }
                if (this.isChestplate(armor)) {
                    hasModChestplate = true;
                    continue;
                }
                if (this.isLeggings(armor)) {
                    hasModLeggings = true;
                    continue;
                }
                if (!this.isBoots(armor)) continue;
                hasModBoots = true;
            }
            ModelPlayer playerModel = event.getRenderer().func_177087_b();
            if (hasModHelmet) {
                MOD_EQUIPMENT_MAP.put(EntityEquipmentSlot.HEAD, true);
                playerModel.field_178720_f.field_78807_k = true;
            } else if (MOD_EQUIPMENT_MAP.getOrDefault(EntityEquipmentSlot.HEAD, false).booleanValue()) {
                MOD_EQUIPMENT_MAP.put(EntityEquipmentSlot.HEAD, false);
                playerModel.field_178720_f.field_78807_k = false;
            }
            if (hasModChestplate) {
                MOD_EQUIPMENT_MAP.put(EntityEquipmentSlot.CHEST, true);
                playerModel.field_178730_v.field_78807_k = true;
                playerModel.field_178734_a.field_78807_k = true;
                playerModel.field_178732_b.field_78807_k = true;
            } else if (MOD_EQUIPMENT_MAP.getOrDefault(EntityEquipmentSlot.CHEST, false).booleanValue()) {
                MOD_EQUIPMENT_MAP.put(EntityEquipmentSlot.CHEST, false);
                playerModel.field_178730_v.field_78807_k = false;
                playerModel.field_178734_a.field_78807_k = false;
                playerModel.field_178732_b.field_78807_k = false;
            }
            if (hasModLeggings || hasModBoots) {
                MOD_EQUIPMENT_MAP.put(EntityEquipmentSlot.LEGS, true);
                playerModel.field_178733_c.field_78807_k = true;
                playerModel.field_178731_d.field_78807_k = true;
            } else if (MOD_EQUIPMENT_MAP.getOrDefault(EntityEquipmentSlot.LEGS, false).booleanValue()) {
                MOD_EQUIPMENT_MAP.put(EntityEquipmentSlot.LEGS, false);
                playerModel.field_178733_c.field_78807_k = false;
                playerModel.field_178731_d.field_78807_k = false;
            }
        }
    }

    public boolean isModArmor(ItemArmor armor) {
        return armor instanceof ItemScaleArmor || armor instanceof ItemSeaSerpentArmor || armor instanceof ItemTrollArmor || armor instanceof ItemDeathwormArmor || armor instanceof ItemSilverArmor || armor instanceof ItemCopperArmor;
    }

    public ItemStack getPhantomThreadDisguise(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null || tagCompound.func_82582_d()) {
            return null;
        }
        if (!tagCompound.func_74764_b("classy_hat_invisible")) {
            return null;
        }
        if (!tagCompound.func_74764_b("classy_hat_disguise")) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound diguise = tagCompound.func_74775_l("classy_hat_disguise");
        if (diguise.func_82582_d()) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(diguise);
    }

    public boolean isHelmet(ItemArmor armor) {
        return armor.func_185083_B_() == EntityEquipmentSlot.HEAD;
    }

    public boolean isChestplate(ItemArmor armor) {
        return armor.func_185083_B_() == EntityEquipmentSlot.CHEST;
    }

    public boolean isLeggings(ItemArmor armor) {
        return armor.func_185083_B_() == EntityEquipmentSlot.LEGS;
    }

    public boolean isBoots(ItemArmor armor) {
        return armor.func_185083_B_() == EntityEquipmentSlot.FEET;
    }
}

