/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.iceandfire.api.IEntityEffectCapability;
import com.github.alexthe666.iceandfire.api.InFCapabilities;
import com.github.alexthe666.iceandfire.client.model.ModelGorgon;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderGorgon
extends RenderLiving<EntityGorgon> {
    private static final ResourceLocation PASSIVE_TEXTURE = new ResourceLocation("iceandfire:textures/models/gorgon/gorgon_passive.png");
    private static final ResourceLocation AGRESSIVE_TEXTURE = new ResourceLocation("iceandfire:textures/models/gorgon/gorgon_active.png");
    private static final ResourceLocation DEAD_TEXTURE = new ResourceLocation("iceandfire:textures/models/gorgon/gorgon_decapitated.png");

    public RenderGorgon(RenderManager renderManager) {
        super(renderManager, (ModelBase)new ModelGorgon(), 0.6f);
        this.field_177097_h.add(new LayerGorgonEyes(this));
    }

    public void preRenderCallback(EntityGorgon entitylivingbaseIn, float partialTickTime) {
        GL11.glScalef((float)0.85f, (float)0.85f, (float)0.85f);
    }

    protected ResourceLocation getEntityTexture(EntityGorgon gorgon) {
        if (gorgon.getAnimation() == EntityGorgon.ANIMATION_SCARE) {
            return AGRESSIVE_TEXTURE;
        }
        if (gorgon.field_70725_aQ > 0) {
            return DEAD_TEXTURE;
        }
        return PASSIVE_TEXTURE;
    }

    @SideOnly(value=Side.CLIENT)
    public static class LayerGorgonEyes
    implements LayerRenderer<EntityGorgon> {
        private static final ResourceLocation TEXTURE = new ResourceLocation("iceandfire:textures/models/gorgon/gorgon_eyes.png");
        private final RenderGorgon render;

        public LayerGorgonEyes(RenderGorgon renderIn) {
            this.render = renderIn;
        }

        public void doRenderLayer(EntityGorgon gorgon, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            IEntityEffectCapability capability;
            if (!(gorgon.getAnimation() != EntityGorgon.ANIMATION_SCARE && gorgon.getAnimation() != EntityGorgon.ANIMATION_HIT || (capability = InFCapabilities.getEntityEffectCapability((EntityLivingBase)gorgon)) != null && capability.isStoned())) {
                this.render.func_110776_a(TEXTURE);
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                GlStateManager.func_179140_f();
                GlStateManager.func_179132_a((!gorgon.func_82150_aj() ? 1 : 0) != 0);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)61680.0f, (float)0.0f);
                GlStateManager.func_179145_e();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.render.func_177087_b().func_78088_a((Entity)gorgon, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                this.render.func_177105_a((EntityLiving)gorgon);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179084_k();
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

