/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model.animator;

import com.github.alexthe666.iceandfire.client.model.animator.IceAndFireTabulaModelAnimator;
import com.github.alexthe666.iceandfire.client.model.util.EnumDragonAnimations;
import com.github.alexthe666.iceandfire.client.model.util.IIceAndFireTabulaModelAnimator;
import com.github.alexthe666.iceandfire.client.model.util.IceAndFireTabulaModel;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.client.model.ModelRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FireDragonTabulaModelAnimator
extends IceAndFireTabulaModelAnimator
implements IIceAndFireTabulaModelAnimator<EntityFireDragon> {
    private final IceAndFireTabulaModel[] walkPoses;
    private final IceAndFireTabulaModel[] flyPoses;
    AdvancedModelRenderer[] neckParts;
    AdvancedModelRenderer[] tailParts;
    AdvancedModelRenderer[] tailPartsWBody;
    AdvancedModelRenderer[] toesPartsL;
    AdvancedModelRenderer[] toesPartsR;

    public FireDragonTabulaModelAnimator() {
        super(EnumDragonAnimations.GROUND_POSE.firedragon_model);
        this.walkPoses = new IceAndFireTabulaModel[]{EnumDragonAnimations.WALK1.firedragon_model, EnumDragonAnimations.WALK2.firedragon_model, EnumDragonAnimations.WALK3.firedragon_model, EnumDragonAnimations.WALK4.firedragon_model};
        this.flyPoses = new IceAndFireTabulaModel[]{EnumDragonAnimations.FLIGHT1.firedragon_model, EnumDragonAnimations.FLIGHT2.firedragon_model, EnumDragonAnimations.FLIGHT3.firedragon_model, EnumDragonAnimations.FLIGHT4.firedragon_model, EnumDragonAnimations.FLIGHT5.firedragon_model, EnumDragonAnimations.FLIGHT6.firedragon_model};
    }

    @Override
    public void init(IceAndFireTabulaModel model) {
        this.neckParts = new AdvancedModelRenderer[]{model.getCube("Neck1"), model.getCube("Neck2"), model.getCube("Neck3"), model.getCube("Neck3"), model.getCube("Head")};
        this.tailParts = new AdvancedModelRenderer[]{model.getCube("Tail1"), model.getCube("Tail2"), model.getCube("Tail3"), model.getCube("Tail4")};
        this.tailPartsWBody = new AdvancedModelRenderer[]{model.getCube("BodyLower"), model.getCube("Tail1"), model.getCube("Tail2"), model.getCube("Tail3"), model.getCube("Tail4")};
        this.toesPartsL = new AdvancedModelRenderer[]{model.getCube("ToeL1"), model.getCube("ToeL2"), model.getCube("ToeL3")};
        this.toesPartsR = new AdvancedModelRenderer[]{model.getCube("ToeR1"), model.getCube("ToeR2"), model.getCube("ToeR3")};
    }

    @Override
    public void setRotationAngles(IceAndFireTabulaModel model, EntityFireDragon entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        model.resetToDefaultPose();
        this.animate(model, entity);
        boolean walking = !entity.isHovering() && !entity.isFlying() && entity.hoverProgress < 20.0f && entity.flyProgress < 20.0f;
        int currentIndex = walking ? entity.walkCycle / 10 : entity.flightCycle / 10;
        int prevIndex = currentIndex - 1;
        if (prevIndex < 0) {
            prevIndex = walking ? 3 : 5;
        }
        IceAndFireTabulaModel currentPosition = walking ? this.walkPoses[currentIndex] : this.flyPoses[currentIndex];
        IceAndFireTabulaModel prevPosition = walking ? this.walkPoses[prevIndex] : this.flyPoses[prevIndex];
        float delta = (float)(walking ? entity.walkCycle : entity.flightCycle) / 10.0f % 1.0f;
        float deltaTicks = delta + LLibrary.PROXY.getPartialTicks() / 10.0f;
        for (AdvancedModelRenderer cube : model.getCubes().values()) {
            this.genderMob(entity, cube);
            if (walking && entity.flyProgress <= 0.0f && entity.hoverProgress <= 0.0f && entity.modelDeadProgress <= 0.0f) {
                AdvancedModelRenderer walkPart = EnumDragonAnimations.GROUND_POSE.firedragon_model.getCube(cube.field_78802_n);
                float prevX = prevPosition.getCube((String)cube.field_78802_n).field_78795_f;
                float prevY = prevPosition.getCube((String)cube.field_78802_n).field_78796_g;
                float prevZ = prevPosition.getCube((String)cube.field_78802_n).field_78808_h;
                float x = currentPosition.getCube((String)cube.field_78802_n).field_78795_f;
                float y = currentPosition.getCube((String)cube.field_78802_n).field_78796_g;
                float z = currentPosition.getCube((String)cube.field_78802_n).field_78808_h;
                if (this.isHorn(cube) || this.isWing(model, cube) && entity.getAnimation() == EntityDragonBase.ANIMATION_WINGBLAST) {
                    this.addToRotateAngle(cube, limbSwingAmount, walkPart.field_78795_f, walkPart.field_78796_g, walkPart.field_78808_h);
                } else {
                    this.addToRotateAngle(cube, limbSwingAmount, prevX + deltaTicks * this.distance(prevX, x), prevY + deltaTicks * this.distance(prevY, y), prevZ + deltaTicks * this.distance(prevZ, z));
                }
            }
            if (entity.modelDeadProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.DEAD.firedragon_model.getCube(cube.field_78802_n))) {
                this.transitionTo(cube, EnumDragonAnimations.DEAD.firedragon_model.getCube(cube.field_78802_n), entity.modelDeadProgress, 20.0f, cube.field_78802_n.equals("ThighR") || cube.field_78802_n.equals("ThighL"));
            }
            if (entity.sleepProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.SLEEPING_POSE.firedragon_model.getCube(cube.field_78802_n))) {
                this.transitionTo(cube, EnumDragonAnimations.SLEEPING_POSE.firedragon_model.getCube(cube.field_78802_n), entity.sleepProgress, 20.0f, false);
            }
            if (entity.hoverProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.HOVERING_POSE.firedragon_model.getCube(cube.field_78802_n)) && !this.isWing(model, cube) && !cube.field_78802_n.contains("Tail")) {
                this.transitionTo(cube, EnumDragonAnimations.HOVERING_POSE.firedragon_model.getCube(cube.field_78802_n), entity.hoverProgress, 20.0f, false);
            }
            if (entity.flyProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.FLYING_POSE.firedragon_model.getCube(cube.field_78802_n))) {
                this.transitionTo(cube, EnumDragonAnimations.FLYING_POSE.firedragon_model.getCube(cube.field_78802_n), entity.flyProgress - entity.diveProgress * 2.0f, 20.0f, false);
            }
            if (entity.sitProgress > 0.0f && !entity.func_184218_aH() && !this.isPartEqual(cube, EnumDragonAnimations.SITTING_POSE.firedragon_model.getCube(cube.field_78802_n))) {
                this.transitionTo(cube, EnumDragonAnimations.SITTING_POSE.firedragon_model.getCube(cube.field_78802_n), entity.sitProgress, 20.0f, false);
            }
            if (entity.ridingProgress > 0.0f && !this.isHorn(cube) && !this.isPartEqual(cube, EnumDragonAnimations.SIT_ON_PLAYER_POSE.firedragon_model.getCube(cube.field_78802_n))) {
                this.transitionTo(cube, EnumDragonAnimations.SIT_ON_PLAYER_POSE.firedragon_model.getCube(cube.field_78802_n), entity.ridingProgress, 20.0f, false);
                if (cube.field_78802_n.equals("BodyUpper")) {
                    cube.field_78798_e += (-12.0f - cube.field_78798_e) / 20.0f * entity.ridingProgress;
                }
            }
            if (entity.tackleProgress > 0.0f && !this.isPartEqual(EnumDragonAnimations.TACKLE.firedragon_model.getCube(cube.field_78802_n), EnumDragonAnimations.FLYING_POSE.firedragon_model.getCube(cube.field_78802_n)) && !this.isWing(model, cube)) {
                this.transitionTo(cube, EnumDragonAnimations.TACKLE.firedragon_model.getCube(cube.field_78802_n), entity.tackleProgress, 5.0f, false);
            }
            if (entity.diveProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.DIVING_POSE.firedragon_model.getCube(cube.field_78802_n))) {
                this.transitionTo(cube, EnumDragonAnimations.DIVING_POSE.firedragon_model.getCube(cube.field_78802_n), entity.diveProgress, 10.0f, false);
            }
            if (!walking) {
                float prevX = prevPosition.getCube((String)cube.field_78802_n).field_78795_f;
                float prevY = prevPosition.getCube((String)cube.field_78802_n).field_78796_g;
                float prevZ = prevPosition.getCube((String)cube.field_78802_n).field_78808_h;
                float x = currentPosition.getCube((String)cube.field_78802_n).field_78795_f;
                float y = currentPosition.getCube((String)cube.field_78802_n).field_78796_g;
                float z = currentPosition.getCube((String)cube.field_78802_n).field_78808_h;
                this.setRotateAngle(cube, 1.0f, prevX + deltaTicks * this.distance(prevX, x), prevY + deltaTicks * this.distance(prevY, y), prevZ + deltaTicks * this.distance(prevZ, z));
            }
            if (!(entity.fireBreathProgress > 0.0f) || this.isPartEqual(cube, EnumDragonAnimations.STREAM_BREATH.firedragon_model.getCube(cube.field_78802_n)) || this.isWing(model, cube) || cube.field_78802_n.contains("Finger")) continue;
            this.transitionTo(cube, EnumDragonAnimations.STREAM_BREATH.firedragon_model.getCube(cube.field_78802_n), entity.fireBreathProgress, 5.0f, false);
        }
        float speed_walk = 0.2f;
        float speed_idle = entity.isSleeping() ? 0.025f : 0.05f;
        float speed_fly = 0.2f;
        float degree_walk = 0.5f;
        float degree_idle = entity.isSleeping() ? 0.25f : 0.5f;
        float degree_fly = 0.5f;
        if (!entity.func_175446_cd()) {
            model.faceTarget(rotationYaw, rotationPitch, 2.0f, this.neckParts);
            if (!walking) {
                model.bob(model.getCube("BodyUpper"), -speed_fly, degree_fly * 5.0f, false, ageInTicks, 1.0f);
                model.walk(model.getCube("BodyUpper"), -speed_fly, degree_fly * 0.1f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
                model.chainWave(this.tailPartsWBody, speed_fly, degree_fly * -0.1f, 0.0, ageInTicks, 1.0f);
                model.chainWave(this.neckParts, speed_fly, degree_fly * 0.2f, -4.0, ageInTicks, 1.0f);
                model.chainWave(this.toesPartsL, speed_fly, degree_fly * 0.2f, -2.0, ageInTicks, 1.0f);
                model.chainWave(this.toesPartsR, speed_fly, degree_fly * 0.2f, -2.0, ageInTicks, 1.0f);
                model.walk(model.getCube("ThighR"), -speed_fly, degree_fly * 0.1f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
                model.walk(model.getCube("ThighL"), -speed_fly, degree_fly * 0.1f, true, 0.0f, 0.0f, ageInTicks, 1.0f);
            } else {
                model.bob(model.getCube("BodyUpper"), speed_walk * 2.0f, degree_walk * 1.7f, false, limbSwing, limbSwingAmount);
                model.bob(model.getCube("ThighR"), speed_walk, degree_walk * 1.7f, false, limbSwing, limbSwingAmount);
                model.bob(model.getCube("ThighL"), speed_walk, degree_walk * 1.7f, false, limbSwing, limbSwingAmount);
                model.chainSwing(this.tailParts, speed_walk, degree_walk * 0.25f, -2.0, limbSwing, limbSwingAmount);
                model.chainWave(this.tailParts, speed_walk, degree_walk * 0.15f, 2.0, limbSwing, limbSwingAmount);
                model.chainSwing(this.neckParts, speed_walk, degree_walk * 0.15f, 2.0, limbSwing, limbSwingAmount);
                model.chainWave(this.neckParts, speed_walk, degree_walk * 0.05f, -2.0, limbSwing, limbSwingAmount);
                model.chainSwing(this.tailParts, speed_idle, degree_idle * 0.25f, -2.0, ageInTicks, 1.0f);
                model.chainWave(this.tailParts, speed_idle, degree_idle * 0.15f, -2.0, ageInTicks, 1.0f);
                model.chainWave(this.neckParts, speed_idle, degree_idle * -0.15f, -3.0, ageInTicks, 1.0f);
                model.walk(model.getCube("Neck1"), speed_idle, degree_idle * 0.05f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
            }
            model.bob(model.getCube("BodyUpper"), speed_idle, degree_idle * 1.3f, false, ageInTicks, 1.0f);
            model.bob(model.getCube("ThighR"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
            model.bob(model.getCube("ThighL"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
            model.bob(model.getCube("armR1"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
            model.bob(model.getCube("armL1"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
        }
        if (!entity.isModelDead()) {
            if (entity.turn_buffer != null && !entity.func_184207_aI() && !entity.func_184218_aH() && entity.isBreathingFire()) {
                entity.turn_buffer.applyChainSwingBuffer((ModelRenderer[])this.neckParts);
            }
            if (entity.tail_buffer != null && !entity.func_184218_aH()) {
                entity.tail_buffer.applyChainSwingBuffer((ModelRenderer[])this.tailPartsWBody);
            }
        }
    }

    private void genderMob(EntityFireDragon entity, AdvancedModelRenderer cube) {
        if (!entity.isMale()) {
            AdvancedModelRenderer maleBox = EnumDragonAnimations.MALE.firedragon_model.getCube(cube.field_78802_n);
            AdvancedModelRenderer femaleBox = EnumDragonAnimations.FEMALE.firedragon_model.getCube(cube.field_78802_n);
            if (maleBox == null || femaleBox == null) {
                return;
            }
            float x = femaleBox.field_78795_f;
            float y = femaleBox.field_78796_g;
            float z = femaleBox.field_78808_h;
            if (x != maleBox.field_78795_f || y != maleBox.field_78796_g || z != maleBox.field_78808_h) {
                this.setRotateAngle(cube, 1.0f, x, y, z);
            }
        }
    }

    private boolean isWing(IceAndFireTabulaModel model, AdvancedModelRenderer modelRenderer) {
        return this.isComponentOf(model, "armL1", modelRenderer) || this.isComponentOf(model, "armR1", modelRenderer);
    }

    private boolean isHorn(AdvancedModelRenderer modelRenderer) {
        return modelRenderer.field_78802_n.contains("Horn");
    }

    public void animate(IceAndFireTabulaModel model, EntityFireDragon entity) {
        model.llibAnimator.update((IAnimatedEntity)entity);
        model.llibAnimator.setAnimation(EntityFireDragon.ANIMATION_SPEAK);
        model.llibAnimator.startKeyframe(5);
        this.rotate(model.llibAnimator, model.getCube("Jaw"), 18.0f, 0.0f, 0.0f);
        model.llibAnimator.move((ModelRenderer)model.getCube("Jaw"), 0.0f, 0.0f, 0.2f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.setStaticKeyframe(5);
        model.llibAnimator.startKeyframe(5);
        this.rotate(model.llibAnimator, model.getCube("Jaw"), 18.0f, 0.0f, 0.0f);
        model.llibAnimator.move((ModelRenderer)model.getCube("Jaw"), 0.0f, 0.0f, 0.2f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(5);
        model.llibAnimator.setAnimation(EntityFireDragon.ANIMATION_BITE);
        model.llibAnimator.startKeyframe(15);
        this.rotate(model.llibAnimator, model.getCube("Neck1"), -12.0f, 0.0f, 0.0f);
        this.rotate(model.llibAnimator, model.getCube("Neck2"), -5.0f, 0.0f, 0.0f);
        this.rotate(model.llibAnimator, model.getCube("Neck3"), 5.0f, 0.0f, 0.0f);
        this.rotate(model.llibAnimator, model.getCube("Head"), 36.0f, 0.0f, 0.0f);
        this.rotate(model.llibAnimator, model.getCube("Jaw"), 20.0f, 0.0f, 0.0f);
        model.llibAnimator.move((ModelRenderer)model.getCube("Jaw"), 0.0f, 0.0f, 0.2f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.rotate(model.llibAnimator, model.getCube("Neck1"), -2.0f, 0.0f, 0.0f);
        this.rotate(model.llibAnimator, model.getCube("Neck2"), 10.0f, 0.0f, 0.0f);
        this.rotate(model.llibAnimator, model.getCube("Neck3"), 10.0f, 0.0f, 0.0f);
        this.rotate(model.llibAnimator, model.getCube("Head"), 20.0f, 0.0f, 0.0f);
        this.rotate(model.llibAnimator, model.getCube("Jaw"), 20.0f, 0.0f, 0.0f);
        model.llibAnimator.move((ModelRenderer)model.getCube("Jaw"), 0.0f, 0.0f, 0.2f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityFireDragon.ANIMATION_SHAKEPREY);
        model.llibAnimator.startKeyframe(15);
        this.moveToPose(model, EnumDragonAnimations.GRAB1.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.GRAB2.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.GRAB_SHAKE1.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.GRAB_SHAKE2.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.GRAB_SHAKE3.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityFireDragon.ANIMATION_TAILWHACK);
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.TAIL_WHIP1.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.TAIL_WHIP2.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.TAIL_WHIP3.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityFireDragon.ANIMATION_WINGBLAST);
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST1.firedragon_model);
        model.llibAnimator.move((ModelRenderer)model.getCube("BodyUpper"), 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST2.firedragon_model);
        model.llibAnimator.move((ModelRenderer)model.getCube("BodyUpper"), 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST3.firedragon_model);
        model.llibAnimator.move((ModelRenderer)model.getCube("BodyUpper"), 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST4.firedragon_model);
        model.llibAnimator.move((ModelRenderer)model.getCube("BodyUpper"), 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST5.firedragon_model);
        model.llibAnimator.move((ModelRenderer)model.getCube("BodyUpper"), 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST6.firedragon_model);
        model.llibAnimator.move((ModelRenderer)model.getCube("BodyUpper"), 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST7.firedragon_model);
        model.llibAnimator.move((ModelRenderer)model.getCube("BodyUpper"), 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityFireDragon.ANIMATION_FIRECHARGE);
        model.llibAnimator.startKeyframe(15);
        this.moveToPose(model, EnumDragonAnimations.STREAM_CHARGE.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityFireDragon.ANIMATION_ROAR);
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.ROAR1.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.ROAR2.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.ROAR3.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.reset();
    }
}

