/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model;

import com.github.alexthe666.iceandfire.client.model.util.HideableModelRenderer;
import com.github.alexthe666.iceandfire.entity.EntityDreadThrall;
import net.ilexiconn.llibrary.client.model.ModelAnimator;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelBase;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;

public class ModelDreadThrall
extends AdvancedModelBase {
    public HideableModelRenderer bipedHead;
    public HideableModelRenderer bipedHeadwear;
    public HideableModelRenderer bipedBody;
    public HideableModelRenderer bipedRightArm;
    public HideableModelRenderer bipedLeftArm;
    public HideableModelRenderer bipedRightLeg;
    public HideableModelRenderer bipedLeftLeg;
    public ModelBiped.ArmPose leftArmPose;
    public ModelBiped.ArmPose rightArmPose;
    public boolean isSneak;
    private ModelAnimator animator;
    private boolean armor = false;

    public ModelDreadThrall(float modelSize, boolean armorArms) {
        this.armor = armorArms;
        this.field_78089_u = 32;
        this.field_78090_t = 64;
        this.leftArmPose = ModelBiped.ArmPose.EMPTY;
        this.rightArmPose = ModelBiped.ArmPose.EMPTY;
        this.bipedBody = new HideableModelRenderer(this, 16, 16);
        this.bipedBody.func_78790_a(-4.0f, 0.0f, -2.0f, 8, 12, 4, modelSize);
        this.bipedBody.func_78793_a(0.0f, 0.0f, 0.0f);
        this.bipedRightArm = new HideableModelRenderer(this, 40, 16);
        this.bipedRightArm.func_78790_a(-1.0f, -2.0f, -1.0f, 2, 12, 2, modelSize);
        this.bipedRightArm.func_78793_a(-5.0f, 2.0f, 0.0f);
        this.bipedLeftArm = new HideableModelRenderer(this, 40, 16);
        this.bipedLeftArm.field_78809_i = true;
        this.bipedLeftArm.func_78790_a(-1.0f, -2.0f, -1.0f, 2, 12, 2, modelSize);
        this.bipedLeftArm.func_78793_a(5.0f, 2.0f, 0.0f);
        this.bipedRightLeg = new HideableModelRenderer(this, 0, 16);
        this.bipedRightLeg.func_78790_a(-1.0f, 0.0f, -1.0f, 2, 12, 2, modelSize);
        this.bipedRightLeg.func_78793_a(-2.0f, 12.0f, 0.0f);
        this.bipedLeftLeg = new HideableModelRenderer(this, 0, 16);
        this.bipedLeftLeg.field_78809_i = true;
        this.bipedLeftLeg.func_78790_a(-1.0f, 0.0f, -1.0f, 2, 12, 2, modelSize);
        this.bipedLeftLeg.func_78793_a(2.0f, 12.0f, 0.0f);
        this.bipedHead = new HideableModelRenderer(this, 0, 0);
        this.bipedHead.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, modelSize - 0.5f);
        this.bipedHead.func_78793_a(0.0f, 0.0f, 0.0f);
        this.bipedHeadwear = new HideableModelRenderer(this, 32, 0);
        this.bipedHeadwear.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, modelSize);
        this.bipedHeadwear.func_78793_a(0.0f, 0.0f, 0.0f);
        if (armorArms) {
            this.bipedHead = new HideableModelRenderer(this, 0, 0);
            this.bipedHead.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, modelSize);
            this.bipedHead.func_78793_a(0.0f, 0.0f, 0.0f);
            this.bipedHeadwear = new HideableModelRenderer(this, 32, 0);
            this.bipedHeadwear.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, modelSize + 0.5f);
            this.bipedHeadwear.func_78793_a(0.0f, 0.0f, 0.0f);
            this.bipedBody = new HideableModelRenderer(this, 16, 16);
            this.bipedBody.func_78790_a(-4.0f, 0.0f, -2.0f, 8, 12, 4, modelSize);
            this.bipedBody.func_78793_a(0.0f, 0.0f, 0.0f);
            this.bipedRightArm = new HideableModelRenderer(this, 40, 16);
            this.bipedRightArm.func_78790_a(-3.0f, -2.0f, -2.0f, 4, 12, 4, modelSize);
            this.bipedRightArm.func_78793_a(-5.0f, 2.0f, 0.0f);
            this.bipedLeftArm = new HideableModelRenderer(this, 40, 16);
            this.bipedLeftArm.field_78809_i = true;
            this.bipedLeftArm.func_78790_a(-1.0f, -2.0f, -2.0f, 4, 12, 4, modelSize);
            this.bipedLeftArm.func_78793_a(5.0f, 2.0f, 0.0f);
            this.bipedRightLeg = new HideableModelRenderer(this, 0, 16);
            this.bipedRightLeg.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, modelSize);
            this.bipedRightLeg.func_78793_a(-1.9f, 12.0f, 0.0f);
            this.bipedLeftLeg = new HideableModelRenderer(this, 0, 16);
            this.bipedLeftLeg.field_78809_i = true;
            this.bipedLeftLeg.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, modelSize);
            this.bipedLeftLeg.func_78793_a(1.9f, 12.0f, 0.0f);
        }
        this.bipedBody.func_78792_a((ModelRenderer)this.bipedHead);
        this.bipedHead.func_78792_a((ModelRenderer)this.bipedHeadwear);
        this.bipedBody.func_78792_a((ModelRenderer)this.bipedRightArm);
        this.bipedBody.func_78792_a((ModelRenderer)this.bipedLeftArm);
        this.bipedBody.func_78792_a((ModelRenderer)this.bipedRightLeg);
        this.bipedBody.func_78792_a((ModelRenderer)this.bipedLeftLeg);
        this.animator = ModelAnimator.create();
        this.updateDefaultPose();
    }

    public void func_78086_a(EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.rightArmPose = ModelBiped.ArmPose.EMPTY;
        this.leftArmPose = ModelBiped.ArmPose.EMPTY;
        ItemStack itemstack = entitylivingbaseIn.func_184586_b(EnumHand.MAIN_HAND);
        if (itemstack.func_77973_b() == Items.field_151031_f && ((AbstractSkeleton)entitylivingbaseIn).func_184725_db()) {
            if (entitylivingbaseIn.func_184591_cq() == EnumHandSide.RIGHT) {
                this.rightArmPose = ModelBiped.ArmPose.BOW_AND_ARROW;
            } else {
                this.leftArmPose = ModelBiped.ArmPose.BOW_AND_ARROW;
            }
        }
        super.func_78086_a(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTickTime);
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        super.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn);
        this.resetToDefaultPose();
        this.animate((IAnimatedEntity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
        ItemStack itemstack = ((EntityLivingBase)entityIn).func_184614_ca();
        EntityDreadThrall thrall = (EntityDreadThrall)entityIn;
        float f = 1.0f;
        this.bipedRightArm.field_78795_f += MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.bipedLeftArm.field_78795_f += MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.bipedRightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount / f;
        this.bipedLeftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount / f;
        this.bipedRightLeg.field_78796_g = 0.0f;
        this.bipedLeftLeg.field_78796_g = 0.0f;
        this.bipedRightLeg.field_78808_h = 0.0f;
        this.bipedLeftLeg.field_78808_h = 0.0f;
        if (this.field_78093_q) {
            this.bipedRightArm.field_78795_f += -0.62831855f;
            this.bipedLeftArm.field_78795_f += -0.62831855f;
            this.bipedRightLeg.field_78795_f = -1.4137167f;
            this.bipedRightLeg.field_78796_g = 0.31415927f;
            this.bipedRightLeg.field_78808_h = 0.07853982f;
            this.bipedLeftLeg.field_78795_f = -1.4137167f;
            this.bipedLeftLeg.field_78796_g = -0.31415927f;
            this.bipedLeftLeg.field_78808_h = -0.07853982f;
        }
        if (this.field_78095_p > 0.0f) {
            EnumHandSide enumhandside = this.getMainHand(entityIn);
            ModelRenderer modelrenderer = this.getArmForSide(enumhandside);
            float f1 = this.field_78095_p;
            this.bipedBody.field_78796_g = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)f1) * ((float)Math.PI * 2))) * 0.2f;
            if (enumhandside == EnumHandSide.LEFT) {
                this.bipedBody.field_78796_g *= -1.0f;
            }
            this.bipedRightArm.field_78798_e = MathHelper.func_76126_a((float)this.bipedBody.field_78796_g) * 5.0f;
            this.bipedRightArm.field_78800_c = -MathHelper.func_76134_b((float)this.bipedBody.field_78796_g) * 5.0f;
            this.bipedLeftArm.field_78798_e = -MathHelper.func_76126_a((float)this.bipedBody.field_78796_g) * 5.0f;
            this.bipedLeftArm.field_78800_c = MathHelper.func_76134_b((float)this.bipedBody.field_78796_g) * 5.0f;
            this.bipedRightArm.field_78796_g += this.bipedBody.field_78796_g;
            this.bipedLeftArm.field_78796_g += this.bipedBody.field_78796_g;
            this.bipedLeftArm.field_78795_f += this.bipedBody.field_78796_g;
            f1 = 1.0f - this.field_78095_p;
            f1 *= f1;
            f1 *= f1;
            f1 = 1.0f - f1;
            float f2 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
            float f3 = MathHelper.func_76126_a((float)(this.field_78095_p * (float)Math.PI)) * -(this.bipedHead.field_78795_f - 0.7f) * 0.75f;
            modelrenderer.field_78795_f = (float)((double)modelrenderer.field_78795_f - ((double)f2 * 1.2 + (double)f3));
            modelrenderer.field_78796_g += this.bipedBody.field_78796_g * 2.0f;
            modelrenderer.field_78808_h += MathHelper.func_76126_a((float)(this.field_78095_p * (float)Math.PI)) * -0.4f;
        }
        if (this.isSneak) {
            this.bipedBody.field_78795_f = 0.5f;
            this.bipedRightArm.field_78795_f += 0.4f;
            this.bipedLeftArm.field_78795_f += 0.4f;
            this.bipedRightLeg.field_78798_e = 4.0f;
            this.bipedLeftLeg.field_78798_e = 4.0f;
            this.bipedRightLeg.field_78797_d = 9.0f;
            this.bipedLeftLeg.field_78797_d = 9.0f;
            this.bipedHead.field_78797_d = 1.0f;
        } else {
            this.bipedBody.field_78795_f = 0.0f;
            this.bipedRightLeg.field_78798_e = 0.1f;
            this.bipedLeftLeg.field_78798_e = 0.1f;
            this.bipedRightLeg.field_78797_d = 12.0f;
            this.bipedLeftLeg.field_78797_d = 12.0f;
            this.bipedHead.field_78797_d = 0.0f;
        }
        this.bipedRightArm.field_78808_h += MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.bipedLeftArm.field_78808_h -= MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.bipedRightArm.field_78795_f += MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
        this.bipedLeftArm.field_78795_f -= MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
        float speed_walk = 0.6f;
        float speed_idle = 0.05f;
        float degree_walk = 1.0f;
        float degree_idle = 0.5f;
        if (thrall.getAnimation() == EntityDreadThrall.ANIMATION_SPAWN && thrall.getAnimationTick() < 30) {
            this.flap(this.bipedRightArm, 0.5f, 0.5f, false, 2.0f, -0.7f, thrall.field_70173_aa, 1.0f);
            this.flap(this.bipedLeftArm, 0.5f, 0.5f, true, 2.0f, -0.7f, thrall.field_70173_aa, 1.0f);
            this.walk(this.bipedRightArm, 0.5f, 0.5f, true, 1.0f, 0.0f, thrall.field_70173_aa, 1.0f);
            this.walk(this.bipedLeftArm, 0.5f, 0.5f, true, 1.0f, 0.0f, thrall.field_70173_aa, 1.0f);
        }
        this.flap(this.bipedBody, 0.5f, 0.15f, false, 1.0f, 0.0f, limbSwing, limbSwingAmount);
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entityIn);
        GlStateManager.func_179094_E();
        this.bipedBody.func_78785_a(scale);
        GlStateManager.func_179121_F();
    }

    public void animate(IAnimatedEntity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        this.animator.update(entity);
        this.animator.setAnimation(EntityDreadThrall.ANIMATION_SPAWN);
        this.animator.startKeyframe(0);
        this.animator.move((ModelRenderer)this.bipedBody, 0.0f, 35.0f, 0.0f);
        this.rotate(this.animator, this.bipedLeftArm, -180.0f, 0.0f, 0.0f);
        this.rotate(this.animator, this.bipedRightArm, -180.0f, 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(30);
        this.animator.move((ModelRenderer)this.bipedBody, 0.0f, 0.0f, 0.0f);
        this.rotate(this.animator, this.bipedLeftArm, -180.0f, 0.0f, 0.0f);
        this.rotate(this.animator, this.bipedRightArm, -180.0f, 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.update(null);
    }

    private void rotate(ModelAnimator animator, AdvancedModelRenderer model, float x, float y, float z) {
        animator.rotate((ModelRenderer)model, (float)Math.toRadians(x), (float)Math.toRadians(y), (float)Math.toRadians(z));
    }

    private void rotateMinus(ModelAnimator animator, AdvancedModelRenderer model, float x, float y, float z) {
        animator.rotate((ModelRenderer)model, (float)Math.toRadians(x) - model.defaultRotationX, (float)Math.toRadians(y) - model.defaultRotationY, (float)Math.toRadians(z) - model.defaultRotationZ);
    }

    public void postRenderArm(float scale, EnumHandSide side) {
        this.bipedBody.func_78794_c(scale);
        this.getArmForSide(side).func_78794_c(scale);
    }

    protected ModelRenderer getArmForSide(EnumHandSide side) {
        return side == EnumHandSide.LEFT ? this.bipedLeftArm : this.bipedRightArm;
    }

    protected EnumHandSide getMainHand(Entity entityIn) {
        if (entityIn instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)entityIn;
            EnumHandSide enumhandside = entitylivingbase.func_184591_cq();
            return entitylivingbase.field_184622_au == EnumHand.MAIN_HAND ? enumhandside : enumhandside.func_188468_a();
        }
        return EnumHandSide.RIGHT;
    }

    public void func_178686_a(ModelBase model) {
        super.func_178686_a(model);
        if (model instanceof ModelBiped) {
            ModelBiped modelbiped = (ModelBiped)model;
            this.leftArmPose = modelbiped.field_187075_l;
            this.rightArmPose = modelbiped.field_187076_m;
            this.isSneak = modelbiped.field_78117_n;
        }
    }

    public void setVisible(boolean visible) {
        this.bipedHead.invisible = !visible;
        this.bipedHeadwear.invisible = !visible;
        this.bipedBody.invisible = !visible;
        this.bipedRightArm.invisible = !visible;
        this.bipedLeftArm.invisible = !visible;
        this.bipedRightLeg.invisible = !visible;
        this.bipedLeftLeg.invisible = !visible;
    }
}

