/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.capability.entityeffect;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.IceAndFireConfig;
import com.github.alexthe666.iceandfire.api.IEntityEffectCapability;
import com.github.alexthe666.iceandfire.entity.EntitySiren;
import com.github.alexthe666.iceandfire.entity.EntityStoneStatue;
import com.github.alexthe666.iceandfire.enums.EnumParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityEffectClientHandler {
    private static final ResourceLocation SIREN_SHADER = new ResourceLocation("iceandfire:shaders/post/siren.json");

    public static void tickUpdate(EntityLivingBase entity, World world, IEntityEffectCapability capability) {
        EntityRenderer renderer;
        if (capability.isCharmed()) {
            renderer = Minecraft.func_71410_x().field_71460_t;
            EntitySiren siren = capability.getSiren(world);
            if (siren != null) {
                double d0 = siren.field_70165_t - entity.field_70165_t;
                double d2 = siren.field_70161_v - entity.field_70161_v;
                double d1 = siren.field_70163_u - 1.0 - entity.field_70163_u;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
                entity.field_70125_A = EntityEffectClientHandler.updateRotation(entity.field_70125_A, f1, 30.0f);
                entity.field_70177_z = EntityEffectClientHandler.updateRotation(entity.field_70177_z, f, 30.0f);
                if (entity.field_70123_F) {
                    if (entity instanceof EntityLiving) {
                        ((EntityLiving)entity).func_70683_ar().func_75660_a();
                    } else if (entity.field_70122_E) {
                        entity.field_70181_x = 0.42f;
                    }
                }
                entity.field_70159_w += (Math.signum(siren.field_70165_t - entity.field_70165_t) * 0.5 - entity.field_70159_w) * 0.100000000372529;
                entity.field_70181_x += (Math.signum(siren.field_70163_u - entity.field_70163_u + 1.0) * 0.5 - entity.field_70181_x) * 0.100000000372529;
                entity.field_70179_y += (Math.signum(siren.field_70161_v - entity.field_70161_v) * 0.5 - entity.field_70179_y) * 0.100000000372529;
            }
            if (entity == Minecraft.func_71410_x().field_71439_g) {
                if (world.field_73012_v.nextInt(40) == 0) {
                    IceAndFire.PROXY.spawnParticle(EnumParticle.SIREN_APPEARANCE, world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0, 0.0, 0.0);
                }
                if (IceAndFireConfig.CLIENT_SETTINGS.sirenShader && !renderer.func_147702_a()) {
                    renderer.func_175069_a(SIREN_SHADER);
                }
            }
        } else if (entity == Minecraft.func_71410_x().field_71439_g) {
            renderer = Minecraft.func_71410_x().field_71460_t;
            if (IceAndFireConfig.CLIENT_SETTINGS.sirenShader && renderer != null && renderer.func_147706_e() != null && renderer.func_147706_e().func_148022_b() != null && SIREN_SHADER.toString().equals(renderer.func_147706_e().func_148022_b())) {
                renderer.func_181022_b();
            }
        }
        if (capability.isFrozen()) {
            capability.tickTime();
            if (!entity.func_70027_ad() || capability.getAdditionalData() > 0) {
                entity.field_70159_w *= 0.25;
                entity.field_70179_y *= 0.25;
                if (!(entity instanceof EntityDragon) && !entity.field_70122_E) {
                    entity.field_70181_x -= 0.1;
                }
                if (capability.getAdditionalData() > 0) {
                    entity.field_70159_w = 0.0;
                    entity.field_70179_y = 0.0;
                    if (entity.field_70181_x > 0.0) {
                        entity.field_70181_x = 0.0;
                    }
                    entity.field_70125_A = entity.field_70127_C;
                    entity.field_70177_z = entity.field_70126_B;
                    entity.field_70122_E = false;
                }
            }
        } else if (capability.isBlazed()) {
            entity.field_70159_w *= 0.75;
            entity.field_70179_y *= 0.75;
            if (capability.getAdditionalData() > 0) {
                entity.field_70159_w *= 0.4;
                entity.field_70179_y *= 0.4;
                if (entity.field_70181_x > 0.0) {
                    entity.field_70181_x *= 0.4;
                }
            }
        } else if (capability.isShocked()) {
            entity.field_70159_w = 0.0;
            entity.field_70179_y = 0.0;
            if (entity.field_70181_x > 0.0) {
                entity.field_70181_x = 0.0;
            }
            entity.field_70122_E = false;
            if (capability.getAdditionalData() > 0) {
                entity.field_70125_A = entity.field_70127_C;
                entity.field_70177_z = entity.field_70126_B;
            }
        } else if (capability.isStoned()) {
            boolean stonedPlayer = entity instanceof EntityStoneStatue;
            entity.field_70159_w = 0.0;
            entity.field_70179_y = 0.0;
            entity.field_70181_x -= 0.1;
            entity.field_70733_aJ = 0.0f;
            entity.field_184619_aG = 0.0f;
            entity.func_82142_c(!stonedPlayer);
            if (entity instanceof EntityLiving) {
                EntityLiving living = (EntityLiving)entity;
                living.field_70757_a = 0;
            }
            if (entity instanceof EntityHorse) {
                EntityHorse horse = (EntityHorse)entity;
                horse.field_110278_bp = 0;
                horse.func_110227_p(false);
            }
        }
    }

    private static float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }
}

