/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.block;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.core.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrassPath;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPath
extends BlockGrassPath {
    public static final PropertyBool REVERTS = PropertyBool.func_177716_a((String)"revert");
    private final Type type;

    public BlockPath(Type type) {
        this.type = type;
        this.func_149663_c(this.type.getTranslationKey());
        this.setHarvestLevel("shovel", 0);
        this.func_149711_c(0.6f);
        this.func_149672_a(type == Type.FROZEN ? SoundType.field_185853_f : SoundType.field_185849_b);
        this.func_149647_a(IceAndFire.TAB);
        if (this.type == Type.FROZEN) {
            this.setDefaultSlipperiness(0.98f);
        }
        this.func_149713_g(0);
        this.setRegistryName("iceandfire", this.type.getRegistrationKey());
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)REVERTS, (Comparable)Boolean.FALSE));
        this.func_149675_a(true);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            if (!worldIn.func_175697_a(pos, 3)) {
                return;
            }
            if (((Boolean)state.func_177229_b((IProperty)REVERTS)).booleanValue() && rand.nextInt(3) == 0) {
                worldIn.func_175656_a(pos, Blocks.field_185774_da.func_176223_P());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        switch (side) {
            case UP: {
                return true;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
                Block block = iblockstate.func_177230_c();
                return !iblockstate.func_185914_p() && block != Blocks.field_150458_ak && block != Blocks.field_185774_da && block != ModBlocks.charedGrassPath && block != ModBlocks.frozenGrassPath && block != ModBlocks.crackledGrassPath;
            }
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.type.getBaseBlock().func_180660_a(this.type.getBaseBlock().func_176223_P(), rand, fortune);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.updateBlockState(worldIn, pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        this.updateBlockState(worldIn, pos);
    }

    private void updateBlockState(World worldIn, BlockPos pos) {
        if (!worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            return;
        }
        Block block = this.type.getBaseBlock();
        IBlockState state = block.func_176223_P();
        worldIn.func_175656_a(pos, state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)REVERTS, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)REVERTS) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{REVERTS});
    }

    public static enum Type {
        CHARED,
        FROZEN,
        CRACKLED;


        public String getRegistrationKey() {
            switch (this) {
                case FROZEN: {
                    return "frozen_grass_path";
                }
                case CRACKLED: {
                    return "crackled_grass_path";
                }
            }
            return "chared_grass_path";
        }

        public String getTranslationKey() {
            switch (this) {
                case FROZEN: {
                    return "iceandfire.frozenGrassPath";
                }
                case CRACKLED: {
                    return "iceandfire.crackledGrassPath";
                }
            }
            return "iceandfire.charedGrassPath";
        }

        public Block getBaseBlock() {
            switch (this) {
                case FROZEN: {
                    return ModBlocks.frozenDirt;
                }
                case CRACKLED: {
                    return ModBlocks.crackledDirt;
                }
            }
            return ModBlocks.charedDirt;
        }
    }
}

