/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.block;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.core.ModItems;
import com.github.alexthe666.iceandfire.core.ModSounds;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityJar;
import com.github.alexthe666.iceandfire.item.ICustomRendered;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockJar
extends BlockContainer
implements ICustomRendered,
ITileEntityProvider {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);
    private final boolean empty;

    public BlockJar(boolean empty) {
        super(Material.field_151592_s);
        this.func_149711_c(1.0f);
        this.func_149752_b(2.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149647_a(IceAndFire.TAB);
        this.func_149663_c("iceandfire.jar" + (empty ? "_empty" : "_pixie"));
        this.setRegistryName("iceandfire", "jar" + (empty ? "_empty" : "_pixie"));
        this.field_149758_A = true;
        if (!empty) {
            this.func_149715_a(0.75f);
            GameRegistry.registerTileEntity(TileEntityJar.class, (String)"jar");
        }
        this.empty = empty;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149662_c(IBlockState blockstate) {
        return false;
    }

    public boolean func_149686_d(IBlockState blockstate) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
        return iblockstate.isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP) || iblockstate.func_177230_c().canPlaceTorchOnTop(iblockstate, (IBlockAccess)worldIn, pos);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        this.dropPixie(worldIn, pos);
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.checkFall(world, pos);
    }

    private void checkFall(World worldIn, BlockPos pos) {
        if (!this.func_176196_c(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
            this.dropPixie(worldIn, pos);
        }
    }

    public void dropPixie(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityJar) {
            TileEntityJar jar = (TileEntityJar)te;
            if (jar.hasPixie) {
                jar.releasePixie();
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.jar_empty);
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(ModBlocks.jar_empty);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.empty) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityJar) {
            TileEntityJar jar = (TileEntityJar)te;
            if (jar.hasPixie && jar.hasProduced) {
                jar.hasProduced = false;
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack(ModItems.pixie_dust)));
                }
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, ModSounds.PIXIE_HURT, SoundCategory.NEUTRAL, 1.0f, 1.0f, false);
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityJar();
    }

    public static class ItemBlockJar
    extends ItemBlock {
        public ItemBlockJar(Block block) {
            super(block);
            this.field_77777_bU = 1;
            this.func_77627_a(true);
        }

        public String func_77667_c(ItemStack stack) {
            return "tile.iceandfire.jar_" + stack.func_77960_j();
        }

        @SideOnly(value=Side.CLIENT)
        public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
            if (this.func_194125_a(tab)) {
                for (int i = 0; i < 5; ++i) {
                    subItems.add((Object)new ItemStack((Item)this, 1, i));
                }
            }
        }

        public boolean placeBlockAt(ItemStack stack, EntityPlayer placer, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState blockState) {
            if (!world.func_180501_a(pos, blockState, 11)) {
                return false;
            }
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() == this.field_150939_a) {
                this.setBlockEntityTag(stack);
                ItemBlockJar.func_179224_a((World)world, (EntityPlayer)placer, (BlockPos)pos, (ItemStack)stack);
                if (placer instanceof EntityPlayerMP) {
                    CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)placer, pos, stack);
                }
            }
            return true;
        }

        private void setBlockEntityTag(ItemStack stack) {
            BlockJar blockJar = (BlockJar)this.field_150939_a;
            if (blockJar.empty) {
                return;
            }
            NBTTagCompound tagCompound = stack.func_190925_c("BlockEntityTag");
            tagCompound.func_74757_a("HasPixie", true);
            tagCompound.func_74768_a("PixieType", stack.func_77960_j());
        }
    }
}

