/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.block;

import com.github.alexthe666.iceandfire.IceAndFire;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockGenericSlab
extends BlockSlab {
    private final Block baseBlock;

    public BlockGenericSlab(String name, float hardness, float resistance, SoundType soundType, Material material, Block baseBlock) {
        super(material);
        this.baseBlock = baseBlock;
        this.func_149713_g(0);
        this.field_149783_u = true;
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.func_149672_a(soundType);
        if (this.func_176552_j()) {
            this.func_149663_c("iceandfire." + name + "_double");
            this.setRegistryName(name + "_double");
        } else {
            this.func_149663_c("iceandfire." + name);
            this.setRegistryName(name);
            this.func_149647_a(IceAndFire.TAB);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected static boolean isHalfSlab(IBlockState state) {
        return state.func_177230_c() instanceof BlockGenericSlab && !((BlockGenericSlab)state.func_177230_c()).func_176552_j();
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.getSlabItem();
    }

    protected abstract Item getSlabItem();

    public abstract ItemBlock getItemBlock();

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.getSlabItem());
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        if (!this.func_176552_j()) {
            return iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)(meta == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        }
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (!this.func_176552_j() && state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            i = 1;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return this.func_176552_j() ? super.func_180661_e() : new BlockStateContainer((Block)this, new IProperty[]{field_176554_a});
    }

    public String func_150002_b(int meta) {
        return super.func_149739_a();
    }

    public IProperty<?> func_176551_l() {
        return null;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return Variant.DEFAULT;
    }

    class GenericSlabBlockItem
    extends ItemBlock {
        private final BlockSlab singleSlab;
        private final BlockSlab doubleSlab;

        public GenericSlabBlockItem(Block block, BlockSlab singleSlab, BlockSlab doubleSlab) {
            super(block);
            this.singleSlab = singleSlab;
            this.doubleSlab = doubleSlab;
            this.func_77656_e(0);
            this.func_77627_a(true);
        }

        public int func_77647_b(int damage) {
            return damage;
        }

        public String func_77667_c(ItemStack stack) {
            return this.singleSlab.func_150002_b(stack.func_77960_j());
        }

        public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
            ItemStack stack = playerIn.func_184586_b(hand);
            if (stack.func_77973_b() == Item.func_150898_a((Block)this.doubleSlab)) {
                return EnumActionResult.SUCCESS;
            }
            if (stack.func_190916_E() != 0 && playerIn.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
                Comparable comparable = this.singleSlab.func_185674_a(stack);
                IBlockState iblockstate = worldIn.func_180495_p(pos);
                if (iblockstate.func_177230_c() == this.singleSlab) {
                    BlockSlab.EnumBlockHalf blockslab$enumblockhalf = (BlockSlab.EnumBlockHalf)iblockstate.func_177229_b((IProperty)BlockSlab.field_176554_a);
                    if (facing == EnumFacing.UP && blockslab$enumblockhalf == BlockSlab.EnumBlockHalf.BOTTOM || facing == EnumFacing.DOWN && blockslab$enumblockhalf == BlockSlab.EnumBlockHalf.TOP) {
                        IBlockState iblockstate1 = this.doubleSlab.func_176223_P();
                        AxisAlignedBB axisalignedbb = iblockstate1.func_185890_d((IBlockAccess)worldIn, pos);
                        if (axisalignedbb != Block.field_185506_k && worldIn.func_72855_b(axisalignedbb.func_186670_a(pos)) && worldIn.func_180501_a(pos, iblockstate1, 11)) {
                            SoundType soundtype = this.doubleSlab.getSoundType(iblockstate1, worldIn, pos, (Entity)playerIn);
                            worldIn.func_184133_a(playerIn, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                            stack.func_190918_g(1);
                        }
                        return EnumActionResult.SUCCESS;
                    }
                }
                return this.tryPlace(playerIn, stack, worldIn, pos.func_177972_a(facing), comparable) ? EnumActionResult.SUCCESS : super.func_180614_a(playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
            }
            return EnumActionResult.FAIL;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_179222_a(World worldIn, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
            IBlockState iblockstate1;
            BlockPos blockpos = pos;
            IBlockState iblockstate = worldIn.func_180495_p(pos);
            if (iblockstate.func_177230_c() == this.singleSlab) {
                boolean flag;
                boolean bl = flag = iblockstate.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP;
                if (side == EnumFacing.UP && !flag || side == EnumFacing.DOWN && flag) {
                    return true;
                }
            }
            return (iblockstate1 = worldIn.func_180495_p(pos = pos.func_177972_a(side))).func_177230_c() == this.singleSlab || super.func_179222_a(worldIn, blockpos, side, player, stack);
        }

        private boolean tryPlace(EntityPlayer player, ItemStack stack, World worldIn, BlockPos pos, Object itemSlabType) {
            IBlockState iblockstate = worldIn.func_180495_p(pos);
            if (iblockstate.func_177230_c() == this.singleSlab) {
                IBlockState iblockstate1 = this.doubleSlab.func_176223_P();
                AxisAlignedBB axisalignedbb = iblockstate1.func_185890_d((IBlockAccess)worldIn, pos);
                if (axisalignedbb != Block.field_185506_k && worldIn.func_72855_b(axisalignedbb.func_186670_a(pos)) && worldIn.func_180501_a(pos, iblockstate1, 11)) {
                    SoundType soundtype = this.doubleSlab.getSoundType(iblockstate1, worldIn, pos, (Entity)player);
                    worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    stack.func_190918_g(1);
                }
                return true;
            }
            return false;
        }
    }

    public static abstract class Half
    extends BlockGenericSlab {
        public Half(String name, float hardness, float resistance, SoundType soundType, Material material, Block baseBlock) {
            super(name, hardness, resistance, soundType, material, baseBlock);
        }

        public boolean func_176552_j() {
            return false;
        }
    }

    public static abstract class Double
    extends BlockGenericSlab {
        public Double(String name, float hardness, float resistance, SoundType soundType, Material material, Block baseBlock) {
            super(name, hardness, resistance, soundType, material, baseBlock);
        }

        public boolean func_176552_j() {
            return true;
        }
    }

    public static enum Variant implements IStringSerializable
    {
        DEFAULT;


        public String func_176610_l() {
            return "default";
        }
    }
}

