/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Configuration {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path file;
    private JsonObject root;

    public Configuration(Path file) {
        this.file = file;
        this.load();
    }

    public void load() {
        JsonObject root = null;
        if (Files.exists(this.file, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(this.file, StandardCharsets.UTF_8);){
                root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (root == null) {
            root = new JsonObject();
            root.addProperty("_header", "spark configuration file - https://spark.lucko.me/docs/Configuration");
        }
        this.root = root;
    }

    public void save() {
        try {
            Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.file, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson((JsonElement)this.root, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getString(String path, String def) {
        JsonElement el = this.root.get(path);
        if (el == null || !el.isJsonPrimitive()) {
            return def;
        }
        return el.getAsJsonPrimitive().getAsString();
    }

    public boolean getBoolean(String path, boolean def) {
        JsonElement el = this.root.get(path);
        if (el == null || !el.isJsonPrimitive()) {
            return def;
        }
        JsonPrimitive val = el.getAsJsonPrimitive();
        return val.isBoolean() ? val.getAsBoolean() : def;
    }

    public int getInteger(String path, int def) {
        JsonElement el = this.root.get(path);
        if (el == null || !el.isJsonPrimitive()) {
            return def;
        }
        JsonPrimitive val = el.getAsJsonPrimitive();
        return val.isNumber() ? val.getAsInt() : def;
    }

    public List<String> getStringList(String path) {
        JsonElement el = this.root.get(path);
        if (el == null || !el.isJsonArray()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (JsonElement child : el.getAsJsonArray()) {
            if (!child.isJsonPrimitive()) continue;
            list.add(child.getAsJsonPrimitive().getAsString());
        }
        return list;
    }

    public void setString(String path, String value) {
        this.root.add(path, (JsonElement)new JsonPrimitive(value));
    }

    public void setBoolean(String path, boolean value) {
        this.root.add(path, (JsonElement)new JsonPrimitive(Boolean.valueOf(value)));
    }

    public void setInteger(String path, int value) {
        this.root.add(path, (JsonElement)new JsonPrimitive((Number)value));
    }

    public void setStringList(String path, List<String> value) {
        JsonArray array = new JsonArray();
        for (String str : value) {
            array.add(str);
        }
        this.root.add(path, (JsonElement)array);
    }

    public boolean contains(String path) {
        return this.root.has(path);
    }

    public void remove(String path) {
        this.root.remove(path);
    }

    public String getOrSaveString(String path, String def) {
        if (!this.contains(path)) {
            this.setString(path, def);
            this.save();
        }
        return this.getString(path, def);
    }

    public boolean getOrSaveBoolean(String path, boolean def) {
        if (!this.contains(path)) {
            this.setBoolean(path, def);
            this.save();
        }
        return this.getBoolean(path, def);
    }

    public int getOrSaveInteger(String path, int def) {
        if (!this.contains(path)) {
            this.setInteger(path, def);
            this.save();
        }
        return this.getInteger(path, def);
    }
}

