/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.monitor.cpu;

import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import me.lucko.spark.common.monitor.MonitoringExecutor;
import me.lucko.spark.common.util.RollingAverage;

public enum CpuMonitor {

    private static final String OPERATING_SYSTEM_BEAN = "java.lang:type=OperatingSystem";
    private static final OperatingSystemMXBean BEAN;
    private static final RollingAverage SYSTEM_AVERAGE_10_SEC;
    private static final RollingAverage SYSTEM_AVERAGE_1_MIN;
    private static final RollingAverage SYSTEM_AVERAGE_15_MIN;
    private static final RollingAverage PROCESS_AVERAGE_10_SEC;
    private static final RollingAverage PROCESS_AVERAGE_1_MIN;
    private static final RollingAverage PROCESS_AVERAGE_15_MIN;

    public static void ensureMonitoring() {
    }

    public static double systemLoad() {
        return BEAN.getSystemCpuLoad();
    }

    public static double systemLoad10SecAvg() {
        return SYSTEM_AVERAGE_10_SEC.mean();
    }

    public static double systemLoad1MinAvg() {
        return SYSTEM_AVERAGE_1_MIN.mean();
    }

    public static double systemLoad15MinAvg() {
        return SYSTEM_AVERAGE_15_MIN.mean();
    }

    public static double processLoad() {
        return BEAN.getProcessCpuLoad();
    }

    public static double processLoad10SecAvg() {
        return PROCESS_AVERAGE_10_SEC.mean();
    }

    public static double processLoad1MinAvg() {
        return PROCESS_AVERAGE_1_MIN.mean();
    }

    public static double processLoad15MinAvg() {
        return PROCESS_AVERAGE_15_MIN.mean();
    }

    static /* synthetic */ RollingAverage access$100() {
        return SYSTEM_AVERAGE_10_SEC;
    }

    static /* synthetic */ RollingAverage access$200() {
        return SYSTEM_AVERAGE_1_MIN;
    }

    static /* synthetic */ RollingAverage access$300() {
        return SYSTEM_AVERAGE_15_MIN;
    }

    static /* synthetic */ RollingAverage access$400() {
        return PROCESS_AVERAGE_10_SEC;
    }

    static /* synthetic */ RollingAverage access$500() {
        return PROCESS_AVERAGE_1_MIN;
    }

    static /* synthetic */ RollingAverage access$600() {
        return PROCESS_AVERAGE_15_MIN;
    }

    static {
        SYSTEM_AVERAGE_10_SEC = new RollingAverage(10);
        SYSTEM_AVERAGE_1_MIN = new RollingAverage(60);
        SYSTEM_AVERAGE_15_MIN = new RollingAverage(900);
        PROCESS_AVERAGE_10_SEC = new RollingAverage(10);
        PROCESS_AVERAGE_1_MIN = new RollingAverage(60);
        PROCESS_AVERAGE_15_MIN = new RollingAverage(900);
        try {
            MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName diagnosticBeanName = ObjectName.getInstance(OPERATING_SYSTEM_BEAN);
            BEAN = JMX.newMXBeanProxy(beanServer, diagnosticBeanName, OperatingSystemMXBean.class);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("OperatingSystemMXBean is not supported by the system", e);
        }
        MonitoringExecutor.INSTANCE.scheduleAtFixedRate(new RollingAverageCollectionTask(), 1L, 1L, TimeUnit.SECONDS);
    }

    public static interface OperatingSystemMXBean {
        public double getSystemCpuLoad();

        public double getProcessCpuLoad();
    }

    private static final class RollingAverageCollectionTask
    implements Runnable {
        private final RollingAverage[] systemAverages = new RollingAverage[]{CpuMonitor.access$100(), CpuMonitor.access$200(), CpuMonitor.access$300()};
        private final RollingAverage[] processAverages = new RollingAverage[]{CpuMonitor.access$400(), CpuMonitor.access$500(), CpuMonitor.access$600()};

        private RollingAverageCollectionTask() {
        }

        @Override
        public void run() {
            BigDecimal systemCpuLoad = new BigDecimal(CpuMonitor.systemLoad());
            BigDecimal processCpuLoad = new BigDecimal(CpuMonitor.processLoad());
            if (systemCpuLoad.signum() != -1) {
                for (RollingAverage average : this.systemAverages) {
                    average.add(systemCpuLoad);
                }
            }
            if (processCpuLoad.signum() != -1) {
                for (RollingAverage average : this.processAverages) {
                    average.add(processCpuLoad);
                }
            }
        }
    }
}

