/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.nbt.tags;

import jaredbgreat.dldungeons.nbt.NBTType;
import jaredbgreat.dldungeons.nbt.tags.ITag;
import jaredbgreat.dldungeons.nbt.tags.Tags;
import jaredbgreat.dldungeons.util.parser.Tokenizer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTCompound
extends ITag {
    public final List<ITag> data = new ArrayList<ITag>();

    NBTCompound(String label, String name, String data) {
        super(label, name);
        this.parseData(data);
    }

    @Override
    public void write(NBTTagCompound in) {
        NBTTagCompound sub = in.func_74775_l(this.name);
        in.func_74782_a(this.name, (NBTBase)sub);
        for (ITag child : this.data) {
            child.write(sub);
        }
    }

    @Override
    public void write(NBTTagList in) {
        NBTTagCompound sub = new NBTTagCompound();
        for (ITag child : this.data) {
            child.write(sub);
        }
        in.func_74742_a((NBTBase)sub);
    }

    private void parseData(String in) {
        Tokenizer tokens = new Tokenizer(in, ",");
        while (tokens.hasMoreTokens()) {
            this.data.add(Tags.registry.get(tokens.nextToken()));
        }
    }

    @Override
    public NBTType getType() {
        return NBTType.COMPOUND;
    }
}

