/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.builder;

import jaredbgreat.dldungeons.api.DLDEvent;
import jaredbgreat.dldungeons.builder.AbstractBlock;
import jaredbgreat.dldungeons.util.debug.Logging;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class DBlock
extends AbstractBlock {
    protected IBlockState block;

    DBlock(IBlockState block) {
        this.block = block;
    }

    @Override
    @Deprecated
    public void placeNoMeta(World world, int x, int y, int z) {
        if (DBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (MinecraftForge.TERRAIN_GEN_BUS.post((Event)new DLDEvent.PlaceDBlock(world, pos, this))) {
            return;
        }
        world.func_175656_a(new BlockPos(x, y, z), this.block);
    }

    @Override
    public void place(World world, int x, int y, int z) {
        if (DBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (MinecraftForge.TERRAIN_GEN_BUS.post((Event)new DLDEvent.PlaceDBlock(world, pos, this))) {
            return;
        }
        world.func_175656_a(pos, this.block);
    }

    public boolean equals(Object other) {
        if (!(other instanceof DBlock)) {
            return false;
        }
        return this.block.equals(((DBlock)other).block);
    }

    public int hashCode() {
        return this.block.hashCode();
    }

    public static DBlock makeDBlock(String id) {
        try {
            StringTokenizer nums = new StringTokenizer(id, ":({[]})");
            String modid = nums.nextToken();
            ResourceLocation name = new ResourceLocation(modid + ":" + nums.nextToken());
            Block theBlock = (Block)GameRegistry.findRegistry(Block.class).getValue(name);
            if (theBlock == null) {
                String error = "[DLDUNGEONS] ERROR! Block read as \"" + id + "\" was was not in registry (returned null).";
                Logging.logError(error);
                throw new NoSuchElementException(error);
            }
            int meta = nums.hasMoreElements() ? Integer.parseInt(nums.nextToken()) : 0;
            return new DBlock(theBlock.func_176203_a(meta));
        }
        catch (NoSuchElementException ex) {
            throw new NoSuchElementException("Something was wrong with " + id + "; could not find all elements.");
        }
    }

    @Override
    public Object getContents() {
        return this.block;
    }
}

