/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dshuds.hud;

import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dshuds.Environment;
import org.orecruncher.dshuds.ModBase;
import org.orecruncher.dshuds.ModOptions;
import org.orecruncher.dshuds.hud.GuiOverlay;
import org.orecruncher.lib.ForgeUtils;
import org.orecruncher.lib.ItemStackUtil;
import org.orecruncher.lib.Localization;
import org.orecruncher.lib.MinecraftClock;
import org.orecruncher.lib.PlayerUtils;
import org.orecruncher.lib.gui.Panel;
import org.orecruncher.lib.gui.TextPanel;
import org.orecruncher.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public class CompassHUD
extends GuiOverlay {
    private static final int BAND_WIDTH = 65;
    private static final int BAND_HEIGHT = 12;
    private static final int ROSE_DIM = 256;
    private static final float TEXT_LINE_START = 1.5f;
    private static final Item COMPASS = ForgeUtils.getItem((String)"minecraft:compass");
    private static final Item CLOCK = ForgeUtils.getItem((String)"minecraft:clock");
    private static final Item SEASON_CLOCK = ForgeUtils.getItem((String)"sereneseasons:season_clock");
    private final TextPanel textPanel = new TextPanel();
    private boolean showCompass = false;

    @Nonnull
    protected String getLocationString() {
        BlockPos pos = Environment.getPlayerPosition();
        return TextFormatting.AQUA + String.format(Locale.getDefault(), ModOptions.compassHUD.coordFormat, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Nonnull
    protected String getBiomeName() {
        return TextFormatting.GOLD + Environment.getBiomeName();
    }

    protected boolean showCompass() {
        return ModOptions.compassHUD.enable && PlayerUtils.isHolding((EntityPlayer)Environment.getPlayer(), (Item)COMPASS);
    }

    protected static boolean holdingOrItemFrameItem(Item item) {
        if (item == null) {
            return false;
        }
        if (PlayerUtils.isHolding((EntityPlayer)Environment.getPlayer(), (Item)item)) {
            return true;
        }
        Entity e = PlayerUtils.entityImLookingAt((EntityPlayer)Environment.getPlayer());
        if (e instanceof EntityItemFrame) {
            ItemStack stack = ((EntityItemFrame)e).func_82335_i();
            return ItemStackUtil.isValidItemStack((ItemStack)stack) && stack.func_77973_b() == item;
        }
        return false;
    }

    protected boolean showClock() {
        return ModOptions.clockHUD.enable ? CompassHUD.holdingOrItemFrameItem(CLOCK) : false;
    }

    protected boolean showSeason() {
        return ModOptions.clockHUD.enable ? CompassHUD.holdingOrItemFrameItem(SEASON_CLOCK) : false;
    }

    @Override
    public void doTick(int tickRef) {
        if (tickRef != 0 && tickRef % 4 == 0) {
            this.textPanel.resetText();
            ArrayList<String> text = new ArrayList<String>();
            this.showCompass = this.showCompass();
            if (this.showCompass) {
                text.add(this.getLocationString());
                text.add(this.getBiomeName());
            }
            if (this.showSeason()) {
                text.add(Environment.getSeasonString());
            }
            if (this.showClock()) {
                if (text.size() > 0) {
                    text.add("");
                }
                MinecraftClock clock = Environment.getClock();
                text.add(clock.getFormattedTime());
                text.add(clock.getTimeOfDay());
                long time = ModBase.proxy().currentSessionDuration();
                int elapsedHours = (int)(time / 3600000L);
                int elapsedMinutes = (int)((time -= (long)(elapsedHours * 3600000)) / 60000L);
                int elapsedSeconds = (int)((time -= (long)(elapsedMinutes * 60000)) / 1000L);
                text.add(Localization.format((String)"dshuds.format.SessionTime", (Object[])new Object[]{elapsedHours, elapsedMinutes, elapsedSeconds}));
            }
            if (text.size() > 0) {
                this.textPanel.setText(text);
            }
        }
    }

    @Override
    public void doRender(@Nonnull RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS || !this.textPanel.hasText()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = mc.field_71466_p;
        ScaledResolution resolution = event.getResolution();
        int centerX = (resolution.func_78326_a() + 1) / 2;
        int centerY = (resolution.func_78328_b() + 1) / 2;
        this.textPanel.setAlpha(ModOptions.compassHUD.transparency);
        this.textPanel.render(centerX, centerY + (int)((float)font.field_78288_b * 1.5f), Panel.Reference.TOP_CENTER);
        Style style = Style.getStyle(ModOptions.compassHUD.style);
        mc.func_110434_K().func_110577_a(style.getTextureResource());
        if (this.showCompass) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)ModOptions.compassHUD.transparency);
            if (!style.isRose()) {
                int direction = MathStuff.floor((double)((double)(mc.field_71439_g.field_70177_z * 256.0f / 360.0f) + 0.5)) & 0xFF;
                int x = (resolution.func_78326_a() - style.getWidth() + 1) / 2;
                int y = (resolution.func_78328_b() - style.getHeight() + 1) / 2 - style.getHeight();
                if (direction < 128) {
                    this.func_73729_b(x, y, direction, ModOptions.compassHUD.style * (style.getHeight() * 2), style.getWidth(), style.getHeight());
                } else {
                    this.func_73729_b(x, y, direction - 128, ModOptions.compassHUD.style * (style.getHeight() * 2) + style.getHeight(), style.getWidth(), style.getHeight());
                }
            } else {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)centerX, (float)((float)centerY - 30.0f), (float)0.0f);
                GlStateManager.func_179114_b((float)70.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(-MathStuff.wrapDegrees((float)(mc.field_71439_g.field_70177_z + 180.0f))), (float)0.0f, (float)0.0f, (float)1.0f);
                int x = -(style.getWidth() + 1) / 2;
                int y = -(style.getHeight() + 1) / 2;
                this.func_73729_b(x, y, 0, 0, style.getWidth(), style.getHeight());
                GlStateManager.func_179121_F();
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static enum Style {
        BAND_0(false, "textures/compass.png", 65, 12),
        BAND_1(false, "textures/compass.png", 65, 12),
        BAND_2(false, "textures/compass.png", 65, 12),
        BAND_3(false, "textures/compass.png", 65, 12),
        ROSE_1(true, "textures/compassrose1.png", 256, 256),
        ROSE_2(true, "textures/compassrose2.png", 256, 256),
        ROSE_3(true, "textures/compassrose3.png", 256, 256);

        private final boolean isRose;
        private final ResourceLocation texture;
        private final int width;
        private final int height;

        private Style(boolean isRose, String texture, int w, int h) {
            this.isRose = isRose;
            this.texture = new ResourceLocation("dshuds", texture);
            this.width = w;
            this.height = h;
        }

        public boolean isRose() {
            return this.isRose;
        }

        public ResourceLocation getTextureResource() {
            return this.texture;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public static Style getStyle(int index) {
            if (index < 0 || index >= Style.values().length) {
                return BAND_0;
            }
            return Style.values()[index];
        }
    }
}

