/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.villages;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class TemporaryVillagerRegistry {
    protected static Field handlerField;
    protected static TemporaryVillagerRegistry INSTANCE;
    protected Set<VillagerRegistry.IVillageCreationHandler> registeredHandlers = new HashSet<VillagerRegistry.IVillageCreationHandler>();

    public static TemporaryVillagerRegistry instance() {
        return INSTANCE;
    }

    protected static Map<Class<?>, VillagerRegistry.IVillageCreationHandler> getMap() {
        if (handlerField == null) {
            handlerField = ReflectionHelper.findField(VillagerRegistry.class, (String[])new String[]{"villageCreationHandlers"});
        }
        try {
            return (Map)handlerField.get(VillagerRegistry.instance());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void register(VillagerRegistry.IVillageCreationHandler handler) {
        this.addToRegistry(handler);
        this.registeredHandlers.add(handler);
    }

    private void addToRegistry(VillagerRegistry.IVillageCreationHandler handler) {
        VillagerRegistry.instance().registerVillageCreationHandler(handler);
    }

    public void unregister(VillagerRegistry.IVillageCreationHandler handler) {
        this.removeFromRegistry(handler);
        this.registeredHandlers.remove(handler);
    }

    private void removeFromRegistry(VillagerRegistry.IVillageCreationHandler handler) {
        Map<Class<?>, VillagerRegistry.IVillageCreationHandler> map = TemporaryVillagerRegistry.getMap();
        if (map != null) {
            map.remove(handler.getComponentClass());
        }
    }

    public void setHandlers(Set<VillagerRegistry.IVillageCreationHandler> handlers) {
        Sets.difference(this.registeredHandlers, handlers).forEach(this::removeFromRegistry);
        Sets.difference(handlers, this.registeredHandlers).forEach(this::addToRegistry);
        this.registeredHandlers.clear();
        this.registeredHandlers.addAll(handlers);
    }

    static {
        INSTANCE = new TemporaryVillagerRegistry();
    }
}

