/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.transformers;

import ivorius.ivtoolkit.blocks.BlockPositions;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.blocks.IvTileEntityHelper;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.ivtoolkit.tools.NBTTagLists;
import ivorius.ivtoolkit.world.chunk.gen.StructureBoundingBoxes;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.block.GeneratingTileEntity;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.nbt.NBTStorable;
import ivorius.reccomplex.temp.RCMover;
import ivorius.reccomplex.temp.RCPosTransformer;
import ivorius.reccomplex.utils.UnstableBlock;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLiveContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLoadContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructurePrepareContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.RunTransformer;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.Transformer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class TransformerGenerationBehavior
extends Transformer<InstanceData> {
    public TransformerGenerationBehavior() {
        super("GenerationBehavior");
    }

    public static void asGeneratingTileEntity(@Nonnull StructureContext context, World world, int[] areaSize, BlockPos origin, NBTTagCompound tileEntityCompound, BiConsumer<BlockPos, GeneratingTileEntity> consumer) {
        BlockPos src = RCMover.getTileEntityPos(tileEntityCompound);
        BlockPos dest = context.transform.apply(src, areaSize).func_177971_a((Vec3i)origin);
        TileEntity tileEntity = RecurrentComplex.specialRegistry.loadTileEntity(world, tileEntityCompound = RCMover.setTileEntityPos(tileEntityCompound, dest));
        if (tileEntity instanceof GeneratingTileEntity) {
            RCPosTransformer.transformAdditionalData(tileEntity, context.transform, areaSize);
            RCMover.moveAdditionalData(tileEntity, origin);
            consumer.accept(src, (GeneratingTileEntity)tileEntity);
        }
    }

    @Override
    public void transform(InstanceData instanceData, Transformer.Phase phase, StructureSpawnContext context, IvWorldData worldData, RunTransformer transformer) {
        if (phase != Transformer.Phase.AFTER) {
            return;
        }
        BlockPos origin = context.lowerCoord();
        int[] areaSize = new int[]{worldData.blockCollection.width, worldData.blockCollection.height, worldData.blockCollection.length};
        WorldServer world = context.environment.world;
        if (context.generationLayer >= 30) {
            RecurrentComplex.logger.warn("Structure generated with over max layers; most likely infinite loop!");
            return;
        }
        for (NBTTagCompound tileEntityCompound : worldData.tileEntities) {
            TransformerGenerationBehavior.asGeneratingTileEntity(context, (World)world, areaSize, origin, tileEntityCompound, (blockPos, tileEntity) -> {
                NBTStorable teData = instanceData.tileEntities.get(blockPos);
                if (teData != null) {
                    tileEntity.generate(context, transformer, teData);
                }
            });
        }
    }

    @Override
    public String getDisplayString() {
        throw new IllegalStateException();
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        throw new IllegalStateException();
    }

    @Override
    public boolean skipGeneration(InstanceData instanceData, StructureLiveContext context, BlockPos pos, IBlockState state, IvWorldData worldData, BlockPos sourcePos) {
        return UnstableBlock.shouldSkipState(state) && !instanceData.allowedGTECoords.contains(sourcePos);
    }

    @Override
    public InstanceData prepareInstanceData(StructurePrepareContext context, IvWorldData worldData) {
        InstanceData instanceData = new InstanceData();
        int[] areaSize = new int[]{worldData.blockCollection.width, worldData.blockCollection.height, worldData.blockCollection.length};
        BlockPos origin = context.lowerCoord();
        worldData.tileEntities.forEach(tileEntityCompound -> TransformerGenerationBehavior.asGeneratingTileEntity(context, IvTileEntityHelper.getAnyWorld(), areaSize, origin, tileEntityCompound, (src, tileEntity) -> {
            NBTStorable tileEntityInstanceData = (NBTStorable)tileEntity.prepareInstanceData(context);
            if (tileEntityInstanceData != null) {
                instanceData.tileEntities.put((BlockPos)src, tileEntityInstanceData);
            }
            if (tileEntity.shouldPlaceInWorld(context, tileEntityInstanceData)) {
                instanceData.allowedGTECoords.add((BlockPos)src);
            }
        }));
        return instanceData;
    }

    @Override
    public InstanceData loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        throw new IllegalStateException();
    }

    public static class InstanceData
    implements NBTStorable {
        public static final String KEY_TILE_ENTITIES = "tileEntities";
        public final Map<BlockPos, NBTStorable> tileEntities = new HashMap<BlockPos, NBTStorable>();
        public final Set<BlockPos> allowedGTECoords = new HashSet<BlockPos>();

        protected static NBTBase getTileEntityTag(NBTTagCompound tileEntityCompound, BlockPos coord) {
            return tileEntityCompound.func_74781_a(InstanceData.getTileEntityKey(coord));
        }

        private static String getTileEntityKey(BlockPos coord) {
            return String.format("%d,%d,%d", coord.func_177958_n(), coord.func_177956_o(), coord.func_177952_p());
        }

        public void readFromNBT(StructureLoadContext context, NBTBase nbt, IvWorldData worldData) {
            IvBlockCollection blockCollection = worldData.blockCollection;
            NBTTagCompound compound = nbt instanceof NBTTagCompound ? (NBTTagCompound)nbt : new NBTTagCompound();
            int[] areaSize = new int[]{blockCollection.width, blockCollection.height, blockCollection.length};
            BlockPos origin = StructureBoundingBoxes.min((StructureBoundingBox)context.boundingBox);
            NBTTagCompound tileEntitiesCompound = compound.func_74775_l(KEY_TILE_ENTITIES);
            worldData.tileEntities.forEach(tileEntityCompound -> TransformerGenerationBehavior.asGeneratingTileEntity(context, IvTileEntityHelper.getAnyWorld(), areaSize, origin, tileEntityCompound, (src, tileEntity) -> this.tileEntities.put((BlockPos)src, (NBTStorable)tileEntity.loadInstanceData(context, InstanceData.getTileEntityTag(tileEntitiesCompound, src)))));
            this.allowedGTECoords.clear();
            this.allowedGTECoords.addAll(NBTTagLists.intArraysFrom((NBTTagCompound)compound, (String)"allowedCoords").stream().map(BlockPositions::fromIntArray).collect(Collectors.toSet()));
        }

        @Override
        public NBTBase writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            NBTTagCompound tileEntityCompound = new NBTTagCompound();
            for (Map.Entry<BlockPos, NBTStorable> entry : this.tileEntities.entrySet()) {
                tileEntityCompound.func_74782_a(InstanceData.getTileEntityKey(entry.getKey()), entry.getValue().writeToNBT());
            }
            compound.func_74782_a(KEY_TILE_ENTITIES, (NBTBase)tileEntityCompound);
            NBTTagLists.writeIntArraysTo((NBTTagCompound)compound, (String)"allowedGTECoords", this.allowedGTECoords.stream().map(BlockPositions::toIntArray).collect(Collectors.toList()));
            return compound;
        }
    }
}

