/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature;

import com.google.common.collect.Sets;
import ivorius.ivtoolkit.blocks.BlockSurfacePos;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.world.chunk.gen.StructureBoundingBoxes;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.events.RCEventBus;
import ivorius.reccomplex.events.StructureGenerationEvent;
import ivorius.reccomplex.events.StructureGenerationEventLite;
import ivorius.reccomplex.nbt.NBTStorable;
import ivorius.reccomplex.utils.RCAxisAlignedTransform;
import ivorius.reccomplex.utils.RCStructureBoundingBoxes;
import ivorius.reccomplex.world.gen.feature.RCWorldgenMonitor;
import ivorius.reccomplex.world.gen.feature.WorldStructureGenerationData;
import ivorius.reccomplex.world.gen.feature.structure.Environment;
import ivorius.reccomplex.world.gen.feature.structure.Placer;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.Structures;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLoadContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructurePrepareContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.GenerationType;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.StructurePlaceContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.RunTransformer;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.TransformerMulti;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class StructureGenerator<S extends NBTStorable> {
    public static final int MIN_DIST_TO_LIMIT = 1;
    public static final long PLACE_SEED = 1923419028309182309L;
    public static final long PREPARE_SEED = 2482039482903842269L;
    public static final long GENERATE_SEED = 2309842093742837432L;
    public static final long TRANSFORM_SEED = 1283901823092812394L;
    @Nullable
    private WorldServer world;
    @Nullable
    private Structure<S> structure;
    @Nullable
    private String structureID;
    @Nullable
    private BlockPos lowerCoord;
    @Nullable
    private BlockSurfacePos surfacePos;
    @Nullable
    private Placer placer;
    private boolean fromCenter;
    @Nullable
    private Environment environment;
    @Nullable
    private Long seed;
    @Nullable
    private AxisAlignedTransform2D transform;
    @Nullable
    private StructureBoundingBox boundingBox;
    @Nullable
    private StructureBoundingBox generationBB;
    @Nullable
    private Predicate<Vec3i> generationPredicate;
    private RunTransformer transformer;
    private String generationInfoID;
    private GenerationType generationType;
    private int generationLayer = 0;
    private boolean generateAsSource = false;
    private StructureSpawnContext.GenerateMaturity generateMaturity = StructureSpawnContext.GenerateMaturity.FIRST;
    @Nullable
    private S instanceData;
    @Nullable
    private NBTBase instanceDataNBT;
    private boolean allowOverlaps = false;
    private boolean memorize = true;
    private boolean partially;

    public StructureGenerator(Structure<S> structure) {
        this.structure(structure);
    }

    public StructureGenerator() {
    }

    @Nonnull
    public static Placer worldHeightPlacer() {
        return (context, blockCollection) -> context.environment.world.func_175645_m(RCStructureBoundingBoxes.getCenter(context.boundingBox)).func_177956_o();
    }

    public static String name(String structureName) {
        return structureName != null ? structureName : "Unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public GenerationResult generate() {
        Optional<S> optionalInstanceData;
        RCWorldgenMonitor.start("preparing " + this.structureID());
        try {
            optionalInstanceData = this.instanceData();
        }
        catch (Exception e) {
            GenerationResult.Failure failure = this.failGenerate(new GenerationResult.Failure.Exception(e));
            return failure;
        }
        finally {
            RCWorldgenMonitor.stop();
        }
        if (!optionalInstanceData.isPresent()) {
            return this.failGenerate(GenerationResult.Failure.placement);
        }
        NBTStorable instanceData = (NBTStorable)optionalInstanceData.get();
        StructureSpawnContext spawn = this.spawn().get();
        Structure<NBTStorable> structure = this.structure();
        String structureID = this.structureID();
        boolean firstTime = spawn.generateMaturity.isFirstTime();
        WorldServer world = spawn.environment.world;
        StructureBoundingBox boundingBox = spawn.boundingBox;
        if (this.maturity().isSuggest()) {
            if (boundingBox.field_78895_b < 1 || boundingBox.field_78894_e > world.func_72800_K() - 1 - 1) {
                return this.failGenerate(GenerationResult.Failure.outOfBounds);
            }
            if (RCConfig.avoidOverlappingGeneration && !this.allowOverlaps && !WorldStructureGenerationData.get((World)world).entriesAt(boundingBox).noneMatch(WorldStructureGenerationData.Entry::blocking)) {
                return this.failGenerate(GenerationResult.Failure.structureOverlap);
            }
            if (RCEventBus.INSTANCE.post((Event)new StructureGenerationEvent.Suggest(structure, spawn)) || structureID != null && MinecraftForge.EVENT_BUS.post((Event)new StructureGenerationEventLite.Suggest((World)world, structureID, boundingBox, spawn.generationLayer, firstTime))) {
                return this.failGenerate(GenerationResult.Failure.cancel);
            }
        }
        if (firstTime) {
            RCEventBus.INSTANCE.post((Event)new StructureGenerationEvent.Pre(structure, spawn));
            if (structureID != null) {
                MinecraftForge.EVENT_BUS.post((Event)new StructureGenerationEventLite.Pre((World)world, structureID, boundingBox, spawn.generationLayer, firstTime));
            }
        }
        RCWorldgenMonitor.start("generating " + this.structureID());
        try {
            structure.generate(spawn, instanceData, this.foreignTransformer());
        }
        catch (Exception e) {
            GenerationResult.Failure failure = this.failGenerate(new GenerationResult.Failure.Exception(e));
            return failure;
        }
        finally {
            RCWorldgenMonitor.stop();
        }
        if (!firstTime) {
            return GenerationResult.Success.complement;
        }
        RecurrentComplex.logger.trace(String.format("Generated structure '%s' in %s (%d)", StructureGenerator.name(structureID), boundingBox, world.field_73011_w.getDimension()));
        RCEventBus.INSTANCE.post((Event)new StructureGenerationEvent.Post(structure, spawn));
        if (structureID != null) {
            MinecraftForge.EVENT_BUS.post((Event)new StructureGenerationEventLite.Post((World)world, structureID, boundingBox, spawn.generationLayer, firstTime));
        }
        if (structureID == null || !this.memorize) {
            return GenerationResult.Success.contemporary;
        }
        String generationInfoID = this.generationType != null ? this.generationType.id() : null;
        WorldStructureGenerationData.StructureEntry structureEntry = WorldStructureGenerationData.StructureEntry.complete(structureID, generationInfoID, boundingBox, spawn.transform, !this.partially);
        structureEntry.blocking = structure.isBlocking();
        structureEntry.firstTime = false;
        structureEntry.seed = this.seed();
        try {
            structureEntry.instanceData = instanceData.writeToNBT();
        }
        catch (Exception e) {
            RecurrentComplex.logger.error(String.format("Error saving instance data for structure %s in %s", structure, boundingBox), (Throwable)e);
        }
        HashSet existingChunks = Sets.newHashSet(WorldStructureGenerationData.get((World)world).addEntry(structureEntry));
        if (this.partially) {
            this.maturity(StructureSpawnContext.GenerateMaturity.COMPLEMENT);
            StructureBoundingBox oldBB = this.generationBB;
            for (ChunkPos existingChunk : existingChunks) {
                this.generationBB(Structures.chunkBoundingBox(existingChunk, true));
                if (oldBB.func_78884_a(this.generationBB)) continue;
                RCWorldgenMonitor.start("pre-complementing " + this.structureID());
                structure.generate(this.spawn().get(), instanceData, RCConfig.getUniversalTransformer());
                RCWorldgenMonitor.stop();
            }
            this.generationBB(oldBB);
        }
        return new GenerationResult.Success.New(structureEntry);
    }

    @Nonnull
    public TransformerMulti foreignTransformer() {
        return this.transformer != null ? this.transformer.transformer : RCConfig.getUniversalTransformer();
    }

    @Nonnull
    protected GenerationResult.Failure failGenerate(@Nonnull GenerationResult.Failure failure) {
        if (RCConfig.logFailingStructure(this.structure)) {
            Optional<Integer> dim = Optional.ofNullable(this.world).map(w -> w.field_73011_w.getDimension());
            RecurrentComplex.logger.trace(String.format("Structure '%s' canceled generation at %s (%s): %s", this.structure, Optional.ofNullable(this.lowerCoord).map(Vec3i::toString).orElse(Optional.ofNullable(this.surfacePos).map(BlockSurfacePos::toString).orElse("unknown pos")), dim.map(String::valueOf).orElse("Unknown"), failure));
            if (failure instanceof GenerationResult.Failure.Exception) {
                RecurrentComplex.logger.error(String.format("Error on structure generation of '%s'.", this.structure), (Throwable)((GenerationResult.Failure.Exception)failure).exception);
            }
        }
        return failure;
    }

    public StructureGenerator<S> asChild(StructureSpawnContext context) {
        return this.environment(context.environment.child()).seed(context.random.nextLong()).transform(context.transform).generationBB(context.generationBB).generationPredicate(context.generationPredicate).generationLayer(context.generationLayer + 1).asSource(context.generateAsSource).maturity(context.generateMaturity.isFirstTime() ? StructureSpawnContext.GenerateMaturity.FIRST : StructureSpawnContext.GenerateMaturity.COMPLEMENT);
    }

    public StructureGenerator<S> world(@Nonnull WorldServer world) {
        this.world = world;
        return this;
    }

    @Nonnull
    public WorldServer world() {
        WorldServer world;
        Object object = this.world != null ? this.world : (world = this.environment != null ? this.environment.world : null);
        if (world == null) {
            throw new IllegalStateException("No world!");
        }
        return world;
    }

    public long seed() {
        return this.seed != null ? this.seed : (this.seed = Long.valueOf(this.world().field_73012_v.nextLong()));
    }

    public StructureGenerator<S> structure(@Nonnull Structure<S> structure) {
        this.structure = structure;
        return this;
    }

    public StructureGenerator<S> structureID(@Nonnull String structureID) {
        this.structureID = structureID;
        return this;
    }

    @Nonnull
    public Structure<S> structure() {
        Structure structure;
        Structure structure2 = this.structure != null ? this.structure : (structure = this.structureID != null ? (Structure)StructureRegistry.INSTANCE.get(this.structureID) : null);
        if (structure == null) {
            throw new IllegalStateException();
        }
        return structure;
    }

    @Nullable
    public String structureID() {
        return this.structureID != null ? this.structureID : (this.structure != null ? StructureRegistry.INSTANCE.id(this.structure) : null);
    }

    public StructureGenerator<S> lowerCoord(@Nonnull BlockPos lowerCoord) {
        this.lowerCoord = lowerCoord;
        return this;
    }

    @Nonnull
    public Optional<BlockPos> lowerCoord() {
        if (this.lowerCoord != null) {
            return Optional.of(this.lowerCoord);
        }
        return this.boundingBox().map(StructureBoundingBoxes::min);
    }

    public StructureGenerator<S> randomPosition(@Nonnull BlockSurfacePos surfacePos, @Nullable Placer placer) {
        this.surfacePos = surfacePos;
        this.placer = placer != null ? placer : StructureGenerator.worldHeightPlacer();
        return this;
    }

    public StructureGenerator<S> fromCenter(boolean fromCenter) {
        this.fromCenter = fromCenter;
        return this;
    }

    public StructureGenerator<S> environment(@Nonnull Environment environment) {
        this.environment = environment;
        return this;
    }

    @Nonnull
    public Environment environment() {
        return this.environment != null ? this.environment : Environment.inNature(this.world(), this.surfaceBoundingBox(), this.generationType != null ? this.generationType : (this.generationInfoID != null ? this.structure().generationType(this.generationInfoID) : null));
    }

    public StructureGenerator<S> seed(Long seed) {
        this.seed = seed;
        return this;
    }

    public StructureGenerator<S> transform(AxisAlignedTransform2D transform) {
        this.transform = transform;
        return this;
    }

    @Nonnull
    public AxisAlignedTransform2D transform() {
        AxisAlignedTransform2D transform;
        if (this.transform != null) {
            return this.transform;
        }
        Structure<S> structure = this.structure();
        Random random = new Random(this.seed() ^ 0x11D155E7DBEC6A6AL);
        this.transform = transform = AxisAlignedTransform2D.from((int)(structure.isRotatable() ? random.nextInt(4) : 0), (structure.isMirrorable() && random.nextBoolean() ? 1 : 0) != 0);
        return this.transform;
    }

    public StructureGenerator<S> boundingBox(@Nonnull StructureBoundingBox boundingBox) {
        this.boundingBox = boundingBox;
        return this;
    }

    public Optional<StructureBoundingBox> boundingBox() {
        return this.boundingBox(true);
    }

    @Nonnull
    public StructureBoundingBox surfaceBoundingBox() {
        return this.boundingBox(false).get();
    }

    @Nonnull
    protected Optional<StructureBoundingBox> boundingBox(boolean placed) {
        StructureBoundingBox boundingBox;
        StructureBoundingBox structureBoundingBox = boundingBox = this.boundingBox != null ? this.boundingBox : null;
        if (boundingBox == null) {
            int[] size = this.structureSize();
            if (this.lowerCoord != null) {
                boundingBox = Structures.boundingBox(this.fromCenter ? this.lowerCoord.func_177973_b(new Vec3i(size[0] / 2, 0, size[2] / 2)) : this.lowerCoord, size);
            } else if (this.surfacePos != null && this.placer != null) {
                boundingBox = Structures.boundingBox((this.fromCenter ? this.surfacePos.subtract(size[0] / 2, size[2] / 2) : this.surfacePos).blockPos(0), size);
                if (placed) {
                    RCWorldgenMonitor.start("placing " + this.structureID());
                    int y = this.placer.place(this.place(), this.structure().blockCollection());
                    RCWorldgenMonitor.stop();
                    if (y < 0) {
                        return Optional.empty();
                    }
                    boundingBox.field_78895_b += y;
                    boundingBox.field_78894_e += y;
                }
            } else {
                throw new IllegalStateException("No place!");
            }
            if (placed) {
                this.boundingBox = boundingBox;
            }
        }
        return Optional.of(boundingBox);
    }

    public int[] structureSize() {
        return RCAxisAlignedTransform.applySize(this.transform(), this.structure().size());
    }

    @Nullable
    public StructureBoundingBox generationBB() {
        return this.generationBB;
    }

    public StructureGenerator<S> generationBB(@Nullable StructureBoundingBox generationBB) {
        this.generationBB = generationBB;
        return this;
    }

    @Nullable
    public Predicate<Vec3i> generationPredicate() {
        return this.generationPredicate;
    }

    public StructureGenerator<S> generationPredicate(@Nullable Predicate<Vec3i> generationPredicate) {
        this.generationPredicate = generationPredicate;
        return this;
    }

    public RunTransformer transformer() {
        return this.transformer;
    }

    public StructureGenerator<S> transformer(RunTransformer transformer) {
        this.transformer = transformer;
        return this;
    }

    public StructureGenerator<S> generationInfo(@Nullable GenerationType generationType) {
        this.generationType = generationType;
        return this;
    }

    public StructureGenerator<S> generationInfo(@Nullable String generationInfo) {
        this.generationInfoID = generationInfo;
        return this;
    }

    public StructureGenerator<S> generationLayer(int generationLayer) {
        this.generationLayer = generationLayer;
        return this;
    }

    public StructureGenerator<S> asSource(boolean generateAsSource) {
        this.generateAsSource = generateAsSource;
        return this;
    }

    public StructureGenerator<S> maturity(StructureSpawnContext.GenerateMaturity generateMaturity) {
        this.generateMaturity = generateMaturity;
        return this;
    }

    public StructureSpawnContext.GenerateMaturity maturity() {
        return this.generateMaturity;
    }

    public StructureGenerator<S> instanceData(S s) {
        this.instanceData = s;
        return this;
    }

    public StructureGenerator<S> instanceData(NBTBase nbt) {
        this.instanceDataNBT = nbt;
        return this;
    }

    @Nonnull
    public Optional<S> instanceData() {
        return this.instanceData != null ? Optional.of(this.instanceData) : (this.instanceDataNBT != null ? this.load().map(load -> this.structure().loadInstanceData((StructureLoadContext)load, this.instanceDataNBT, this.foreignTransformer())) : this.prepare().flatMap(prepare -> {
            RCWorldgenMonitor.start("preparing " + this.structureID());
            try {
                Optional<S> optional = Optional.ofNullable(this.structure().prepareInstanceData((StructurePrepareContext)prepare, this.foreignTransformer()));
                return optional;
            }
            catch (Exception e) {
                if (e instanceof ExpectedException && ((ExpectedException)((Object)e)).isExpected()) {
                    RecurrentComplex.logger.error(String.format("Error preparing structure: %s, Cause: %s", this.structure(), e.getMessage()));
                } else {
                    RecurrentComplex.logger.error("Error preparing structure: " + this.structure(), (Throwable)e);
                }
            }
            finally {
                RCWorldgenMonitor.stop();
            }
            return Optional.empty();
        }));
    }

    public StructureGenerator<S> memorize(boolean memorize) {
        this.memorize = memorize;
        return this;
    }

    public StructureGenerator<S> partially(boolean partially, ChunkPos pos) {
        this.partially = partially;
        this.generationBB(partially ? Structures.chunkBoundingBox(pos, true) : null);
        return this;
    }

    public StructureGenerator<S> allowOverlaps(boolean allowOverlaps) {
        this.allowOverlaps = allowOverlaps;
        return this;
    }

    @Nonnull
    public StructurePlaceContext place() {
        return new StructurePlaceContext(new Random(this.seed() ^ 0x1AB15B6A60988765L), this.environment(), this.transform(), this.surfaceBoundingBox());
    }

    @Nonnull
    public Optional<StructurePrepareContext> prepare() {
        return this.boundingBox().map(bb -> new StructurePrepareContext(this.transform(), (StructureBoundingBox)bb, this.generateAsSource, this.environment(), new Random(this.seed() ^ 0x2271F9C260FA4DDDL), this.generateMaturity));
    }

    @Nonnull
    public Optional<StructureLoadContext> load() {
        return this.boundingBox().map(bb -> new StructureLoadContext(this.transform(), (StructureBoundingBox)bb, this.generateAsSource));
    }

    @Nonnull
    public Optional<StructureSpawnContext> spawn() {
        return this.boundingBox().map(bb -> new StructureSpawnContext(this.environment(), new Random(this.seed() ^ 0x200E35256CC94EB8L), this.transform(), (StructureBoundingBox)bb, this.generationBB, this.generationPredicate, this.generationLayer, this.generateAsSource, this.generateMaturity));
    }

    public static class GenerationResult {
        public boolean succeeded() {
            return false;
        }

        public static class Failure
        extends GenerationResult {
            public static Failure placement = new Failure("No suitable place");
            public static Failure structureOverlap = new Failure("Overlapping Structure");
            public static Failure outOfBounds = new Failure("Out of Bounds");
            public static Failure cancel = new Failure("Cancelled for Other Reasons");
            public final String description;

            public Failure(String description) {
                this.description = description;
            }

            public static class Exception
            extends Failure {
                public final java.lang.Exception exception;

                public Exception(java.lang.Exception exception) {
                    super("Error during generation");
                    this.exception = exception;
                }
            }
        }

        public static class Success
        extends GenerationResult {
            public static Success complement = new Success();
            public static Success contemporary = new Success();

            @Override
            public boolean succeeded() {
                return true;
            }

            public static class New
            extends Success {
                public final WorldStructureGenerationData.StructureEntry sight;

                public New(WorldStructureGenerationData.StructureEntry sight) {
                    this.sight = sight;
                }
            }
        }
    }

    public static interface ExpectedException {
        public boolean isExpected();
    }
}

