/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils;

import gnu.trove.map.hash.TFloatObjectHashMap;
import ivorius.reccomplex.utils.PrecedenceSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

public class PrecedenceSets {
    public static <T extends PrecedenceSet.NativeEntry> void add(Collection<PrecedenceSet<T>> collection, T t) {
        PrecedenceSets.add(collection, t, t.getPrecedence());
    }

    public static <T> void add(Collection<PrecedenceSet<T>> collection, T t, float precedence) {
        for (PrecedenceSet<T> set : collection) {
            if (set.precedence != precedence) continue;
            set.getSet().add(t);
            return;
        }
        collection.add(new PrecedenceSet<T>(precedence, new HashSet<T>(Collections.singleton(t))));
    }

    public static <T extends PrecedenceSet.NativeEntry> Set<PrecedenceSet<T>> group(Collection<T> ts) {
        TFloatObjectHashMap map = new TFloatObjectHashMap();
        for (PrecedenceSet.NativeEntry t : ts) {
            float precedence = t.getPrecedence();
            PrecedenceSet precedenceSet = (PrecedenceSet)map.get(precedence);
            if (precedenceSet == null) {
                precedenceSet = new PrecedenceSet(precedence, new HashSet());
                map.put(precedence, precedenceSet);
            }
            precedenceSet.getSet().add(t);
        }
        return new HashSet<PrecedenceSet<T>>(map.valueCollection());
    }

    public static <T> Set<PrecedenceSet<T>> group(Collection<T> ts, Function<T, Float> mapper) {
        TFloatObjectHashMap map = new TFloatObjectHashMap();
        for (T t : ts) {
            float precedence = mapper.apply(t).floatValue();
            PrecedenceSet precedenceSet = (PrecedenceSet)map.get(precedence);
            if (precedenceSet == null) {
                precedenceSet = new PrecedenceSet(precedence, new HashSet());
                map.put(precedence, precedenceSet);
            }
            precedenceSet.getSet().add(t);
        }
        return new HashSet<PrecedenceSet<T>>(map.valueCollection());
    }
}

