/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.operation;

import ivorius.ivtoolkit.blocks.BlockPositions;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.rendering.grid.GridQuadCache;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.client.rendering.OperationRenderer;
import ivorius.reccomplex.client.rendering.SchematicQuadCache;
import ivorius.reccomplex.operation.Operation;
import ivorius.reccomplex.utils.RCAxisAlignedTransform;
import ivorius.reccomplex.world.gen.feature.structure.schematics.SchematicFile;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OperationGenerateSchematic
implements Operation {
    public SchematicFile file;
    public AxisAlignedTransform2D transform;
    public BlockPos lowerCoord;
    protected GridQuadCache cachedShapeGrid;

    public OperationGenerateSchematic() {
    }

    public OperationGenerateSchematic(SchematicFile file, AxisAlignedTransform2D transform, BlockPos lowerCoord) {
        this.file = file;
        this.transform = transform;
        this.lowerCoord = lowerCoord;
    }

    @Override
    public void perform(WorldServer world) {
        if (this.lowerCoord != null) {
            this.file.generate((World)world, this.lowerCoord, this.transform);
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagCompound fileCompound = new NBTTagCompound();
        this.file.writeToNBT(fileCompound);
        compound.func_74782_a("schematic", (NBTBase)fileCompound);
        RCAxisAlignedTransform.write(compound, this.transform, "rotation", "mirrorX");
        BlockPositions.writeToNBT((String)"lowerCoord", (BlockPos)this.lowerCoord, (NBTTagCompound)compound);
    }

    public void readFromNBT(NBTTagCompound compound) {
        try {
            this.file = new SchematicFile(compound.func_74775_l("schematic"));
        }
        catch (SchematicFile.UnsupportedSchematicFormatException e) {
            RecurrentComplex.logger.error((Object)e);
            this.file = new SchematicFile(0, 0, 0);
        }
        this.transform = RCAxisAlignedTransform.read(compound, "rotation", "mirrorX");
        this.lowerCoord = BlockPositions.readFromNBT((String)"lowerCoord", (NBTTagCompound)compound);
    }

    public void invalidateCache() {
        this.cachedShapeGrid = null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPreview(Operation.PreviewType previewType, World world, int ticks, float partialTicks) {
        if (this.lowerCoord != null) {
            int[] size = new int[]{this.file.width, this.file.height, this.file.length};
            if (previewType == Operation.PreviewType.SHAPE) {
                GlStateManager.func_179124_c((float)0.8f, (float)0.75f, (float)1.0f);
                OperationRenderer.renderGridQuadCache(this.cachedShapeGrid != null ? this.cachedShapeGrid : (this.cachedShapeGrid = SchematicQuadCache.createQuadCache(this.file, new float[]{1.0f, 1.0f, 1.0f})), this.transform, this.lowerCoord, ticks, partialTicks);
            }
            if (previewType == Operation.PreviewType.BOUNDING_BOX || previewType == Operation.PreviewType.SHAPE) {
                OperationRenderer.renderBoundingBox(OperationRenderer.blockAreaFromSize(this.lowerCoord, RCAxisAlignedTransform.applySize(this.transform, size)), ticks, partialTicks);
            }
        }
    }
}

