/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.loot;

import ivorius.reccomplex.gui.InventoryWatcher;
import ivorius.reccomplex.world.storage.loot.WeightedRandomChestContent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class InventoryGenericLootGen
implements IInventory {
    public List<WeightedRandomChestContent> chestContents;
    private List<ItemStack> cachedItemStacks = new ArrayList<ItemStack>();
    private List<InventoryWatcher> watchers = new ArrayList<InventoryWatcher>();

    public InventoryGenericLootGen(List<WeightedRandomChestContent> chestContents) {
        this.chestContents = chestContents;
        this.buildCachedStacks();
    }

    public void addWatcher(InventoryWatcher watcher) {
        this.watchers.add(watcher);
    }

    public void removeWatcher(InventoryWatcher watcher) {
        this.watchers.remove(watcher);
    }

    public List<InventoryWatcher> watchers() {
        return Collections.unmodifiableList(this.watchers);
    }

    public int func_70302_i_() {
        return this.cachedItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.cachedItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int var1) {
        return var1 < this.cachedItemStacks.size() ? this.cachedItemStacks.get(var1) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int var1, int var2) {
        int stackIndex = var1 / 2;
        if (stackIndex < this.chestContents.size()) {
            WeightedRandomChestContent chestContent = this.chestContents.get(stackIndex);
            if (var1 % 2 == 0) {
                chestContent.minStackSize -= var2;
            } else {
                chestContent.maxStackSize -= var2;
            }
            InventoryGenericLootGen.validateMinMax(chestContent);
            ItemStack returnStack = this.cachedItemStacks.get(var1).func_77979_a(var2);
            this.markDirtyFromLootGenerator();
            return returnStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int var1, ItemStack var2) {
        int stackIndex = var1 / 2;
        if (stackIndex < this.chestContents.size()) {
            if (!var2.func_190926_b()) {
                WeightedRandomChestContent chestContent = this.chestContents.get(stackIndex);
                chestContent.theItemId = var2;
                if (var1 % 2 == 0) {
                    chestContent.minStackSize = var2.func_190916_E();
                } else {
                    chestContent.maxStackSize = var2.func_190916_E();
                }
                InventoryGenericLootGen.validateMinMax(chestContent);
            } else {
                this.chestContents.remove(stackIndex);
            }
        } else if (!var2.func_190926_b()) {
            int min = var1 % 2 == 0 ? var2.func_190916_E() : 1;
            int max = var1 % 2 == 1 ? var2.func_190916_E() : var2.func_77976_d();
            WeightedRandomChestContent weightedRandomChestContent = new WeightedRandomChestContent(var2, min, max, 100);
            this.chestContents.add(weightedRandomChestContent);
        }
        this.markDirtyFromLootGenerator();
    }

    private static void validateMinMax(WeightedRandomChestContent chestContent) {
        if (chestContent.maxStackSize < chestContent.minStackSize) {
            int tmp = chestContent.maxStackSize;
            chestContent.maxStackSize = chestContent.minStackSize;
            chestContent.minStackSize = tmp;
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.calculateMinMax();
        this.buildCachedStacks();
        for (InventoryWatcher watcher : this.watchers) {
            watcher.inventoryChanged(this);
        }
    }

    public void markDirtyFromLootGenerator() {
        this.buildCachedStacks();
        for (InventoryWatcher watcher : this.watchers) {
            watcher.inventoryChanged(this);
        }
    }

    private void calculateMinMax() {
        for (int i = 0; i < this.cachedItemStacks.size(); ++i) {
            ItemStack stack = this.cachedItemStacks.get(i);
            int stackIndex = i / 2;
            if (stackIndex >= this.chestContents.size()) continue;
            WeightedRandomChestContent chestContent = this.chestContents.get(stackIndex);
            if (i % 2 == 0) {
                chestContent.minStackSize = stack.func_190916_E();
                continue;
            }
            chestContent.maxStackSize = stack.func_190916_E();
        }
        this.chestContents.forEach(InventoryGenericLootGen::validateMinMax);
    }

    private void buildCachedStacks() {
        this.cachedItemStacks.clear();
        for (WeightedRandomChestContent chestContent : this.chestContents) {
            ItemStack stackLow = chestContent.theItemId.func_77946_l();
            stackLow.func_190920_e(chestContent.minStackSize);
            ItemStack stackHigh = chestContent.theItemId.func_77946_l();
            stackHigh.func_190920_e(chestContent.maxStackSize);
            this.cachedItemStacks.add(stackLow);
            this.cachedItemStacks.add(stackHigh);
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }
}

