/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.guidebook.gui;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.gui.TexturedButton;
import net.silentchaos512.lib.guidebook.GuideBook;
import net.silentchaos512.lib.guidebook.IGuideChapter;
import net.silentchaos512.lib.guidebook.IGuidePage;
import net.silentchaos512.lib.guidebook.gui.GuiGuide;
import net.silentchaos512.lib.guidebook.internal.GuiGuideBase;
import net.silentchaos512.lib.guidebook.misc.GuideBookUtils;
import net.silentchaos512.lib.guidebook.page.ItemDisplay;

@SideOnly(value=Side.CLIENT)
public class GuiPage
extends GuiGuide {
    public final IGuidePage[] pages = new IGuidePage[2];
    private final List<ItemDisplay> itemDisplays = new ArrayList<ItemDisplay>();
    private int pageTimer;
    private GuiButton buttonViewOnline;

    public GuiPage(GuideBook book, GuiScreen previousScreen, GuiGuideBase parentPage, IGuidePage page1, IGuidePage page2) {
        super(book, previousScreen, parentPage);
        this.pages[0] = page1;
        this.pages[1] = page2;
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (ItemDisplay display : this.itemDisplays) {
            display.onMousePress(this.book, mouseButton, mouseX, mouseY);
        }
        for (IGuidePage page : this.pages) {
            if (page == null) continue;
            page.mouseClicked(this, mouseX, mouseY, mouseButton);
        }
    }

    public void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        for (IGuidePage page : this.pages) {
            if (page == null) continue;
            page.mouseReleased(this, mouseX, mouseY, state);
        }
    }

    public void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        for (IGuidePage page : this.pages) {
            if (page == null) continue;
            page.mouseClickMove(this, mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        }
    }

    @Override
    public void func_146284_a(GuiButton button) throws IOException {
        block5: {
            block4: {
                if (button != this.buttonViewOnline) break block4;
                List<String> links = this.getWebLinks();
                if (!Desktop.isDesktopSupported()) break block5;
                for (String link : links) {
                    try {
                        Desktop.getDesktop().browse(new URI(link));
                    }
                    catch (Exception e) {
                        SilentLib.LOGGER.warn("Couldn't open website from guide book page!");
                        e.printStackTrace();
                    }
                }
                break block5;
            }
            super.func_146284_a(button);
            for (IGuidePage page : this.pages) {
                if (page == null) continue;
                page.actionPerformed(this, button);
            }
        }
    }

    @Override
    public void func_73866_w_() {
        this.itemDisplays.clear();
        super.func_73866_w_();
        List<String> links = this.getWebLinks();
        if (links != null && !links.isEmpty()) {
            this.buttonViewOnline = new TexturedButton(this.book.getResourceGadgets(), -782822, this.guiLeft + this.xSize - 24, this.guiTop + this.ySize - 25, 0, 172, 16, 16, Collections.singletonList(TextFormatting.GOLD + this.book.i18n.translate("guide", "onlineButton.name", new Object[0])));
            this.field_146292_n.add(this.buttonViewOnline);
        }
        for (int i = 0; i < this.pages.length; ++i) {
            IGuidePage page = this.pages[i];
            if (page == null) continue;
            page.initGui(this, this.guiLeft + 6 + i * 142, this.guiTop + 7);
        }
    }

    private List<String> getWebLinks() {
        ArrayList<String> links = new ArrayList<String>();
        return links;
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        for (int i = 0; i < this.pages.length; ++i) {
            IGuidePage page = this.pages[i];
            if (page == null) continue;
            page.updateScreen(this, this.guiLeft + 6 + i * 142, this.guiTop + 7, this.pageTimer);
        }
        ++this.pageTimer;
    }

    @Override
    public void drawScreenPre(int mouseX, int mouseY, float partialTicks) {
        super.drawScreenPre(mouseX, mouseY, partialTicks);
        if (this.pages[0] != null) {
            IGuideChapter chapter = this.pages[0].getChapter();
            String name = chapter.getLocalizedName();
            this.field_146289_q.func_175065_a(name, (float)(this.guiLeft + this.xSize / 2 - this.field_146289_q.func_78256_a(name) / 2), (float)(this.guiTop - 1), 0xFFFFFF, true);
        }
        for (int i = 0; i < this.pages.length; ++i) {
            IGuidePage page = this.pages[i];
            if (page == null) continue;
            IGuideChapter chapter = this.pages[i].getChapter();
            String pageStrg = "Page " + (chapter.getPageIndex(this.pages[i]) + 1) + "/" + chapter.getAllPages().length;
            this.renderScaledAsciiString(pageStrg, this.guiLeft + 25 + i * 136, this.guiTop + this.ySize - 7, 0xFFFFFF, false, this.getLargeFontSize());
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            page.drawScreenPre(this, this.guiLeft + 6 + i * 142, this.guiTop + 7, mouseX, mouseY, partialTicks);
        }
        for (ItemDisplay display : this.itemDisplays) {
            display.drawPre(this.book);
        }
    }

    @Override
    public void drawScreenPost(int mouseX, int mouseY, float partialTicks) {
        super.drawScreenPost(mouseX, mouseY, partialTicks);
        for (int i = 0; i < this.pages.length; ++i) {
            IGuidePage page = this.pages[i];
            if (page == null) continue;
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            page.drawScreenPost(this, this.guiLeft + 6 + i * 142, this.guiTop + 7, mouseX, mouseY, partialTicks);
        }
        for (ItemDisplay display : this.itemDisplays) {
            display.drawPost(this.book, mouseX, mouseY);
        }
    }

    @Override
    public void addOrModifyItemRenderer(ItemStack renderedStack, int x, int y, float scale, boolean shouldTryTransfer) {
        for (ItemDisplay display : this.itemDisplays) {
            if (display.x != x || display.y != y || display.scale != scale) continue;
            display.stack = renderedStack;
            return;
        }
        this.itemDisplays.add(new ItemDisplay(this.book, this, x, y, scale, renderedStack, shouldTryTransfer));
    }

    @Override
    public boolean hasPageLeftButton() {
        IGuideChapter chapter;
        IGuidePage page = this.pages[0];
        if (page != null && (chapter = page.getChapter()) != null) {
            return chapter.getPageIndex(page) > 0;
        }
        return false;
    }

    @Override
    public void onPageLeftButtonPressed() {
        IGuideChapter chapter;
        IGuidePage page = this.pages[0];
        if (page != null && (chapter = page.getChapter()) != null) {
            IGuidePage[] pages = chapter.getAllPages();
            int pageNumToOpen = chapter.getPageIndex(page) - 1;
            if (pageNumToOpen >= 0 && pageNumToOpen < pages.length) {
                this.field_146297_k.func_147108_a((GuiScreen)GuideBookUtils.createPageGui(this.book, this.previousScreen, this.parentPage, pages[pageNumToOpen]));
            }
        }
    }

    @Override
    public boolean hasPageRightButton() {
        IGuideChapter chapter;
        IGuidePage page = this.pages[1];
        if (page != null && (chapter = page.getChapter()) != null) {
            int pageAmount;
            int pageIndex = chapter.getPageIndex(page);
            return pageIndex + 1 < (pageAmount = chapter.getAllPages().length);
        }
        return false;
    }

    @Override
    public void onPageRightButtonPressed() {
        IGuideChapter chapter;
        IGuidePage page = this.pages[1];
        if (page != null && (chapter = page.getChapter()) != null) {
            IGuidePage[] pages = chapter.getAllPages();
            int pageNumToOpen = chapter.getPageIndex(page) + 1;
            if (pageNumToOpen >= 0 && pageNumToOpen < pages.length) {
                this.field_146297_k.func_147108_a((GuiScreen)GuideBookUtils.createPageGui(this.book, this.previousScreen, this.parentPage, pages[pageNumToOpen]));
            }
        }
    }

    @Override
    public boolean hasBackButton() {
        return true;
    }

    @Override
    public void onBackButtonPressed() {
        if (!GuiPage.func_146272_n()) {
            this.field_146297_k.func_147108_a((GuiScreen)this.parentPage);
        } else {
            super.onBackButtonPressed();
        }
    }
}

