/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.guidebook.gui;

import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.lib.guidebook.GuideBook;
import net.silentchaos512.lib.guidebook.IGuideChapter;
import net.silentchaos512.lib.guidebook.IGuideEntry;
import net.silentchaos512.lib.guidebook.IGuidePage;
import net.silentchaos512.lib.guidebook.button.EntryButton;
import net.silentchaos512.lib.guidebook.gui.GuiGuide;
import net.silentchaos512.lib.guidebook.internal.GuiGuideBase;
import net.silentchaos512.lib.guidebook.misc.GuideBookUtils;

@SideOnly(value=Side.CLIENT)
public class GuiEntry
extends GuiGuide {
    private final int entryPage;
    private final int pageAmount;
    private final IGuideEntry entry;
    private final List<IGuideChapter> chapters;
    private final String searchText;
    private final boolean focusSearch;
    protected GuideBook book;

    public GuiEntry(GuideBook book, GuiScreen previousScreen, GuiGuideBase parentPage, IGuideEntry entry, int entryPage, String search, boolean focusSearch) {
        super(book, previousScreen, parentPage);
        IGuideChapter lastChap;
        this.entryPage = entryPage;
        this.entry = entry;
        this.searchText = search;
        this.focusSearch = focusSearch;
        this.chapters = entry.getChaptersForDisplay(search);
        this.pageAmount = !this.chapters.isEmpty() ? ((lastChap = this.chapters.get(this.chapters.size() - 1)) == null ? 1 : GuiEntry.calcEntryPage(this.entry, lastChap, this.searchText) + 1) : 1;
    }

    public GuiEntry(GuideBook book, GuiScreen previousScreen, GuiGuideBase parentPage, IGuideEntry entry, IGuideChapter chapterForPageCalc, String search, boolean focusSearch) {
        this(book, previousScreen, parentPage, entry, GuiEntry.calcEntryPage(entry, chapterForPageCalc, search), search, focusSearch);
    }

    private static int calcEntryPage(IGuideEntry entry, IGuideChapter chapterForPageCalc, String search) {
        int index = entry.getChaptersForDisplay(search).indexOf(chapterForPageCalc);
        return index / 24;
    }

    @Override
    public void drawScreenPre(int mouseX, int mouseY, float partialTicks) {
        super.drawScreenPre(mouseX, mouseY, partialTicks);
        String name = this.entry.getLocalizedName();
        this.field_146289_q.func_175065_a(name, (float)(this.guiLeft + this.xSize / 2 - this.field_146289_q.func_78256_a(name) / 2), (float)(this.guiTop - 1), 0xFFFFFF, true);
        for (int i = 0; i < 2; ++i) {
            String pageStrg = "Page " + (this.entryPage * 2 + i + 1) + "/" + this.pageAmount * 2;
            this.renderScaledAsciiString(pageStrg, this.guiLeft + 25 + i * 136, this.guiTop + this.ySize - 7, 0xFFFFFF, false, this.getLargeFontSize());
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.hasSearchBar() && this.searchText != null) {
            this.searchField.func_146180_a(this.searchText);
            if (this.focusSearch) {
                this.searchField.func_146195_b(true);
            }
        }
        int idOffset = this.entryPage * 24;
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 12; ++y) {
                int id = y + x * 12;
                if (this.chapters.size() <= id + idOffset) {
                    return;
                }
                IGuideChapter chapter = this.chapters.get(id + idOffset);
                this.field_146292_n.add(new EntryButton(this, id, this.guiLeft + 14 + x * 142, this.guiTop + 11 + y * 13, 115, 10, chapter.getLocalizedNameWithFormatting(), chapter.getDisplayItemStack()));
            }
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof EntryButton) {
            IGuidePage[] pages;
            IGuideChapter chapter;
            int actualId = button.field_146127_k + this.entryPage * 24;
            if (this.chapters.size() > actualId && (chapter = this.chapters.get(actualId)) != null && (pages = chapter.getAllPages()) != null && pages.length > 0) {
                this.field_146297_k.func_147108_a((GuiScreen)GuideBookUtils.createPageGui(this.book, this.previousScreen, this, pages[0]));
            }
        } else {
            super.func_146284_a(button);
        }
    }

    @Override
    public void addOrModifyItemRenderer(ItemStack renderedStack, int x, int y, float scale, boolean shouldTryTransfer) {
    }

    @Override
    public boolean hasPageLeftButton() {
        return this.entryPage > 0;
    }

    @Override
    public void onPageLeftButtonPressed() {
        this.field_146297_k.func_147108_a((GuiScreen)new GuiEntry(this.book, this.previousScreen, this.parentPage, this.entry, this.entryPage - 1, this.searchText, this.searchField.func_146206_l()));
    }

    @Override
    public boolean hasPageRightButton() {
        return !this.chapters.isEmpty() && this.entryPage < this.pageAmount - 1;
    }

    @Override
    public void onPageRightButtonPressed() {
        this.field_146297_k.func_147108_a((GuiScreen)new GuiEntry(this.book, this.previousScreen, this.parentPage, this.entry, this.entryPage + 1, this.searchText, this.searchField.func_146206_l()));
    }

    @Override
    public boolean hasBackButton() {
        return true;
    }

    @Override
    public void onBackButtonPressed() {
        if (!GuiEntry.func_146272_n()) {
            this.field_146297_k.func_147108_a((GuiScreen)this.parentPage);
        } else {
            super.onBackButtonPressed();
        }
    }
}

