/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.item;

import com.charles445.simpledifficulty.api.SDCapabilities;
import com.charles445.simpledifficulty.api.config.QuickConfig;
import com.charles445.simpledifficulty.api.config.ServerConfig;
import com.charles445.simpledifficulty.api.config.ServerOptions;
import com.charles445.simpledifficulty.api.item.IItemCanteen;
import com.charles445.simpledifficulty.api.thirst.IThirstCapability;
import com.charles445.simpledifficulty.api.thirst.ThirstEnum;
import com.charles445.simpledifficulty.api.thirst.ThirstEnumBlockPos;
import com.charles445.simpledifficulty.api.thirst.ThirstUtil;
import com.charles445.simpledifficulty.item.ItemDrinkBase;
import com.charles445.simpledifficulty.util.SoundUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCanteen
extends ItemDrinkBase
implements IItemCanteen {
    public static final String CANTEENTYPE = "CanteenType";
    public static final String DOSES = "Doses";

    public ItemCanteen() {
        this.func_77625_d(1);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack emptyCanteen = new ItemStack((Item)this, 1, 0);
            this.createTypeTag(emptyCanteen);
            this.setCanteenEmpty(emptyCanteen);
            ItemStack fullCanteen = emptyCanteen.func_77946_l();
            this.setCanteenFull(fullCanteen);
            ItemStack purifiedCanteen = fullCanteen.func_77946_l();
            this.setTypeTag(purifiedCanteen, ThirstEnum.PURIFIED.ordinal());
            items.add((Object)emptyCanteen);
            items.add((Object)fullCanteen);
            items.add((Object)purifiedCanteen);
        }
    }

    public String func_77667_c(ItemStack stack) {
        if (this.isCanteenEmpty(stack)) {
            return "item.simpledifficulty:canteen_empty";
        }
        int type = this.getTypeTag(stack).func_150287_d();
        if (type >= ThirstEnum.values().length) {
            return "item.simpledifficulty:canteen_broken";
        }
        return "item.simpledifficulty:canteen_" + ThirstEnum.values()[type].toString();
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        IThirstCapability capability;
        ThirstEnumBlockPos traceBlockPos;
        ItemStack stack = player.func_184586_b(hand);
        int typetag = this.getTypeTag(stack).func_150287_d();
        if (!(this.isCanteenFull(stack) && typetag != ThirstEnum.NORMAL.ordinal() || (traceBlockPos = ThirstUtil.traceWater(player)) == null)) {
            ThirstEnum trace = traceBlockPos.thirstEnum;
            if (trace == ThirstEnum.PURIFIED) {
                player.field_70170_p.func_175698_g(traceBlockPos.pos);
            }
            if (trace == ThirstEnum.RAIN) {
                trace = ThirstEnum.NORMAL;
            }
            this.tryAddDose(stack, trace);
            SoundUtil.commonPlayPlayerSound(player, SoundEvents.field_187630_M);
            player.func_184598_c(hand);
            player.func_184609_a(hand);
            player.func_184597_cx();
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (!(this.isCanteenEmpty(stack) || !(capability = SDCapabilities.getThirstData(player)).isThirsty() && QuickConfig.isThirstEnabled())) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    @Override
    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (world.field_72995_K || !(entityLiving instanceof EntityPlayer)) {
            return stack;
        }
        if (this.isCanteenEmpty(stack)) {
            return stack;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        ThirstUtil.takeDrink(player, this.getThirstLevel(stack), this.getSaturationLevel(stack), this.getDirtyChance(stack));
        this.removeDose(stack);
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        int max = this.getMaxDoses(stack);
        tooltip.add(I18n.func_135052_a((String)"item.durability", (Object[])new Object[]{this.getDoses(stack), max}));
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double max = this.getMaxDoses(stack);
        if (max == 0.0) {
            return 1.0;
        }
        return (max - (double)this.getDoses(stack)) / max;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !this.isCanteenEmpty(stack);
    }

    @Override
    public int getThirstLevel(ItemStack stack) {
        ThirstEnum thirstEnum = this.getThirstEnum(stack);
        return thirstEnum == null ? 0 : thirstEnum.getThirst();
    }

    @Override
    public float getSaturationLevel(ItemStack stack) {
        ThirstEnum thirstEnum = this.getThirstEnum(stack);
        return thirstEnum == null ? 0.0f : thirstEnum.getSaturation();
    }

    @Override
    public float getDirtyChance(ItemStack stack) {
        ThirstEnum thirstEnum = this.getThirstEnum(stack);
        return thirstEnum == null ? 0.0f : thirstEnum.getThirstyChance();
    }

    @Override
    @Nullable
    public ThirstEnum getThirstEnum(ItemStack stack) {
        int type = this.getTypeTag(stack).func_150287_d();
        if (type >= ThirstEnum.values().length) {
            return null;
        }
        return ThirstEnum.values()[type];
    }

    protected NBTTagInt getTypeTag(ItemStack stack) {
        NBTBase tag;
        if (stack.func_77978_p() == null) {
            this.createTypeTag(stack);
            this.setCanteenEmpty(stack);
        }
        if ((tag = stack.func_77978_p().func_74781_a(CANTEENTYPE)) instanceof NBTTagInt) {
            return (NBTTagInt)tag;
        }
        stack.func_77978_p().func_82580_o(CANTEENTYPE);
        this.createTypeTag(stack);
        return new NBTTagInt(ThirstEnum.NORMAL.ordinal());
    }

    protected void setTypeTag(ItemStack stack, ThirstEnum thirstEnum) {
        this.setTypeTag(stack, thirstEnum.ordinal());
    }

    protected void setTypeTag(ItemStack stack, int tag) {
        stack.func_77983_a(CANTEENTYPE, (NBTBase)new NBTTagInt(tag));
    }

    protected void createTypeTag(ItemStack stack) {
        this.setTypeTag(stack, ThirstEnum.NORMAL.ordinal());
    }

    protected NBTTagInt getDosesTag(ItemStack stack) {
        NBTBase tag;
        if (stack.func_77978_p() == null) {
            this.createDosesTag(stack);
            this.setCanteenEmpty(stack);
        }
        if ((tag = stack.func_77978_p().func_74781_a(DOSES)) instanceof NBTTagInt) {
            return (NBTTagInt)tag;
        }
        stack.func_77978_p().func_82580_o(DOSES);
        this.createDosesTag(stack);
        return new NBTTagInt(0);
    }

    protected void setDosesTag(ItemStack stack, int doses) {
        stack.func_77983_a(DOSES, (NBTBase)new NBTTagInt(doses));
    }

    protected void createDosesTag(ItemStack stack) {
        this.setDosesTag(stack, 0);
    }

    @Override
    public int getDoses(ItemStack stack) {
        return this.getDosesTag(stack).func_150287_d();
    }

    @Override
    public int getMaxDoses(ItemStack stack) {
        return ServerConfig.instance.getInteger(ServerOptions.CANTEEN_DOSES);
    }

    @Override
    public boolean isCanteenFull(ItemStack stack) {
        return this.getDoses(stack) >= this.getMaxDoses(stack);
    }

    @Override
    public boolean isCanteenEmpty(ItemStack stack) {
        return this.getDoses(stack) <= 0;
    }

    @Override
    public void setCanteenFull(ItemStack stack) {
        this.setDosesInternal(stack, this.getMaxDoses(stack));
    }

    @Override
    public void setCanteenEmpty(ItemStack stack) {
        this.setDosesInternal(stack, 0);
    }

    @Override
    public void removeDose(ItemStack stack) {
        if (!this.isCanteenEmpty(stack)) {
            this.setDosesInternal(stack, this.getDoses(stack) - 1);
        }
    }

    @Override
    public void setDoses(ItemStack stack, int amount) {
        this.setDosesInternal(stack, amount);
    }

    @Override
    public void setDoses(ItemStack stack, ThirstEnum thirstEnum, int amount) {
        this.formatCanteen(stack, thirstEnum);
        this.setDosesInternal(stack, amount);
    }

    @Override
    public boolean tryAddDose(ItemStack stack, ThirstEnum thirstEnum) {
        int oldDamage = this.getDoses(stack);
        if (oldDamage < 0) {
            oldDamage = 0;
        }
        boolean format = this.formatCanteen(stack, thirstEnum);
        if (thirstEnum == ThirstEnum.NORMAL) {
            this.setDosesInternal(stack, this.getMaxDoses(stack));
        } else {
            this.setDosesInternal(stack, this.getDoses(stack) + 1);
        }
        return format || this.getDoses(stack) != oldDamage;
    }

    protected boolean formatCanteen(ItemStack stack, ThirstEnum thirstEnum) {
        if (thirstEnum != this.getThirstEnum(stack)) {
            this.setCanteenEmpty(stack);
            this.setTypeTag(stack, thirstEnum);
            return true;
        }
        this.getDoses(stack);
        return false;
    }

    protected void setDosesInternal(ItemStack stack, int amount) {
        if (amount <= 0) {
            this.setDosesTag(stack, 0);
            return;
        }
        int max = this.getMaxDoses(stack);
        if (amount > max) {
            this.setDosesTag(stack, max);
            return;
        }
        this.setDosesTag(stack, amount);
    }
}

