/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.config;

import com.charles445.simpledifficulty.SimpleDifficulty;
import com.charles445.simpledifficulty.api.config.ClientConfig;
import com.charles445.simpledifficulty.api.config.ClientOptions;
import com.charles445.simpledifficulty.api.config.ServerConfig;
import com.charles445.simpledifficulty.api.config.ServerOptions;
import com.charles445.simpledifficulty.config.compat.ConfigServerCompatibility;
import com.charles445.simpledifficulty.network.MessageConfigLAN;
import com.charles445.simpledifficulty.network.MessageUpdateConfig;
import com.charles445.simpledifficulty.network.PacketHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Config(modid="simpledifficulty")
public class ModConfig {
    @Config.Comment(value={"Client configuration"})
    @Config.Name(value="Client")
    public static final ConfigClientConfig client = new ConfigClientConfig();
    @Config.Comment(value={"Server configuration"})
    @Config.Name(value="Server")
    public static final ConfigServerConfig server = new ConfigServerConfig();

    public static void sendLocalClientConfigToAPI() {
        ClientConfig.instance.put(ClientOptions.DEBUG, ModConfig.client.clientdebug);
        ClientConfig.instance.put(ClientOptions.DRAW_THIRST_SATURATION, ModConfig.client.drawThirstSaturation);
        ClientConfig.instance.put(ClientOptions.ENABLE_THERMOMETER, ModConfig.client.thermometer.enableThermometer);
        ClientConfig.instance.put(ClientOptions.ALTERNATE_TEMP, ModConfig.client.alternateTemp);
        ClientConfig.instance.put(ClientOptions.HUD_THERMOMETER, ModConfig.client.thermometer.hudThermometer);
        ClientConfig.instance.put(ClientOptions.HUD_THERMOMETERX, ModConfig.client.thermometer.hudThermometerX);
        ClientConfig.instance.put(ClientOptions.HUD_THERMOMETERY, ModConfig.client.thermometer.hudThermometerY);
        ClientConfig.instance.put(ClientOptions.TEMPERATURE_READOUT, ModConfig.client.temperatureReadout);
        ClientConfig.instance.put(ClientOptions.CLASSICHUD_TEMPERATURE, ModConfig.client.classicHUDTemperature);
        ClientConfig.instance.put(ClientOptions.CLASSICHUD_THIRST, ModConfig.client.classicHUDThirst);
        ClientConfig.instance.put(ClientOptions.HEATER_PARTICLES, ModConfig.client.heaterParticles);
    }

    public static void sendLocalServerConfigToAPI() {
        ServerConfig.instance.put(ServerOptions.DEBUG, ModConfig.server.debug);
        ServerConfig.instance.put(ServerOptions.THIRST_ENABLED, ModConfig.server.thirstEnabled);
        ServerConfig.instance.put(ServerOptions.THIRST_DRINK_BLOCKS, ModConfig.server.thirstDrinkBlocks);
        ServerConfig.instance.put(ServerOptions.THIRST_DRINK_RAIN, ModConfig.server.thirstDrinkRain);
        ServerConfig.instance.put(ServerOptions.PEACEFUL_DANGER, ModConfig.server.peacefulDanger);
        ServerConfig.instance.put(ServerOptions.TEMPERATURE_ENABLED, ModConfig.server.temperatureEnabled);
        ServerConfig.instance.put(ServerOptions.TEMPERATURE_TE_ENABLED, ModConfig.server.temperatureTEEnabled);
        ServerConfig.instance.put(ServerOptions.CANTEEN_DOSES, ModConfig.server.canteenDoses);
        ServerConfig.instance.put(ServerOptions.STRICT_HEATERS, ModConfig.server.strictHeaters);
        ServerConfig.instance.put(ServerOptions.IRON_CANTEEN_DOSES, ModConfig.server.ironCanteenDoses);
        ServerConfig.instance.put(ServerOptions.INFINITE_PURIFIED_WATER, ModConfig.server.infinitePurifiedWater);
    }

    private static MessageUpdateConfig getNewConfigMessage() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a(ServerOptions.DEBUG.getName(), "" + ModConfig.server.debug);
        compound.func_74778_a(ServerOptions.THIRST_ENABLED.getName(), "" + ModConfig.server.thirstEnabled);
        compound.func_74778_a(ServerOptions.THIRST_DRINK_BLOCKS.getName(), "" + ModConfig.server.thirstDrinkBlocks);
        compound.func_74778_a(ServerOptions.THIRST_DRINK_RAIN.getName(), "" + ModConfig.server.thirstDrinkRain);
        compound.func_74778_a(ServerOptions.PEACEFUL_DANGER.getName(), "" + ModConfig.server.peacefulDanger);
        compound.func_74778_a(ServerOptions.TEMPERATURE_ENABLED.getName(), "" + ModConfig.server.temperatureEnabled);
        compound.func_74778_a(ServerOptions.TEMPERATURE_TE_ENABLED.getName(), "" + ModConfig.server.temperatureTEEnabled);
        compound.func_74778_a(ServerOptions.CANTEEN_DOSES.getName(), "" + ModConfig.server.canteenDoses);
        compound.func_74778_a(ServerOptions.STRICT_HEATERS.getName(), "" + ModConfig.server.strictHeaters);
        compound.func_74778_a(ServerOptions.IRON_CANTEEN_DOSES.getName(), "" + ModConfig.server.ironCanteenDoses);
        compound.func_74778_a(ServerOptions.INFINITE_PURIFIED_WATER.getName(), "" + ModConfig.server.infinitePurifiedWater);
        return new MessageUpdateConfig(compound);
    }

    public static void sendServerConfigToPlayer(EntityPlayerMP player) {
        SimpleDifficulty.logger.info("Sending Configuration to player: " + player.func_70005_c_());
        PacketHandler.instance.sendTo((IMessage)ModConfig.getNewConfigMessage(), player);
    }

    public static void sendServerConfigToAllPlayers() {
        SimpleDifficulty.logger.info("Sending Configuration to all players");
        PacketHandler.instance.sendToAll((IMessage)ModConfig.getNewConfigMessage());
    }

    @Mod.EventBusSubscriber(modid="simpledifficulty")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("simpledifficulty")) {
                ConfigManager.sync((String)"simpledifficulty", (Config.Type)Config.Type.INSTANCE);
                ModConfig.sendLocalClientConfigToAPI();
                if (event.isWorldRunning()) {
                    MessageConfigLAN message = new MessageConfigLAN();
                    PacketHandler.instance.sendToServer((IMessage)message);
                } else {
                    ModConfig.sendLocalServerConfigToAPI();
                }
            }
        }
    }

    public static class ConfigClientConfig {
        @Config.Comment(value={"Thermometer Configuration"})
        @Config.Name(value="Thermometer")
        public final ConfigClientThermometer thermometer = new ConfigClientThermometer();
        @Config.Comment(value={"Whether the alternate temperature display is enabled"})
        @Config.Name(value="AlternateTemperature")
        public boolean alternateTemp = true;
        @Config.Comment(value={"Whether to draw thirst saturation on the HUD"})
        @Config.Name(value="DrawThirstSaturation")
        public boolean drawThirstSaturation = true;
        @Config.Comment(value={"Debug mode for clients"})
        @Config.Name(value="Client DebugMode")
        public boolean clientdebug = false;
        @Config.Comment(value={"Debug temperature readout"})
        @Config.Name(value="TemperatureReadout")
        public boolean temperatureReadout = false;
        @Config.Comment(value={"Enables the classic temperature icon"})
        @Config.Name(value="ClassicHUDTemperature")
        public boolean classicHUDTemperature = false;
        @Config.Comment(value={"Enables the classic thirst bar"})
        @Config.Name(value="ClassicHUDThirst")
        public boolean classicHUDThirst = false;
        @Config.Comment(value={"Enables chiller and heater particles"})
        @Config.Name(value="HeaterParticles")
        public boolean heaterParticles = true;

        public class ConfigClientThermometer {
            @Config.Comment(value={"Whether thermometers display the correct temperature. Only disable this if you are trying to determine what's lagging."})
            @Config.Name(value="EnableThermometer")
            public boolean enableThermometer = true;
            @Config.Comment(value={"Whether thermometers in your inventory will display on your HUD"})
            @Config.Name(value="HUDThermometer")
            public boolean hudThermometer = true;
            @Config.Comment(value={"How far left or right the Thermometer HUD is from the default position"})
            @Config.Name(value="XOffset")
            public int hudThermometerX = 0;
            @Config.Comment(value={"How far up or down the Thermometer HUD is from the default position"})
            @Config.Name(value="YOffset")
            public int hudThermometerY = 0;
        }
    }

    public static class ConfigServerConfig {
        @Config.Comment(value={"Built-in mod compatibility options"})
        @Config.Name(value="Compatibility")
        public final ConfigServerCompatibility compatibility = new ConfigServerCompatibility();
        @Config.Comment(value={"Miscellaneous gameplay configurations"})
        @Config.Name(value="Miscellaneous")
        public final ConfigMiscellaneous miscellaneous = new ConfigMiscellaneous();
        @Config.Comment(value={"Temperature related configurations"})
        @Config.Name(value="Temperature")
        public final ConfigTemperature temperature = new ConfigTemperature();
        @Config.Comment(value={"Thirst related configurations"})
        @Config.Name(value="Thirst")
        public final ConfigThirst thirst = new ConfigThirst();
        @Config.Comment(value={"Whether thirst is enabled."})
        @Config.Name(value="ThirstEnabled")
        public boolean thirstEnabled = true;
        @Config.Comment(value={"Whether the player is allowed to drink from normal water blocks."})
        @Config.Name(value="ThirstDrinkBlocks")
        public boolean thirstDrinkBlocks = true;
        @Config.Comment(value={"Whether the player is allowed to drink from the rain."})
        @Config.Name(value="ThirstDrinkRain")
        public boolean thirstDrinkRain = true;
        @Config.Comment(value={"Whether the mod should be dangerous on Peaceful difficulty."})
        @Config.Name(value="PeacefulDanger")
        public boolean peacefulDanger = false;
        @Config.Comment(value={"Whether temperature is enabled."})
        @Config.Name(value="TemperatureEnabled")
        public boolean temperatureEnabled = true;
        @Config.Comment(value={"Whether temperature tile entities are enabled."})
        @Config.Name(value="TemperatureTileEntities")
        public boolean temperatureTEEnabled = true;
        @Config.Comment(value={"Maximum number of doses in a canteen"})
        @Config.Name(value="CanteenDoses")
        @Config.RangeInt(min=1)
        public int canteenDoses = 3;
        @Config.Comment(value={"Whether heaters and chillers only work indoors"})
        @Config.Name(value="StrictHeaters")
        public boolean strictHeaters = true;
        @Config.Comment(value={"Maximum number of doses in an iron canteen"})
        @Config.Name(value="IronCanteenDoses")
        @Config.RangeInt(min=1)
        public int ironCanteenDoses = 8;
        @Config.Comment(value={"Whether purified water blocks are infinite"})
        @Config.Name(value="Infinite Purified Water")
        public boolean infinitePurifiedWater = false;
        @Config.Comment(value={"Spams chat with debug messages, do not enable this unless you are testing!"})
        @Config.Name(value="DebugMode")
        public boolean debug = false;

        public class ConfigThirst {
            @Config.Comment(value={"Thirst Exhaustion Limit - How exhausted the player must get before they lose thirst."})
            @Config.Name(value="ThirstExhaustionLimit")
            @Config.RangeDouble(min=1.0)
            public double thirstExhaustionLimit = 4.0;
            @Config.Comment(value={"Thirsty Strength - Strength of the Thirsty Effect"})
            @Config.Name(value="ThirstyStrength")
            @Config.RangeDouble(min=0.0)
            public double thirstyStrength = 0.025;
            @Config.Comment(value={"Thirst Attacking - How exhausting attacking enemies is"})
            @Config.Name(value="ThirstAttacking")
            @Config.RangeDouble(min=0.0)
            public double thirstAttacking = 0.3;
            @Config.Comment(value={"Thirst Break Block - How exhausting breaking blocks is"})
            @Config.Name(value="ThirstBreakBlock")
            @Config.RangeDouble(min=0.0)
            public double thirstBreakBlock = 0.025;
            @Config.Comment(value={"Thirst Sprint Jump - How exhausting jumping while sprinting is"})
            @Config.Name(value="ThirstSprintJump")
            @Config.RangeDouble(min=0.0)
            public double thirstSprintJump = 0.8;
            @Config.Comment(value={"Thirst Jump - How exhausting jumping without sprinting is"})
            @Config.Name(value="ThirstJump")
            @Config.RangeDouble(min=0.0)
            public double thirstJump = 0.2;
            @Config.Comment(value={"Thirst Base Movement - How exhausting any kind of movement is"})
            @Config.Name(value="ThirstBaseMovement")
            @Config.RangeDouble(min=0.0)
            public double thirstBaseMovement = 0.01;
            @Config.Comment(value={"Thirst Swimming Movement - How exhausting swimming movement is"})
            @Config.Name(value="ThirstSwimmingMovement")
            @Config.RangeDouble(min=0.0)
            public double thirstSwimmingMovement = 0.015;
            @Config.Comment(value={"Thirst Sprinting Movement - How exhausting sprinting movement is"})
            @Config.Name(value="ThirstSprintingMovement")
            @Config.RangeDouble(min=0.0)
            public double thirstSprintingMovement = 0.1;
            @Config.Comment(value={"Thirst Walking Movement - How exhausting walking movement is"})
            @Config.Name(value="ThirstWalkingMovement")
            @Config.RangeDouble(min=0.0)
            public double thirstWalkingMovement = 0.01;
            @Config.Comment(value={"Whether the player can get parasites from drinking unclean water"})
            @Config.Name(value="ThirstParasites")
            public boolean thirstParasites = false;
            @Config.Comment(value={"The chance of parasites from drinking unclean water"})
            @Config.Name(value="ThirstParasitesChance")
            @Config.RangeDouble(min=0.0, max=1.0)
            public double thirstParasitesChance = 0.04;
            @Config.Comment(value={"The duration parasites last"})
            @Config.Name(value="ThirstParasitesDuration")
            @Config.RangeInt(min=1)
            public int thirstParasitesDuration = 1200;
            @Config.Comment(value={"How strongly parasites make a player hungry (0.005 is same speed as hunger, 0 to disable"})
            @Config.Name(value="ThirstParasitesHunger")
            @Config.RangeDouble(min=0.0)
            public double thirstParasitesHunger = 0.02;
            @Config.Comment(value={"The chance a player takes damage from parasites (1 is poison speed, 0 to disable)"})
            @Config.Name(value="ThirstParasitesDamage")
            @Config.RangeDouble(min=0.0, max=1.0)
            public double thirstParasitesDamage = 0.2;
            @Config.Comment(value={"Thirst Damage Scaling - Extra damage from dehydration over time"})
            @Config.Name(value="ThirstDamageScaling")
            @Config.RangeDouble(min=0.0)
            public double thirstDamageScaling = 0.0;
        }

        public class ConfigTemperature {
            @Config.Comment(value={"Altitude Temperature Multiplier - How strongly altitude affects temperature"})
            @Config.Name(value="AltitudeMultiplier")
            @Config.RangeInt
            public int altitudeMultiplier = 3;
            @Config.Comment(value={"Biome Temperature Multiplier - The maximum temperature change in any biome"})
            @Config.Name(value="BiomeMultiplier")
            @Config.RangeInt
            public int biomeMultiplier = 10;
            @Config.Comment(value={"Underground Effect - Whether being deep underground reduces some surface temperature effects"})
            @Config.Name(value="UndergroundEffect")
            public boolean undergroundEffect = true;
            @Config.Comment(value={"Underground Effect Cutoff - Y Level where surface temperature effects do nothing"})
            @Config.Name(value="UndergroundEffectCutoff")
            @Config.RangeInt(min=0, max=64)
            public int undergroundEffectCutoff = 30;
            @Config.Comment(value={"Time Temperature Multiplier - How strongly time affects temperature"})
            @Config.Name(value="TimeMultiplier")
            @Config.RangeInt
            public int timeMultiplier = 3;
            @Config.Comment(value={"Time Temperature Day - Whether time changes temperature during the day"})
            @Config.Name(value="TimeTemperatureDay")
            public boolean timeTemperatureDay = true;
            @Config.Comment(value={"Time Temperature Night - Whether time changes temperature during the night"})
            @Config.Name(value="TimeTemperatureNight")
            public boolean timeTemperatureNight = true;
            @Config.Comment(value={"Time Temperature Shade - Effect of shade on time temperature, only applies when time temperature is hot"})
            @Config.Name(value="TimeTemperatureShade")
            public int timeTemperatureShade = -2;
            @Config.Comment(value={"Time Biome Temperature Multiplier - How strongly different biomes effect day/night temperature"})
            @Config.Name(value="TimeBiomeMultiplier")
            @Config.RangeDouble(min=1.0, max=1000000.0)
            public double timeBiomeMultiplier = 1.25;
            @Config.Comment(value={"Snow Temperature Value - Effect of snowfall on temperature"})
            @Config.Name(value="SnowValue")
            @Config.RangeInt
            public int snowValue = -10;
            @Config.Comment(value={"Sprinting Temperature Value - Effect of sprinting on temperature"})
            @Config.Name(value="SprintingValue")
            @Config.RangeInt
            public int sprintingValue = 3;
            @Config.Comment(value={"Wet Temperature Value - Effect of being wet on temperature"})
            @Config.Name(value="WetValue")
            @Config.RangeInt
            public int wetValue = -7;
            @Config.Comment(value={"Temperature Max Speed - Maximum time in ticks for a player temperature change"})
            @Config.Name(value="TemperatureTickMax")
            @Config.RangeInt(min=20)
            public int temperatureTickMax = 400;
            @Config.Comment(value={"Temperature Min Speed - Minimum time in ticks for a player temperature change"})
            @Config.Name(value="TemperatureTickMin")
            @Config.RangeInt(min=20)
            public int temperatureTickMin = 20;
            @Config.Comment(value={"TemperatureTickDangerBoost - How much faster in ticks temperature changes happen when escaping dangerous temperatures"})
            @Config.Name(value="TemperatureTickDangerBoost")
            @Config.RangeInt(min=0)
            public int temperatureTickDangerBoost = 60;
            @Config.Comment(value={"Enchantment Temperature Change - Effect of temperature enchantments"})
            @Config.Name(value="EnchantmentTemperature")
            @Config.RangeInt
            public int enchantmentTemperature = 1;
            @Config.Comment(value={"Heater Temperature Change - Strength of heaters / chillers"})
            @Config.Name(value="HeaterTemperature")
            @Config.RangeInt(min=-1000000, max=1000000)
            public int heaterTemperature = 10;
            @Config.Comment(value={"Heater Full Power Range - Distance where a heater / chiller starts to lose strength"})
            @Config.Name(value="HeaterFullPowerRange")
            @Config.RangeDouble(min=0.0, max=50.0)
            public double heaterFullPowerRange = 16.0;
            @Config.Comment(value={"Heater Max Range - Distance where a heater / chiller has no effect"})
            @Config.Name(value="HeaterMaxRange")
            @Config.RangeDouble(min=0.0, max=50.0)
            public double heaterMaxRange = 32.0;
            @Config.Comment(value={"Blocks Tiles Separate - Whether blocks and tile entities should have temperature calculated separately, for example, if this is set to true heaters and campfires will both add their heat individually"})
            @Config.Name(value="BlocksTilesSeparate")
            public boolean blocksTilesSeparate = true;
            @Config.Comment(value={"Stacking Temperature - Whether multiple blocks in a vicinity should combine their effect"})
            @Config.Name(value="StackingTemperature")
            public boolean stackingTemperature = true;
            @Config.Comment(value={"Stacking Temperature Limit - How much more extreme block temperature can be from stacking temperature"})
            @Config.Name(value="StackingTemperatureLimit")
            @Config.RangeDouble(min=0.0, max=1000000.0)
            public double stackingTemperatureLimit = 3.0;
            @Config.Comment(value={"Temperature Damage Scaling - Extra damage from hyperthermia and hypothermia over time"})
            @Config.Name(value="TemperatureDamageScaling")
            @Config.RangeDouble(min=0.0)
            public double temperatureDamageScaling = 0.0;
            @Config.Comment(value={"TemperatureDamageDuration - Duration in ticks of hypothermia and hyperthermia"})
            @Config.Name(value="TemperatureDamageDuration")
            @Config.RangeInt(min=0)
            public int temperatureDamageDuration = 400;
        }

        public class ConfigMiscellaneous {
            @Config.Comment(value={"Campfire has a 1/X chance to lose fuel when ticked (default is 2, a 1/2 chance"})
            @Config.Name(value="CampfireDecayChance")
            @Config.RangeInt(min=1)
            public int campfireDecayChance = 2;
            @Config.Comment(value={"Campfire has a 1/X chance to ignite with a stick (default is 5, a 1/5 chance"})
            @Config.Name(value="CampfireStickIgniteChance")
            @Config.RangeInt(min=1)
            public int campfireStickIgniteChance = 5;
            @Config.Comment(value={"How many seconds it takes for a campfire spit to cook food"})
            @Config.Name(value="CampfireSpitDelay")
            @Config.RangeInt(min=1)
            public int campfireSpitDelay = 35;
            @Config.Comment(value={"How many pieces of food can fit on a campfire spit (any existing spits won't change size)"})
            @Config.Name(value="CampfireSpitSize")
            @Config.RangeInt(min=1, max=10)
            public int campfireSpitSize = 3;
            @Config.Comment(value={"Should cooking food on a campfire spit give experience like a furnace"})
            @Config.Name(value="CampfireSpitExperience")
            public boolean campfireSpitExperience = true;
            @Config.Comment(value={"Blacklisted items in the campfire spit (ex. minecraft:beef"})
            @Config.Name(value="CampfireSpitBlacklist")
            public String[] campfireSpitBlacklist = new String[0];
            @Config.Comment(value={"Whether the campfire spit blacklist is a whitelist instead"})
            @Config.Name(value="CampfireSpitBlacklistIsWhitelist")
            public boolean campfireSpitBlacklistIsWhitelist = false;
            @Config.Comment(value={"Whether Golden Apple Juice gives the golden apple effect"})
            @Config.Name(value="GoldenAppleJuiceEffect")
            public boolean goldenAppleJuiceEffect = true;
            @Config.Comment(value={"Whether Ice Blocks drop Ice Chunks"})
            @Config.Name(value="IceDropsChunks")
            public boolean iceDropsChunks = true;
            @Config.Comment(value={"Whether Magma Blocks drop Magma Chunks"})
            @Config.Name(value="MagmaDropsChunks")
            public boolean magmaDropsChunks = true;
            @Config.Comment(value={"Chance for rain collector to fill (1/n chance, default is 6"})
            @Config.Name(value="RainCollectorFillChance")
            @Config.RangeInt(min=1)
            public int rainCollectorFillChance = 6;
            @Config.Comment(value={"Whether to register the cooling and heating enchantments"})
            @Config.Name(value="RegisterEnchantments")
            @Config.RequiresMcRestart
            public boolean registerEnchantments = true;
            @Config.Comment(value={"Duration of short heat/cold resistance potions, in ticks"})
            @Config.Name(value="ResistancePotionDurationShort")
            @Config.RequiresMcRestart
            @Config.RangeInt(min=1)
            public int resistancePotionDurationShort = 1200;
            @Config.Comment(value={"Duration of long heat/cold resistance potions, in ticks"})
            @Config.Name(value="ResistancePotionDurationLong")
            @Config.RequiresMcRestart
            @Config.RangeInt(min=1)
            public int resistancePotionDurationLong = 2400;
            @Config.Comment(value={"How often player temperature and thirst are regularly synced, in ticks"})
            @Config.Name(value="RoutinePacketDelay")
            @Config.RangeInt(min=0)
            public int routinePacketDelay = 30;
        }
    }
}

