/*
 * Decompiled with CFR 0.152.
 */
package meldexun.renderlib.util.memory;

import java.nio.ShortBuffer;
import meldexun.renderlib.util.memory.NIOBufferUtil;
import meldexun.renderlib.util.memory.PrimitiveInfo;
import meldexun.renderlib.util.memory.UnsafeNIOBuffer;

public class UnsafeShortBuffer
extends UnsafeNIOBuffer<ShortBuffer> {
    public UnsafeShortBuffer(long address, long capacity) {
        super(address, PrimitiveInfo.SHORT.toByte(capacity));
    }

    public long getShortCapacity() {
        return PrimitiveInfo.SHORT.fromByte(this.getCapacity());
    }

    @Override
    protected ShortBuffer createBuffer() {
        return NIOBufferUtil.asShortBuffer(this.getAddress(), this.getShortCapacity());
    }
}

